      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. unicode.

       REMARKS. national data are stored using the utf-16-be encoding.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select arc
           assign to    "arc"
           class        "com.iscobol.io.DynamicJIsam"
           organization indexed
           access       dynamic
           lock mode is manual
           record key   arc-k
           status file-status
           .
           
       select print-job assign to printer "-p preview"
           organization line sequential.

       FILE SECTION.
       fd  arc.
       01  arc-r.
           03 arc-k             pic 9.
           03 arc-d             pic n(20).

       FD  print-job.
       01  print-record         pic n(80).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       77  crt-status           special-names crt status pic 9(5).
       77  hWin                 handle of window.
       77  close-win            pic 9 value 0.
       77  ef-clipboard         handle of entry-field.
       01  buffer               pic x(30) 
                                value "101102103104105106107108109110".
       77  exceptions           pic 9(3) occurs 10 redefines buffer.
       01  some-unicode-chars   occurs 10.
           03 char              pic n.
       77  idx                  pic 99.
       77  ef-cursor-pos        pic s9(9).

       77  file-status          pic xx.
       77  fileprefix           pic x any length.
           

       SCREEN SECTION.
       01  Mask.
           03 ef entry-field
              no-autosel
              line               2
              col                2
              size               46
              value              ARC-D
              max-text           20
              width-in-cells
              .
           03 line               4
              col                2
              .
           03 push-button        occurs 10
              self-act
              line               4
              col                + 2
              size               3
              title              char 
              width-in-cells
              exception-value    exceptions
              .
           03 label
              line               6
              col                2
              lines              6
              size               46
              height-in-cells
              width-in-cells
              title              "Use the above buttons or a foreign key
      -                          "board to insert unicode characters int
      -                          "o the field. Data is saved to file whe
      -                          "n the program exits and is read from f
      -                          "ile when the program starts. For a cor
      -                          "rect display the FONT must support the
      -                          "se characters."
              .
           03 push-button
              line                  12
              col                   2
              size                  12
              title                 "Print Preview"
              exception-value       201
              .
           03 Pb-exit  
              push-button
              line                 12
              col                  40 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           move nx"03A0" to char(1).
           move nx"03A3" to char(2).
           move nx"03A9" to char(3).
           move nx"03B1" to char(4).
           move nx"03B2" to char(5).
           move nx"03C8" to char(6).
           move nx"05DE" to char(7).
           move nx"05E7" to char(8).
           move nx"05E9" to char(9).
           move nx"0436" to char(10).

           perform OPEN-FILE.

           move 1 to arc-k.
           start arc key = arc-k
              not invalid 
                 read arc next
                    at end
                       continue
                 end-read
           end-start.
           
           display standard graphical window  
                   background-low
                   with system menu
                   title  "Unicode characters"
                   lines  13
                   size   50  
                   handle hWin
                   event  WIN-EVENTS
           
           display Mask
                      
           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    if crt-status > 100 and < 111
                       perform ADD-TO-FIELD
                    end-if
                    if crt-status = 201
                       perform PRINT-PROCEDURE
                    end-if
              end-accept
           end-perform

           write arc-r
              invalid 
                 rewrite arc-r
           end-write
           close   arc
           destroy Mask 
           destroy hWin
           goback
           .

       PRINT-PROCEDURE.
           open output print-job

           move "Record content:"  to print-record
           write print-record

           move arc-d  to print-record
           write print-record

           close print-job
           .

       ADD-TO-FIELD.
           inquire ef value ARC-D
           if ARC-D(20:1) = space
              display entry-field  visible 0 handle ef-clipboard 
              modify  ef-clipboard value   char(crt-status - 100)
              modify  ef-clipboard cursor -1
              modify  ef-clipboard action  action-copy
              destroy ef-clipboard
              modify  ef           action  action-paste
              inquire ef           cursor  ef-cursor-pos
              add     1            to ef-cursor-pos
              modify  ef           cursor  ef-cursor-pos
           end-if
           .

       WIN-EVENTS.
           if event-type = msg-close
              inquire ef value ARC-D
              set event-action to event-action-fail-terminate
              move 1 to close-win
           end-if
           .
           
       OPEN-FILE.
           call  "C$GETENV" USING "user.home"
                                  fileprefix.

           string fileprefix delimited by trailing space
                  x"0A"    delimited by size
                  "."      delimited by size
                  into fileprefix
           set environment "file.prefix" to fileprefix.
           
           set environment "file.errors_ok" to "1".
           open i-o arc
           set environment "file.errors_ok" to "0".
           if file-status = "35"
              perform CREATE-FILE
              open i-o arc
           end-if
           .

       CREATE-FILE.
           open output arc
           move 1   to arc-k
           initialize arc-d

           string    nx"03B2"
                     nx"03B1"
                     nx"03C8" 
                     into arc-d

           write arc-r

           close arc
           .
