      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. Clock.

       WORKING-STORAGE SECTION.
       copy "isgui.def". 
       01  hWin                    handle of window.
       01  hMain                   handle of thread.
       01  hTime                    handle of thread.
       01  msg-string              pic x(1).
       78  stop-msg                value "X".
       01  crt-status is special-names crt status pic 999.
           88 k-esc                value 27. 
       01  receive-status          pic 99.
       01  system-time             pic 9(8).
       01  time-disp.
        03 h-disp                  pic 99.
        03 filler                  pic x value ":".
        03 m-disp                  pic 99.         
        03 filler                  pic x value ":".
        03 s-disp                  pic 99.

       SCREEN SECTION.
       01  Scr1.
           03 label        line            2
                           col             2
                           title           "Time: "
                           .
           03 lbTime           
              label        col             + 3
                           size            10      cells
                           .
           03 entry-field  line            4
                           col             2
                           size            12      cells
                           .
           03 push-button  line            6
                           col             2
                           exception-value 27
                           title "&Esc"
                           .

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           accept hMain from thread.

           display standard window background-low
                   lines 10, size 20
                   handle hWin.

           display Scr1.
                  
           perform thread SHOW-TIME handle hTime.

           perform until k-esc
             accept Scr1 on exception continue end-accept
           end-perform.

           send stop-msg to hTime.
           wait for hTime.
           move 0 to hTime.                    

           destroy Scr1.
           destroy hWin.
           goback.
           

       SHOW-TIME.
           perform until 1 = 2
              accept system-time from time
              move system-time(5:2) to s-disp
              move system-time(3:2) to m-disp
              move system-time(1:2) to h-disp
              modify lbTime title time-disp
              receive msg-string from hMain
                 before time 100
                 not on exception  
                    if msg-string = stop-msg
                       exit perform
                    end-if
              end-receive
           end-perform. 

