##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows how to run to the WebClient environment.**
**You must have installed the isCOBOL WebClient to run this sample**

**This sample shows the integration of an HTML menu and Cobol screens.**
**Each menu item starts a new thread on the main webclient process using**
**a "call run" instruction.**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
 **On the isCOBOL application server machine**

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/modernization/webclient/encapsulated" 
     folder.

 - 2 Compile the test programs

        iscc -sp=../../commons -c=compiler-webclient.properties *.cbl
        iscc -sp=../../commons -od=. ../../commons/*.cbl

 **NOTE:**

        The -sp option passes the copybook directories needed to compile the programs
        The -c option is used to pass the name of the configuration file to the compiler
        The -od option specifies the output directory for the generated java classes

 - 3 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

    If you have already started an instance of the Application Server,
    you can start a new instance of it on a different port.
    If you change the port you need to update the webclient.config file accordingly, or edit it using the WebClient admin console.

 **On the WebClient server machine**

 - 1 Using a Webclient's command prompt window go to the "$ISCOBOL/webclient" folder.

 - 2 If the WebClient server is not already running, start it with the following command

        webcclient 

 - 3 Open another Webclient's command prompt

 - 4 If the WebClient Adminstrator service is not already running, start it with the following command

        webcclient-admin

 **NOTE:**

     For development environments you can start the WebClient server and WebClient Admin Console as a single process.
     In order to make this you need to edit the webclient.config file and replace:
     "adminConsoleUrl" : "http://localhost:8090"
     with:
     "adminConsoleUrl" : "http://localhost:8080/admin"

     After this change, you can run
     webcclient-and-admin
     to execute both the webcclient and webclient-admin commands as one."

     The admin link is http://127.0.0.1:8080/admin

 **On the WebClient machine**

 - 1 From your browser open the following url to access the WebClient Administrator panel, changing the address and port to reflect your deployment configuration:

        http://localhost:8090/

 - 2 use the default login credentials

        User: admin 
        Password: admin 

 - 3 Click on **"Applications"**

 - 4 Click on **"+"** and select **"Create new"**

 - 5 Type **"modernization-webclient"** into the field and confirm the creation of the app

 - 6 Click on the **"modernization-webclient"** application on the left side of the window.

 - 7 Fill the configuration fields as follows
     - In the **Web Config** area
       - In the **"General"** section
         - Web Folder: Type the folder that contains the html start page. The folder is located under your iscobol SDK folder, sample/modernization/webclient/encapsulated/html subfolder
       - In the **"Session"** section
         - Session Mode: ALWAYS_NEW_SESSION
     - In the **App Config** area
       - isCOBOL Server address: Type the hostname of your application server
       - isCOBOL Server port: Type the port used by your application server
       - Program name and arguments: MENU

 - 8 Click on  **"Apply"** in the bottom right side of the screen.

 - 9 Click on  **"Enable"** in the upper right side of the screen.

 - 10 Use the following link in a different browser window to test the sample

        http://localhost:8080/modernization-webclient/ 
        changing the address and port to reflect your deployment configuration.

### To debug the programs in this environment follow these instructions:

 - Repeat step 1 of the Stand Alone section

 - Compile the programs

        iscc -sp=copylib -d *.cbl

 **NOTE:**

        The -sp option passes the copybook directories needed to compile 
        the programs

 - Modify the iscobol.properties adding the following property

        iscobol.rundebug=1 

 - Start the application server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 - Using an additional command prompt window and run the remote debugger

        iscrun -d -r <hostname | IP address> <port-number> 

 **NOTE:**

     The remote debugger is started with this command. The debugger is still not 
     activated until the remote program starts

 - Start a new instance of the sample from the browser, navigating to the following URL: 

        http://localhost:8080/samples/ 
        changing the address and port to reflect your deployment configuration.
