      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. IWC.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscoblib.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  control-font               handle of font.
       77  close-win                  pic 9 value 0.
                                            
       77  data-to-send               pic x any length.

       77  op-time                    pic 9(8).

       01  gd-operation-rec.
           05 time-operation          pic x(5).
           05 kind-operation          pic x(10).
           05 result-operation        pic x(50). 

       77  e-disconnect               pic 9 value zero.
       77  e-connect                  pic 9 value 1.

       01  kind-of-result             pic x.
           88 type-error              value "e".
           88 type-ok                 value "o".
           88 type-description        value "d".

       78  78-red                     value x#C40000.
       78  78-green                   value x#00AE00.

      *    WebClient comm. struct.
       01  iwc-struct.
           03 iwc-action              pic x any length.
           03 iwc-data                pic x any length.
           03 iwc-bytes               pic x any length.

       77  env-code                   pic 9.
       78  78-iwc-crt-status          value 1001.
       
       77  check-string               pic x any length.
       77  wrk-time                   pic 9(8).
       
       77  returncode                 pic s99.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              title                "IWC communication"
              line                 2
              col                  2
              lines                4
              size                 68
              .
           03 pb-conect
              push-button 
              line                 4 
              col                  3
              size                 10 cells
              title                "Start"
              exception-value      101
              enabled              e-connect
              .
           03 pb-disconect
              push-button
              line                 4 
              col                  14
              size                 10 cells   
              title                "Stop"
              exception-value      102
              enabled              e-disconnect
              .
           03 frame
              engraved
              title                "Data to send"
              line                 7
              col                  2
              lines                4
              size                 68
              .
           03 label 
              line                 9
              col                  3 
              size                 10 cells
              title                "Data:"
              .
           03 entry-field 
              line                 9 
              col                  10 
              size                 50 cells
              value                data-to-send
              upper
              enabled              e-disconnect
              .
           03 push-button
              line                 9 
              col                  61
              size                 8 cells
              title                "Send"
              exception-value      103
              enabled              e-disconnect
              .
           03 frame
              engraved
              title                "Log"
              line                 12
              col                  2
              lines                7.5
              size                 68
              .
           03 gd
              grid 
              line                 14
              col                  3
              lines                3
              size                 66 cells
              display-columns      (1, 10, 20)
              data-columns         (1, 6, 16)
              alignment            ("C", "L", "L")
              data-types           ("X(5)", "X(10)", "X(50)") 
              protection           1
              Row-Background-Color-Pattern (0, -14675438)
              Vscroll
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  61 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "IWC$ Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

      *    compose a check string for the IWC communication
           accept wrk-time from time
           string "IWC"      delimited by size
                  wrk-time   delimited by size
                  into check-string

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101
                   perform ACTIVATE
              when 102
                   perform DEACTIVATE
              when 103
                   perform SEND-TO-HTML
              when 78-iwc-crt-status
                   perform READ-DATA-FROM-HTML
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       ACTIVATE.
           modify gd reset-grid = 1

           call "IWC$INIT" using 78-iwc-crt-status 
                          giving returncode
           move "IWC$INIT"   to kind-operation
           if returncode = 0
              set type-ok    to true
              move "IWC communication OK" to result-operation
              move zero   to e-connect
              move 1      to e-disconnect
              display mask
           else
              move "Faileid to activate IWC communication"  
                                      to result-operation
           end-if.

           perform SHOW-RESULT.

       DEACTIVATE.
           call "IWC$STOP" giving returncode
           move "IWC$STOP"   to kind-operation
           if returncode = 0
              set type-ok    to true
              move 1      to e-connect
              move zero   to e-disconnect
              display mask
           else
              move "Faileid to close IWC communication"  
                                      to result-operation
           end-if.
           perform SHOW-RESULT.
           .

       SEND-TO-HTML.
           initialize iwc-struct.
           move "ComSample"  to iwc-action
           move data-to-send to iwc-data
           move check-string to iwc-bytes
           call "IWC$SEND" using iwc-struct
                          giving returncode

           move "IWC$SEND"  to kind-operation
           if returncode = 0
              set type-ok       to true
              move data-to-send to result-operation
           else
              set type-error             to true
              move "Failed to send data" to result-operation
           end-if.
           perform SHOW-RESULT.

       READ-DATA-FROM-HTML.
           initialize iwc-action
           call "IWC$GET" using iwc-struct
                         giving returncode
           move "IWC$GET"  to kind-operation
           if returncode not = 0
              set type-error                to true
              move "Failed to receive data" to result-operation
              perform SHOW-RESULT
           else
      *    I'll put on the grid onnlyu the data for me, if the check-string
      *    is different from iwc-bytes the data are for another run unit
              if check-string = iwc-bytes
                 set type-ok to true
                 move iwc-data  to result-operation
                 perform SHOW-RESULT
              end-if
           end-if.

       SHOW-RESULT.
           accept op-time  from time
           initialize time-operation
           string op-time(1:2)   delimited by size
                  ":"            delimited by size
                  op-time(3:2)   delimited by size
                  into time-operation

           modify Gd insertion-index 1.
           modify Gd record-to-add gd-operation-rec
                     cursor-x= 1
                     x = 1.

           evaluate true
           when type-error
                modify gd(1) row-foreground-color rgb 78-red
           when type-ok
                modify gd(1) row-foreground-color rgb 78-green
           end-evaluate.

           set type-description to true.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
