      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CLISTDIR.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.
                               
       77  dirname                 pic x(128). 
       77  filename                pic x(128).
       77  hDir                    handle.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       01  rec-grid-file.
           05 gf-filename                pic x(128).
           05 gf-type                    pic x(16).
           05 gf-date-last-modification  pic x(10).
           05 gf-time-last-modification  pic x(5).
           05 gf-size                    pic z(18).

       01  wrk-time.
           05 wrk-hh               pic 99.
           05 filler               pic x value ":".
           05 wrk-mm               pic 99.

       01  wrk-date.
           05 wrk-d-mm             pic 9(2).
           05 filler               pic x value "/".
           05 wrk-d-dd             pic 9(2).
           05 filler               pic x value "/".
           05 wrk-d-yyyy           pic 9(4).

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label
              line                 4
              col                  2
              size                 4 cells
              title                "Dir:"
              .
           03 ef-dir
              entry-field
              line                 4 
              col                  7 
              size                 52 cells
              max-text             256
              value                dirname
              .
           03 push-button 
              default-button
              line                 4
              col                  60
              size                 10 cells
              title                "Content"
              exception-value      100
              self-act
              .
           03 gd-content
              grid
              column-headings
              Adjustable-Columns
              centered-headings
              sortable-columns
              reordering-columns
              heading-color        257
              vscroll 
              Protection           1
              line                 6
              col                  2
              lines                13 cells
              size                 68 cells
              .
           03 Pb-exit
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.    
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           perform RETRIVE-USER-HOME-DIR
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$LIST-DIRECTORY Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask
           perform SET-GRID

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 100
                   perform DIR-CONTENT
              when 103
                   if rb-value = 2
                      set client-execution   to true
                   else
                      set server-execution   to true
                   end-if
                   perform RETRIVE-USER-HOME-DIR
                   modify gd-content reset-grid 2
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       RETRIVE-USER-HOME-DIR.
           evaluate true
           when client-execution
                call client "C$GETENV" using "user.home"
                                             dirname
           when standalone-execution
           when server-execution
                call "C$GETENV" using "user.home"
                                      dirname
           end-evaluate
           .

       DIR-CONTENT.
           modify gd-content reset-grid 2
           inquire ef-dir value dirname
           if dirname = spaces
              display message "Invalid directory"
                         icon mb-warning-icon 
              exit paragraph
           end-if

           evaluate true
           when client-execution
                call client "C$LIST-DIRECTORY" using listdir-open, 
                                                     dirname, 
                                                     "*"
                                              giving hDir
           when standalone-execution
           when server-execution
                call "C$LIST-DIRECTORY" using listdir-open, 
                                              dirname, 
                                              "*"
                                       giving hDir
           end-evaluate
           if hDir < 1
              display message "Invalid directory"
                         icon mb-warning-icon 
              exit paragraph
           end-if
           perform test after until filename = spaces
              evaluate true
              when client-execution
                   call client "C$LIST-DIRECTORY" 
                                   using listdir-next
                                         hDir
                                         filename
                                         listdir-file-information
              when standalone-execution
              when server-execution
                   call "C$LIST-DIRECTORY" 
                                   using listdir-next
                                         hDir
                                         filename
                                         listdir-file-information
              end-evaluate
              if filename not = space
                 perform SHOW-ITEM
              end-if
           end-perform
           evaluate true
           when client-execution
                call client "C$LIST-DIRECTORY" using listdir-close, hDir
           when standalone-execution
           when server-execution
                call "C$LIST-DIRECTORY" using listdir-close, hDir
           end-evaluate
           .

       WIN-EVT.  
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SHOW-ITEM.
           initialize rec-grid-file
           
           move filename                 to gf-filename
           
           evaluate listdir-file-type
           when "B" 
                move "Block device"      to gf-type
           when "C" 
                move "Character device"  to gf-type
           when "D" 
                move "Directory"         to gf-type
           when "F" 
                move "File"              to gf-type
           when "P" 
                move "Pipe"              to gf-type
           when "S" 
                move "Socket"            to gf-type
           when "U" 
                move "Unknown"           to gf-type
           end-evaluate.

           move ldflm-year   to wrk-d-yyyy
           move ldflm-month  to wrk-d-mm
           move ldflm-day    to wrk-d-dd

           move wrk-date  to gf-date-last-modification


           move ldflm-hour   to wrk-hh
           move ldfc-minute  to wrk-mm

           move wrk-time  to gf-time-last-modification
           
           move listdir-file-size  to gf-size.

           modify gd-content record-to-add rec-grid-file.

       SET-GRID.
           modify gd-content
                  column-dividers ( 1 1 1 1 1 )
                  data-columns (record-position of gf-filename 
                                record-position of gf-type
                                record-position 
                                         of gf-date-last-modification
                                record-position 
                                         of gf-time-last-modification
                                record-position of gf-size
                               )
              display-columns ( 1 25 35 48 55 )
              separation ( 5 5 5 5 5 )
              alignment ( "U" "U" "C" "C" "R" )
              data-types ( "X" "X" "D,MM/dd/yyyy" "X" "9" ).
           
           modify gd-content(1, 1) cell-data = "Name"
           modify gd-content(1, 2) cell-data = "Type"
           modify gd-content(1, 3) cell-data = "Date"
           modify gd-content(1, 4) cell-data = "Time"
           modify gd-content(1, 5) cell-data = "Size".

