      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. ccallerr.

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  err-code                pic xx.
       77  err-text                pic x(64).
       77  extend-text             pic x(128).
      
       SCREEN SECTION.
       01  Mask.     
           03 push-button
              line                 4
              col                  3
              title                "Call non-existing program"
              size                 24 cells
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
               
       PROCEDURE DIVISION.
       MAIN. 
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CALLERR Routine"
                   lines 21 
                   min-lines 21
                   size 70
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept 
              if crt-status = 101
                 call "nonexistent-program"
                    on exception
                       |generic error message
                       call "C$CALLERR" using err-code, 
                                              err-text
                       |extend information
                       set extend-text to
                                      exception-object:>getMessage()
                       display message err-text x"0D0A"
                                       extend-text
                 end-call
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .