      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLBOOLOP.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wstatus                 pic s9. 
       77  source-com              pic x.
       77  dest-com                pic x.
       77  res                     pic x.
       77  source-x8               pic x(8).
       77  dest-x8                 pic x(8).
       77  res-x8                  pic x(8).
       77  p1                      pic x.
       77  p2                      pic x.
       77  l-p1-value              pic x(40).
       77  l-p1-suorce-value       pic x.
       77  l-p1-hex-value          pic x(2).
       77  l-p1-internal-value     pic x(8).
       77  l-p2-value              pic x(40).
       77  l-p2-suorce-value       pic x.
       77  l-p2-hex-value          pic x(2).
       77  l-p2-internal-value     pic x(8).
       77  l-res-value             pic x(40).
       77  l-res-suorce-value      pic x.
       77  l-res-hex-value         pic x(2).
       77  l-res-internal-value    pic x(8).
 
       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  2
              size                 22 cells
              title                "Input the first value" 
              .
           03 entry-field 
              line                 2
              col                  25
              size                 3 cells 
              max-text             1
              value                source-com  
              .
           03 label 
              line                 4 
              col                  2 
              size                 22 cells
              title                "Input the second value"
              .
           03 entry-field 
              line                 4 
              col                  25 
              size                 3 cells
              max-text             1
              value                dest-com 
              .           
           03 push-button 
              line                 7 
              col                  5
              size                 5 cells   
              title                "AND"
              exception-value      101
              self-act
              .
           03 push-button 
              line                 7 
              col                  11
              size                 5 cells   
              title                "EQ"
              exception-value      102
              self-act
              .
           03 push-button 
              line                 7 
              col                  17
              size                 5 cells   
              title                "IMP"
              exception-value      103
              self-act
              .
           03 push-button 
              line                 7 
              col                  23
              size                 5 cells   
              title                "NOT"
              exception-value      104
              self-act
              .
           03 push-button 
              line                 7 
              col                  29
              size                 5 cells
              title                "OR"
              exception-value      105
              .
           03 push-button 
              line                 7 
              col                  35
              size                 5 cells
              title                "XOR"
              exception-value      106
              .
           03 group-result.
              05 label 
                 line              10 
                 col               15
                 title             "Ascii" 
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              10 
                 col               25
                 title             "Hex" 
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              10 
                 col               35
                 title             "Internal bit representation" 
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              12 
                 col               8
                 value             l-p1-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              12 
                 col               17
                 value             l-p1-suorce-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              12 
                 col               25
                 value             l-p1-hex-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              12 
                 col               35
                 size              40 cells
                 value             l-p1-internal-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              14 
                 col               8
                 size              40 cells
                 value             l-p2-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              14 
                 col               17
                 value             l-p2-suorce-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              14 
                 col               25
                 value             l-p2-hex-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              14 
                 col               35
                 size              40 cells
                 value             l-p2-internal-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              16 
                 col               8 
                 size              40 cells
                 value             l-res-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              16
                 col               17
                 value             l-res-suorce-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              16 
                 col               25
                 value             l-res-hex-value
                 font              fixed-font
                 transparent
                 .
              05 label 
                 line              16 
                 col               35
                 size              40 cells
                 value             l-res-internal-value
                 font              fixed-font
                 transparent
                 .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Boolean Operation Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask
              
           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    continue 
              end-accept
              move source-com to p1
              move dest-com   to p2
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                call "CBL_AND" using p1, p2
                              giving wstatus
                move p2 to res
                perform SHOW-RESULT
           when 102
                call "CBL_EQ" using p1, p2
                             giving wstatus
                move p2 to res
                perform SHOW-RESULT
           when 103
                call "CBL_IMP" using p1, p2
                              giving wstatus
                move p2 to res
                perform SHOW-RESULT
           when 104
                call "CBL_NOT" using p1
                              giving wstatus
                move p1 to res
                perform SHOW-RESULT
           when 105
                call "CBL_OR" using p1, p2
                             giving wstatus
                move p2 to res
                perform SHOW-RESULT
           when 106
                call "CBL_XOR" using p1, p2
                              giving wstatus
                move p2 to res
                perform SHOW-RESULT
           end-evaluate.

       SHOW-RESULT.
           if wstatus = 0
              initialize l-p1-value
                         l-p1-suorce-value
                         l-p1-hex-value
                         l-p1-internal-value 
                         l-p2-value
                         l-p2-suorce-value
                         l-p2-hex-value
                         l-p2-internal-value 
                         l-res-value
                         l-res-suorce-value
                         l-res-hex-value
                         l-res-internal-value 

              move function dec2bin ( function ord (source-com) - 1 )
                   to source-x8
              call "C$JUSTIFY" using source-x8, "R"
              inspect source-x8 replacing leading spaces by zeroes

              move "p1  = "     to l-p1-value
              move source-com   to l-p1-suorce-value
              move source-x8    to l-p1-internal-value
              call "ASCII2HEX"  using source-com, l-p1-hex-value

              if crt-status not = 104
                 move function dec2bin ( function ord (dest-com) - 1 )
                      to dest-x8
                 call "C$JUSTIFY" using dest-x8, "R"
                 inspect dest-x8 replacing leading spaces by zeroes
                 move "p2  = "  to l-p2-value
                 move dest-com  to l-p2-suorce-value
                 move dest-x8   to l-p2-internal-value
                 call "ASCII2HEX" using dest-com, l-p2-hex-value
              end-if

              move function dec2bin ( function ord (res) - 1 )
                   to res-x8
              call "C$JUSTIFY" using res-x8, "R"
              inspect res-x8 replacing leading spaces by zeroes
              move "res = "     to l-res-value
              move res          to l-res-suorce-value
              move res-x8       to l-res-internal-value
              call "ASCII2HEX" using res, l-res-hex-value

              display group-result
           else
              display message "Operation Failed!"
                         icon mb-error-icon
           end-if
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .