      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. AUSERINFO.

       WORKING-STORAGE SECTION.
       copy "iscobol.def".
       copy "isresize.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
              
       77  info-to-set             pic x(32).
       77  info-retrieved          pic x(32).
       77  th-id                   pic 9(10).
       77  th-id-ed                pic z(10).
       77  return-code-ed          pic -9.
       77  msg                     pic x any length.
       
       SCREEN SECTION.
       01  Mask.   
           03 label
              line                 2
              col                  2
              title                "Thread ID"
              .           
           03 ef-th-id entry-field  
              line                 2
              col                  25  
              size                 12 cells
              max-text             10
              numeric
              value                th-id
              right
              .
           03 label
              line                 2
              col                  38
              title                "(0 = Current Thread ID)"
              .           

           03 push-button  
              self-act 
              line                 5
              col                  2
              size                 20 cells
              title                "&Store this information:"
              exception-value      101
              .  
           03 entry-field  
              line                 5
              col                  25  
              size                 43 cells
              max-text             32
              value                info-to-set
              .
           03 push-button    
              self-act
              line                 8 
              col                  2
              size                 20 cells 
              title                "&Read information:"
              exception-value      102
              .
           03 ef-get
              entry-field
              read-only
              line                 8
              col                  25
              size                 43 cells
              max-text             32
              .
           03 push-button
              self-act 
              line                 13 
              col                  2
              size                 20 cells
              title                "&Clear information"
              exception-value      103
              .
           03 lb-status
              label
              line                 20
              col                  2
              size                 60 cells
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN. 
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "A$USERINFO Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           accept terminal-abilities from terminal-info
           if not is-remote
              display message 
              "This sample works only in Application Server environment"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status
                    when 101
                         perform SET-INFO
                    when 102
                         perform GET-INFO
                    when 103
                         perform CLEAR-INFO
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       SET-INFO.
           initialize msg

           if th-id = zero
              call "A$USERINFO" using auserinfo-set, 
                                      info-to-set
                               giving return-code
              if return-code = 0
                 move "Information stored for current Thread ID" to msg
              else
                 move return-code  to return-code-ed
                 string "Failed to store information for current "
                                         delimited by size
                        "Thread ID."     delimited by size
                        x"0D0A"          delimited by size
                        "Error code "    delimited by size
                        return-code-ed   delimited by size
                        into msg
                 display message msg
              end-if
           else
              call "A$USERINFO" using auserinfo-set, 
                                      info-to-set
                                      th-id
                               giving return-code
              move th-id  to th-id-ed
              if return-code = 0
                 string "Information stored for Thread ID "
                     th-id-ed   delimited by size
                     into msg
              else
                 move return-code  to return-code-ed
                 string "Failed to store information for Thread ID "
                                                  delimited by size
                        function trim(th-id-ed)   delimited by size
                        x"0D0A"                   delimited by size
                        "Error code "             delimited by size
                        return-code-ed            delimited by size
                        into msg
                 display message msg
              end-if
           end-if
           modify lb-status title msg
           .

       GET-INFO.
           inquire ef-th-id value th-id

           if th-id = zero
      *    retrive the information from the current Thread ID
              call "A$USERINFO" using auserinfo-get, 
                                      info-retrieved
              if return-code = 0
                 move "Information retrieved from current Thread ID"
                             to msg
              else
                 move return-code  to return-code-ed
                 string "Failed to retreive information for current "
                                         delimited by size
                        "Thread ID."     delimited by size
                        x"0D0A"          delimited by size
                        "Error code "    delimited by size
                        return-code-ed   delimited by size
                        into msg
                 display message msg
              end-if
           else
      *    retrive the information from the specified Thread ID
              call "A$USERINFO" using auserinfo-get, 
                                      info-retrieved
                                      th-id
                               giving return-code
              if return-code = 0
                 move th-id  to th-id-ed
                 string "Information retrieved from Thread ID "
                        th-id-ed   delimited by size
                        into msg
              else
                 move th-id        to th-id-ed
                 move return-code  to return-code-ed
                 string "Failed to retreive information from Thread ID "
                                                  delimited by size
                        function trim(th-id-ed)   delimited by size
                        "."                       delimited by size
                        x"0D0A"                   delimited by size
                        "Error code "             delimited by size
                        return-code-ed            delimited by size
                        into msg
                 display message msg 
                 move space  to info-retrieved
              end-if
           end-if.
           
           modify ef-get     value info-retrieved  
           modify lb-status title msg
           .

       CLEAR-INFO.
           inquire ef-th-id value th-id

           if th-id = zero
              call "A$USERINFO" using auserinfo-clear
                               giving return-code
              if return-code = 0
                 move "Information cleared for current Thread ID"
                                                                 to msg
              else
                 move return-code  to return-code-ed
                 string "Failed to retreive information for current "
                                         delimited by size
                        "Thread ID."     delimited by size
                        x"0D0A"          delimited by size
                        "Error code "    delimited by size
                        return-code-ed   delimited by size
                        into msg
                 display message msg
              end-if
           else
      *    clear the information from the specified Thread ID
              call "A$USERINFO" using auserinfo-clear,
                                      th-id
                               giving return-code
              if return-code = 0
                 move th-id  to th-id-ed
                 string "Information cleared for Thread ID "
                        th-id-ed   delimited by size
                        into msg
              else
                 move th-id        to th-id-ed
                 move return-code  to return-code-ed
                 string "Failed to clear information for Thread ID "
                                                  delimited by size
                        function trim(th-id-ed)   delimited by size
                        "."                       delimited by size
                        x"0D0A"                   delimited by size
                        "Error code "             delimited by size
                        return-code-ed            delimited by size
                        into msg
                 display message msg 
              end-if
           end-if.

           move space  to info-retrieved
           modify ef-get     value info-retrieved
           modify lb-status title msg
           . 
            
       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .