      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. rollover-tree-listbox.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       01  tab-album.
      ***
           03 filler               pic x(15) value "Blues".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value 
                                               "Next Time You See Her".
           03 filler               pic x(5)  value "4:02".
           03 filler               pic x(30) value "Slowhand".
           03 filler               pic x(30) value "Polydor".
           03 filler               pic 9(4)  value 1977.
      ***
           03 filler               pic x(15) value "Blues rock".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Bad Love".
           03 filler               pic x(5)  value "6:25".
           03 filler               pic x(30) value "24 Nights".
           03 filler               pic x(30) value "Duck Records".
           03 filler               pic 9(4)  value 1991.
      ***
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Maria Maria".
           03 filler               pic x(5)  value "4:19".
           03 filler               pic x(30) value "Supernatural".
           03 filler               pic x(30) value "BMG Arista/Ariola".
           03 filler               pic 9(4)  value 1999.
      ***
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Oye como va".
           03 filler               pic x(5)  value "4:36".
           03 filler               pic x(30) value "Abraxas".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value 
                                               "Lightning in the sky".
           03 filler               pic x(5)  value "3:50".
           03 filler               pic x(30) value "Marathon".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Foo Foo".
           03 filler               pic x(5)  value "6:29".
           03 filler               pic x(30) value "Shaman".
           03 filler               pic x(30) value "Arista".
           03 filler               pic 9(4)  value 2002.
      ***
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(5)  value "4:03".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Yellow Submarine".
           03 filler               pic x(5)  value "2:40".
           03 filler               pic x(30) value "Revolver".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1966.
      ***
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(5)  value "2:21".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Yesterday".
           03 filler               pic x(5)  value "2:07".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Angie".
           03 filler               pic x(5)  value "4:30".
           03 filler               pic x(30) value "Goats Head Soup".
           03 filler               pic x(30) value "R.S.Records".
           03 filler               pic 9(4)  value 1973.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Start Me Up".
           03 filler               pic x(5)  value "3:32".
           03 filler               pic x(30) value "Tattoo You".
           03 filler               pic x(30) value 
                                               "Rolling Stones records".
           03 filler               pic 9(4)  value 1981.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Satisfaction".
           03 filler               pic x(5)  value "3:45".
           03 filler               pic x(30) value "Out of Our Heads".
           03 filler               pic x(30) value "Decca/ABKCO".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Rain Fall Down".
           03 filler               pic x(5)  value "4:55".
           03 filler               pic x(30) value "A Bigger Bang".
           03 filler               pic x(30) value "Polydor Records".
           03 filler               pic 9(4)  value 2005.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Albachiara".
           03 filler               pic x(5)  value "4:05".
           03 filler               pic x(30) value 
                                         "Non siamo mica gli americani".
           03 filler               pic x(30) value "Lotus LOP".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Tango".
           03 filler               pic x(5)  value "3:07".
           03 filler               pic x(30) value "Liberi Liberi".
           03 filler               pic x(30) value "Emi".
           03 filler               pic 9(4)  value 1988.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(5)  value "4:38".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1987.
      ***
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(5)  value "5:40".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1983.
      ***
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Money for Nothing".
           03 filler               pic x(5)  value "6:19".
           03 filler               pic x(30) value 
                                                  "After Midnight Live". 
           03 filler               pic x(30) value "Immortal".
           03 filler               pic 9(4)  value 2006.
      ***
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "After Midnight".
           03 filler               pic x(5)  value "2:51".
           03 filler               pic x(30) value "Eric Clapton".
           03 filler               pic x(30) value 
                                               "Atco, Polydor Records".
           03 filler               pic 9(4)  value 1970.

       01  tab-album-red           redefines tab-album.
           03 ta-item              occurs 20.
              05 ta-genre          pic x(15).
              05 ta-Artist         pic x(20).
              05 ta-title          pic x(30).
              05 ta-length         pic x(5).
              05 ta-album          pic x(30).
              05 ta-label          pic x(30).
              05 ta-year           pic 9(4).

       01  rec-grid.
           03 rec-multi            pic x(30).
           03 rec-length           pic x(5).
           03 rec-album            pic x(30).
           03 rec-year             pic z(4).

       77  old-ta-Artist           pic x(20).
       77  old-ta-genre            pic x(15).
       77  item-name               pic x(50).
       77  cont                    pic 99.
       77  tv-item                 unsigned-int.
       77  tv-item-parent          unsigned-int.
       77  tv-item-child           unsigned-int.

       SCREEN SECTION.
       01  Mask.
           03 Tb1-container
              tab-control
              line                          2 
              col                           2
              lines                         17 cells
              size                          68 cells
              allow-container
              tab-flat
              relative-offset
              active-tab-border-width      (0 0 2 0)
              tab-border-width             (0 0 1 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#dae1e5 
              active-tab-foreground-color   rgb x#354c5c
              .
           03 tb1-container-page1 
              tab-group Tb1-container tab-group-value 1.
              05 Tv1
                 tree-view
                 flat
                 buttons 
                 lines-at-root
                 line                       2 
                 col                        2 
                 lines                      13 
                 size                       65 
                 show-sel-always
                 selection-background-color rgb x#6883AE
                 selection-foreground-color rgb x#FFFFFF
                 item-rollover-background-color 
                                            rgb x#B7DFC9
                 item-rollover-foreground-color 
                                            rgb x#217346
                 .
           03 tb1-container-page2 
              tab-group Tb1-container       tab-group-value 2.
              05 tree-table
                 tree-view
                 table-view
                 flat
                 buttons
                 lines-at-root
                 line                       2
                 col                        2
                 lines                      13
                 size                       65 cells
                 display-columns           (1, 30, 37, 55)
                 virtual-width              62
                 data-columns              (record-position of rec-multi
                                           record-position of rec-length
                                            record-position of rec-album
                                            record-position of rec-year)
                 column-headings
                 tiled-headings
                 centered-headings
                 heading-color              257
                 adjustable-columns
                 reordering-columns
                 end-color                  -16774581
                 selection-background-color rgb x#6883AE
                 selection-foreground-color rgb x#FFFFFF
                 sortable-columns
                 sort-types                ("X", "X", "X", "X")
                 heading-menu-popup         3
                 alignment                 ("U", "C", "L", "R")
                 vpadding                   50
                 item-rollover-background-color 
                                            rgb x#B7DFC9
                 item-rollover-foreground-color 
                                            rgb x#217346
                 heading-rollover-background-color 
                                            rgb x#9FD5B7
                 heading-rollover-foreground-color 
                                            rgb x#000000
                 .
           03 tb1-container-page3 
              tab-group Tb1-container tab-group-value 3.
              05 Ls
                 list-box
                 line                       2
                 col                        2 
                 lines                      13 
                 size                       65 cells
                 unsorted
                 item-rollover-background-color 
                                            rgb x#B7DFC9
                 item-rollover-foreground-color 
                                            rgb x#217346
                 .
           03 tb1-container-page4 
              tab-group Tb1-container       tab-group-value 4.
              05 Ls-check
                 list-box
                 check-list
                 selection-mode        lssm-multiple-interval-selection
                 line                       2
                 col                        2 
                 lines                      13 
                 size                       65 cells
                 unsorted
                 item-rollover-background-color 
                                            rgb x#B7DFC9
                 item-rollover-foreground-color 
                                            rgb x#217346
                 .
           03 Pb-exit
              push-button
              line                          20 
              col                           62 
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Rollover color on Controls"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify Tb1-container tab-to-add ("Tree-view", 
                                            "Table view"
                                            "List-box"
                                            "check-list")

           perform LOAD-TREE
           perform LOAD-LIST

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue 
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
        
       LOAD-TREE.
           modify tv1 mass-update 1
           modify tree-table mass-update 1
      *populate heading
           modify tree-table(-1, 1) item-text ("Title")
           modify tree-table(-1, 2) item-text ("Length")
           modify tree-table(-1, 3) item-text ("Album")
           modify tree-table(-1, 4) item-text ("Year")

           move low-value to old-ta-genre
           move low-value to old-ta-Artist
           perform varying cont from 1 by 1 until cont > 20
              if ta-genre(cont) not = old-ta-genre
                 perform ADD-TREE-PARENT
              else
                 if ta-Artist(cont) not = old-ta-Artist
                    perform ADD-TREE-CHILD
                 else
                    perform ADD-TREE-CHILD-CHILD
                 end-if
              end-if
           end-perform
           modify tv1 mass-update 0
           modify tree-table mass-update 0
           .

       ADD-TREE-PARENT.
           move ta-genre(cont)  to old-ta-genre
           modify Tv1 parent null 
                      item-to-add ta-genre(cont) giving tv-item-parent
                      has-children 1 
                      item-foreground-color rgb x#6883AE

           initialize rec-grid.
           move ta-genre(cont) to rec-multi

           modify tree-table parent null 
                             item-to-add rec-grid 
                             giving tv-item-parent
                             has-children 1 
                             item-foreground-color rgb x#6883AE

           perform ADD-TREE-CHILD
           .

       ADD-TREE-CHILD.
           move ta-Artist(cont) to old-ta-Artist
           modify Tv1 parent tv-item-parent
                      item-to-add ta-Artist(cont) 
                      giving tv-item-child
                      has-children 1
                      item-foreground-color rgb x#6A98C6

           initialize rec-grid.
           move ta-Artist(cont) to rec-multi

           modify tree-table parent tv-item-parent
                             item-to-add rec-grid 
                             giving tv-item-child
                             has-children 1
                             item-foreground-color rgb x#6A98C6
           perform ADD-TREE-CHILD-CHILD
           .

       ADD-TREE-CHILD-CHILD.
           modify Tv1 parent tv-item-child  
                      item-to-add ta-title(cont) giving tv-item
                      has-children 0
                      item-foreground-color rgb x#354C5C 

           initialize rec-grid.
           move ta-title(cont)  to rec-multi
           move ta-length(cont) to rec-length
           move ta-album(cont)  to rec-album
           move ta-year(cont)   to rec-year

           modify tree-table parent tv-item-child  
                             item-to-add rec-grid 
                             giving tv-item
                             has-children 0
                             item-foreground-color rgb x#354C5C 
                             item-background-color rgb x#D1DFED

           if cont < 7
              modify Tv1 ensure-visible = tv-item
              modify tree-table ensure-visible = tv-item
           end-if.
           .

       LOAD-LIST.
           modify LS mass-update 1
           modify LS reset-list 1
           modify LS-check mass-update 1
           modify LS-check reset-list 1
           perform varying cont from 1 by 1 until cont > 20
              modify LS item-to-add ta-title(cont)
              modify LS-check item-to-add ta-title(cont)
           end-perform
           modify LS mass-update 0
           modify LS-check mass-update 0
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
