      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. wbrowser.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isresize.def".
       copy "iscobol.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  control-font               handle of font.
       77  close-win                  pic 9 value 0. 
       77  url                        pic x(256) 
                                               value "www.google.com".

       77  Wb1                        handle of web-browser.


       01  DJWebBrowser               pic 9.
           88 DJWebBrowser-available  value 1 false 0.

       01  JFXWebBrowser              pic 9.
           88 JFXWebBrowser-available value 1 false 0.

       01  JXWebBrowser               pic 9 value 0.
           88 JXWebBrowser-available  value 1 false 0.

       01  browser-type               pic 9 value 1.
           88 DJWebBrowser-type       value 1.
           88 JFXWebBrowser-type      value 2.
           88 JXWebBrowser-type       value 3.

       77  jx-license                 pic x any length.
       
       77  wrk-set-env-browser        pic x any length.
       77  e-JXWebBrowser             pic 9 value 0.

       77  env-code                   pic 9.

       78  78-back                    value 1.
       78  78-Forward                 value 2.
       78  78-Refresh                 value 5.
       78  78-home                    value 6.
       78  78-Print                   value 8.
       78  78-navigate                value 13.

       SCREEN SECTION.
       01  Mask.   
           03 label
              line              2 
              col               2 
              size              10 cells
              title             "Browse to:"
              .
           03 cb-url 
              combo-box
              drop-list
              line              2
              col               12
              size              46 cells
              value             url
              .  
           03 push-button 
              default-button
              line              2 
              col               60
              size              10 cells
              title             "&Navigate"
              exception-value   78-navigate
              .   
           03 push-button 
              default-button
              line              4 
              col               12
              size              10 cells
              title             "&Back"
              exception-value   78-back
              self-act
              .
           03 push-button 
              default-button
              line              4 
              col               23
              size              10 cells
              title             "&Forward"
              exception-value   78-forward
              self-act
              .
           03 push-button 
              default-button
              line              4 
              col               34
              size              10 cells
              title             "&Refresh"
              exception-value   78-refresh
              self-act
              .
           03 push-button 
              default-button
              line              4 
              col               45
              size              10 cells
              title             "&Home"
              exception-value   78-home
              self-act
              .
           03 push-button 
              default-button
              line              4 
              col               60
              size              10 cells
              title             "&Print"
              exception-value   78-print
              self-act
              .
           03 radio-button
              title             "DJWebBrowser"
              line              18
              col               2
              group             1
              group-value       1
              value             browser-type
              enabled           DJWebBrowser
              exception-value   101
              .
           03 radio-button
              title             "JFXWebBrowser"
              line              18
              col               29
              group             1
              group-value       2
              enabled           JFXWebBrowser
              value             browser-type
              exception-value   102
              .
           03 rb-jx
              radio-button
              title             "JXWebBrowser"
              line              18
              col               54
              group             1
              group-value       3
              enabled           e-JXWebBrowser
              value             browser-type
              exception-value   103
              .
           03 label
              transparent
              line              20
              col               2 
              size              10 cells
              title             "JX license"
              .
           03 ef-license 
              entry-field
              line              20
              col               11
              size              50 cells
              value             jx-license
              enabled           JXWebBrowser
              notify-change
              max-text          100
              event             EVT-LICENSE
              .
           03 Pb-exit  
              push-button
              line              20 
              col               62 
              size              8 cells
              title             "Exit" 
              exception-value   27
              .

       PROCEDURE DIVISION.
       MAIN. 

           call client "C$FORNAME" 
                                using "javafx.embed.swing.JFXPanel"
           if return-code = 0
              call client "C$FORNAME" 
                          using "com.iscobol.browser.fx.JFXWebBrowser"
              if return-code = 0
                 set JFXWebBrowser-available  to true
              else
                 set JFXWebBrowser-available  to false
              end-if
           else
              set JFXWebBrowser-available  to false
           end-if

           call client "C$FORNAME" 
                           using "com.teamdev.jxbrowser.browser.Browser"
           if return-code = 0
              set JXWebBrowser-available  to true
           else
              set JXWebBrowser-available  to false
           end-if

           call "C$GETRUNENV" GIVING env-code
           if env-code = runenv-web-client 
              if JFXWebBrowser-available
                 set environment "gui.webbrowser.class"   
                             to "com.iscobol.browser.fx.JFXWebBrowser"
                 set JFXWebBrowser-type  to true
                 set DJWebBrowser-available to false
              else
                 display message "The Web-Browser control is not "
                                 "available in this environment"
                 goback
              end-if
           else
              set DJWebBrowser-available to true
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "WEB-BROWSER Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify cb-url item-to-add ("www.veryant.com",
                                      "www.google.com")

           perform DISPLAY-BROWSER
           perform NAVIGATE
              
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception 
                    perform EXCEPTION-HANDLING
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       DISPLAY-BROWSER.
           display web-browser
                   no-msg-before-navigate
                   line 6
                   col 2 
                   lines 11 cells 
                   size 68 cells
                   handle Wb1
                   upon mask
           .

       DESTROY-BROWSER.
           destroy Wb1.

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                move "com.iscobol.browser.dj.DJWebBrowser"
                                                  to wrk-set-env-browser
                perform CHANGE-BROWSER
           when 102
                if JFXWebBrowser-available
                   move "com.iscobol.browser.fx.JFXWebBrowser"
                                                  to wrk-set-env-browser
                   perform CHANGE-BROWSER
                end-if
           when 103
                if JXWebBrowser-available
                   initialize wrk-set-env-browser
                   string "com.iscobol.browser.jx.JXWebBrowser?" 
                                         delimited by size
                          "licenseKey="  delimited by size
                          jx-license     delimited by size
                          into wrk-set-env-browser
                   perform CHANGE-BROWSER
                end-if
           when 78-navigate
                perform NAVIGATE
           when 78-back
                modify wb1 go-back 1
           when 78-Forward
                modify wb1 go-forward 1
           when 78-Refresh
                modify wb1 refresh 1
           when 78-home
                modify wb1 go-home 1
           when 78-Print
                modify wb1 print 1
           end-evaluate
           .

       CHANGE-BROWSER.
           perform DESTROY-BROWSER
           
           set environment "gui.webbrowser.class"
                                               to wrk-set-env-browser
           perform DISPLAY-BROWSER
           perform NAVIGATE.

       NAVIGATE.
           modify Wb1 value url.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EVT-LICENSE.
           if event-type = ntf-changed
              inquire ef-license value jx-license 
              if jx-license = space
                 move 0   to e-JXWebBrowser
              else
                 move 1   to e-JXWebBrowser
              end-if
              modify rb-jx enabled e-JXWebBrowser 
           end-if