      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. handletype.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  desc                    pic x(50).
       77  handle-name               pic x(20).
       77  generic-handle             handle.

       SCREEN SECTION.
       01  Mask.
           03 push-button
              line                 2 
              col                  2 
              size                 12 cells
              title                "Windows" 
              exception-value      101
              .
           03 push-button
              line                 4 
              col                  2 
              size                 12 cells
              title                "Font" 
              exception-value      102
              .
           03 push-button
              line                 6
              col                  2 
              size                 12 cells
              title                "Invalid" 
              exception-value      103
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "HANDLE-TYPE Function"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status
                    when 101
                         move "hWin"  to handle-name
                         move hWin    to generic-handle
                         perform TEST-HANDLE
                    when 102
                         move "LARGE-FONT"  to handle-name
                         move large-font to generic-handle
                         perform TEST-HANDLE
                    when 103
                         move "Invalid"  to handle-name
                         move zero       to generic-handle
                         perform TEST-HANDLE
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

           goback
           .

       TEST-HANDLE.
           evaluate function handle-type(generic-handle)
                    when handle-is-invalid
                         move "is an invalid handle"   to desc
                    when handle-of-window      
                         move "is a window handle"     to desc
                    when handle-of-subwindow   
                         move "is a subwindow handle"  to desc
                    when handle-of-font        
                         move "is a font handle"       to desc
                    when handle-of-thread      
                         move "is an handle of thread" to desc
                    when handle-of-menu        
                         move "is a menu handle"       to desc
                    when handle-of-control     
                         move "is a control handle"    to desc
                    when handle-of-bitmap      
                         move "is a bitmap handle"     to desc
                    when handle-is-unknown
                         move "is an unknown handle"   to desc
           end-evaluate
           
           display message handle-name x"0D0A" desc 
                   icon    mb-default-icon
                   title   "handle type".

           
       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE  to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .
