      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. bytelen.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  n-string                pic n(10).

       77  pic-x-any-length        pic x any length.
       77  pic-n-any-length        pic n any length.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title           "Input a string in this pic X any length:" 
              .
           03 Ef-Val1
              entry-field
              line                 4
              col                  2
              size                 48 
              value                pic-x-any-length
              .
           03 push-button
              line                 4
              col                  + 2
              size                 16
              title                "Show length"
              exception-value      11
              self-act
              .

           03 label
              line                 8
              col                  2
              title           "Input a string in this pic N any length:" 
              .

           03 Ef-Val2
              entry-field
              line                 10
              col                  2
              size                 48 
              value                pic-n-any-length
              .
           03 push-button
              line                 10
              col                  + 2
              size                 16
              title                "Show length"
              exception-value      12
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.         
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "BYTE-LENGTH and LENGTH Functions"
                   lines 21 
                   min-lines 21 
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception 
                    evaluate crt-status
                    when 11 
                         perform LENGTH-FUNCTION-X
                    when 12 
                         perform LENGTH-FUNCTION-N
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font

           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       LENGTH-FUNCTION-X.
           display message box  "Length: " 
                                function length(pic-x-any-length)
                                x"0D0A"
                                "Byte-length: "
                                function byte-length(pic-x-any-length)
                   title "Length value"
           .

       LENGTH-FUNCTION-N.
           display message box  "Length: " 
                                function length(pic-n-any-length)
                                x"0D0A"
                                "Byte-length: "
                                function byte-length(pic-n-any-length)
                   title "Length value"
           .