      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. bin2dec.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font. 
       77  close-win               pic 9 value 0.
       77  bin-val                 pic x(32) value "1000010".
       77  dec-val                 pic 9(5). 

       77  c               pic 9.
       77  w-digit        pic x.
           88 is-bin-digit values "0", "1".

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 20 cells
              title                "Input a binary value:" 
              .
           03 ef-bin-val
              entry-field
              numeric
              line                 4
              col                  2
              size                 18 
              value                bin-val
              notify-change
              event                EV-EF-BIN-VAL
              .
           03 push-button
              line                 6
              col                  2
              size                 18
              title                "Show &decimal value"
              exception-value      11
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20
              col                  62
              size                 8 cells
              title                "Exit" 
              exception-value      27
               .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "BIN2DEC Function"
                   lines 21 
                   min-lines 21 
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform  until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    if crt-status = 11
                       perform CALCULATION
                    end-if
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CALCULATION.
           move function bin2dec (bin-val) to dec-val
           display message box dec-val
                   title "Decimal value"
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       EV-EF-BIN-VAL.
           if event-type = ntf-changed
              inquire ef-bin-val value bin-val
              initialize c
              inspect bin-val tallying c 
                           for characters before initial trailing space
              move bin-val(c:1) to w-digit
              if not is-bin-digit
                 move spaces to bin-val(c:1)
                 modify ef-bin-val value bin-val
                                   cursor c
              end-if
              set event-action to event-action-continue
           end-if
           .
