*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

 PROGRAM-ID. helpprg is initial.

 WORKING-STORAGE SECTION. 
 copy "isgui.def".
 copy "iscobol.def".
 copy "notifprog-link.wrk". 
 77  help-message      pic x any length.
 77  help-part-1       pic x any length.
 77  help-part-2       pic x any length.
 77  help-part-3       pic x any length.
 77  help-part-4       pic x any length.

 77 h-notificon        pic s9(9) comp-4 is external.

 77  h-notif           handle of window.
 77                    pic 9.
     88 show-help      value 1 false 0.

 LINKAGE SECTION.
 01  event-data.
     03  event-type            pic x(4) comp-x.
     03  event-window-handle   handle of window.
     03  event-control-handle  handle.
     03  event-control-id      pic xx comp-x.
     03  event-data-1          signed-short.
     03  event-data-2          signed-long.
     03  event-action          pic x comp-x.

 SCREEN SECTION.
 PROCEDURE DIVISION using event-data.
 MAIN.
     set show-help  to true
     evaluate event-data-2
     when 1
          move "NUMERIC Style"                                      to help-part-1
          move "With this style the entry-field accept "            to help-part-2
          move "only digits and sign symbols"                       to help-part-3
     when 2
          move "NO-BOX style"                                       to help-part-1
          move "With this style the entry-field does not"           to help-part-2
          move "have borders"                                       to help-part-3
     when 3
          move "BOXED style"                                        to help-part-1
          move "With this style the entry-field has"                to help-part-2
          move "a boxed border"                                     to help-part-3
     when 4
          move "3-D style"                                          to help-part-1
          move "With this style the entry-field has"                to help-part-2
          move "a 3-D border"                                       to help-part-3
     when 5
          move "BORDER-COLOR style"                                 to help-part-1
          move "With this style you can set a custom "              to help-part-2
          move "color for the borders"                              to help-part-3
     when 6
          move "BORDER-WIDTH style"                                 to help-part-1
          move "With this style a custom size can be "              to help-part-2
          move "set for the width of each border"                   to help-part-3
     when 7
          move "MAX-TEXT style"                                     to help-part-1
          move "With this style you can set the maximum"            to help-part-2
          move "number of characters you can type"                  to help-part-3
     when 8
          move "AUTO style"                                         to help-part-1
          move "With this style the focus moves "                   to help-part-2
          move "automatically to the next field when the maximun"   to help-part-3
          move "number of characters allowed is reached"            to help-part-4
     when 9
          move "LOWER style"                                        to help-part-1
          move "With this style all characters are "                to help-part-2
          move "converted into lower-case"                          to help-part-3
     when 10
          move "UPPER style"                                        to help-part-1
          move "With this style all characters are "                to help-part-2
          move "converted into upper-case"                          to help-part-3
     when 11
          move "NO-AUTOSEL style"                                   to help-part-1
          move "With this style the content is not "                to help-part-2
          move "automatically selected when the control "           to help-part-3
          move "focuses using the keyboard"                         to help-part-4
     when 12
          move "READ-ONLY style"                                    to help-part-1
          move "With this style the content of the field "          to help-part-2
          move "is read only"                                       to help-part-3
     when 13
          move "SECURE style"                                       to help-part-1
          move "With this style asterisks are displayed "           to help-part-2
          move "instead of the clear text"                          to help-part-3
     when 14
          move "SPINNER style"                                      to help-part-1
          move "With this style arrow buttons are added "           to help-part-2
          move "on the right for easy number picking"               to help-part-3
          move "It works only on numeric fields"                    to help-part-4
     when 15
          move "AUTO-DECIMAL style"                                 to help-part-1
          move "With this style when the field loses "              to help-part-2
          move "focus the decimal digits are automatically "        to help-part-3
          move "added. It works only on numeric fields"             to help-part-4
     when 16
          move "BITMAP style"                                       to help-part-1
          move "With this style you can add images "                to help-part-2
          move "inside the entry-field"                             to help-part-3
     when 17
          move "MULTILINE style"                                    to help-part-1
          move "With this style the contents of the entry-field"    to help-part-2
          move "can span more than one row"                         to help-part-3
     when 18
          move "Alignment LEFT"                                     to help-part-1
          move "The content is aligned to the left"                 to help-part-2
     when 19
          move "Alignment CENTER"                                   to help-part-1
          move "The content is aligned to the center"               to help-part-2
     when 20
          move "Alignment RIGHT"                                    to help-part-1
          move "The content is aligned to the right"                to help-part-2
     when 21
          move "PROPOSAL style"                                     to help-part-1
          move "With this style the content can be picked "         to help-part-2
          move "from a filterable list of items"                    to help-part-3
     when 22
          move "PLACEHOLDER style"                                  to help-part-1
          move "With this style when the field is empty a hint"     to help-part-2
          move "string is displayed inside the control"             to help-part-3
     when 23
          move "SPELL-CHECKING style"                               to help-part-1
          move "With this style the spell-checking "                to help-part-2
          move "feature is activated"                               to help-part-3
     when other
          set show-help   to false
     end-evaluate

     if show-help
        perform SHOW-HELP-ROUTINE
     end-if
     goback.

 SHOW-HELP-ROUTINE.
     perform FORMAT-HTML.
     perform DISPLAY-HINT.
     perform DISPLAY-NOTIFICATION.

 DISPLAY-HINT.
     perform CALCULATE-HELP-POSITION
     call "w$hint" using help-message
                         mouse-col-ex 
                         mouse-row-ex
                         6000
     .

 DISPLAY-NOTIFICATION.
   if os-is-mac
      set notif-top-right to true
   else
      set notif-bottom-right to  true
   end-if
   move 300            to notif-before-time
   move 0              to notif-delay
   move h-notificon to notif-bmp-handle

   initialize notif-text

   string "<HTML><b>"     delimited by size
            help-part-1   delimited by size
            "</b></HTML>" delimited by size
            x"0A"         delimited by size
            "<HTML><i>"   delimited by size
            help-part-2   delimited by size
            "</i></HTML>" delimited by size
            into notif-text
   if help-part-3 not = space
      string notif-text   delimited by size
            x"0A"         delimited by size
            "<HTML><i>"   delimited by size
            help-part-3   delimited by size
            "</i></HTML>" delimited by size
            into notif-text
   end-if
   if help-part-4 not = space
      string notif-text   delimited by size
            x"0A"         delimited by size
            "<HTML><i>"   delimited by size
            help-part-4   delimited by size
            "</i></HTML>" delimited by size
            into notif-text
   end-if

   call "NOTIFPROG" using notifprog-lnk
                          notif-text.


 CALCULATE-HELP-POSITION.
     call "W$MOUSE" using get-mouse-status 
                          mouse-info
     add 1  to mouse-col-ex
               mouse-row-ex.

 FORMAT-HTML.
     initialize help-message
     string "<HTML><b>"   delimited by size
            help-part-1   delimited by size
            "</b><br><i>" delimited by size
            help-part-2   delimited by size
            "</i><br><i>" delimited by size
            help-part-3   delimited by size
            "</i><br><i>" delimited by size
            help-part-4   delimited by size
            "</i></HTML>" delimited by size
            into help-message 
     .
     
