
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows a simple application with a dynamic menu**

**This sample also shows the audit feature, which builds on top of the I/O Trigger file**
**technology, and allows COBOL developers to add logging on all I/O operations without**
**source code modifications.**
**Refer to README.md located into the folder $ISCOBOL/sample/audit for a full**
**description of the audit feature.** 

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
### To test this program from the Command Prompt follow these instructions:

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/isapplication" folder.

 - 2 Compile the programs

        iscc -sp=copylib:copylib/audit -od=prg source/*.cbl 

 **NOTE:**

        The -sp option passes the copybook directories needed to compile the programs
        The -od option specifies the output directory for the generated java classes

 - 3 Compile the audit programs. if you don't want use this feature, you can skip this step

   - 3a Edit the compiler.properties file in order to choose the correct correct file system.
        The default value is Jisam.

   - 3b 

            iscc -c=compiler.properties -sp=copylib:copylib/audit -od=prg-audit source/audit/AuditTrigger.cbl 

   - 3c

            iscc -sp=copylib:copylib/audit -od=prg source/audit/AUDIT.cbl 
            iscc -sp=copylib:copylib/audit -od=prg source/audit/AUDITANALYSIS.cbl 
            iscc -sp=copylib:copylib/audit -od=prg source/audit/AUDITLOG.cbl 
            iscc -sp=copylib:copylib/audit -od=prg source/audit/AUDITSETTINGS.cbl 

   - 3d Edit the iscobol.properties file in order to choose the correct correct file system
        for the auditlogfile.
        The default value is Jisam.


 **NOTE:**

        If you don't want use the audit feature remember to comment the following properties into the configuration file

        iscobol.use_audit=1
        iscobol.file.index=AuditTrigger

 - 4 If you want to use the audit feature add the prg-audit folder to the CLASSPATH


        export CLASSPATH=$CLASSPATH:prg-audit


 - 5 Start the ISAPPLICATION program

        iscrun -c iscobol.properties ISAPPLICATION 

 **NOTE:**

    To run this sample in debug add the option "-d" or "-dx" during compilation
    and add the "-d" option during the execution

----------
### To use ISAPPLICATION with application server

 **On the server**

 - 1 Repeat steps 1-4 in the Stand Alone Section above

 - 2 Start the Application Server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

        If you have already started an instance of the Application Server,
        you can start a new instance of it on a different port**

 **On the client using the command line**

 - 1 Start the ISAPPLICATION program

        iscclient -hostname <host-name> -c iscobol.properties ISAPPLICATION 

 **On the client using the isapplication.istc file**

 - 1 Edit the isapplication.istc in order to set the correct hostname

 - 2 Start the ISAPPLICATION program

        Exceute the isapplication.istc to execute the client

 **NOTE:**

        The istc file is available only for Windows client

----------
### To use ISAPPLICATION with WebClient environment follow the following steps:
  (This option is available only if you have the isCOBOL WebClient installed)

 **On the isCOBOL application server machine**

 - 1 Repeat steps 1-4 in the Stand Alone Section above


 - 2 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number> 

 **NOTE:**

    If you have already started an instance of the Application Server,
    you can start a new instance on a different port

 **On the WebClient server machine**

 - 1 Using a Webclient's command prompt window go to the "$ISCOBOL/webclient" folder.

 - 2 If the WebClient server is not already running, start it with the following command

        webcclient 

 - 3 Open another Webclient's command prompt

 - 4 If the WebClient Adminstrator service is not already running, start it with the following command

        webcclient-admin

 **NOTE:**

     Instead of starting each process separately (see the previous section), you can start the WebClient server and WebClient Admin Console as a single process. This is helpful in a development environment.

     To do this, first edit the webclient.config file and replace:
     "adminConsoleUrl" : "http://localhost:8090"
     with:
     "adminConsoleUrl" : "http://localhost:8080/admin"

     And then run this command from the command prompt:
     webcclient-and-admin

     Both the webcclient and webcclient-admin will be started together.  

     The admin link is http://127.0.0.1:8080/admin

 **On the WebClient machine**

 - 1 From your browser open the following url to access the WebClient Administrator panel, changing the address and port to reflect your deployment configuration:

        http://localhost:8090/

 - 2 use the default login credentials

        User: admin 
        Password: admin 

 - 3 Click on **"Applications"**

 - 4 Click on **"+"** and select **"Create new"**

 - 5 Type **"isapplication"** into the field and confirm the creation of the app

 - 6 Click on the **isapplication** application on the left side of the window.

 - 7 Fill the configuration fields as follows

     - In the **"App Config"** area	
       - In the **"Veryant"** section
         - isCOBOL Server address: Type the hostname of your application server
         - isCOBOL Server port: Type the port used by your application server
         - Program name and arguments: ISAPPLICATION

 - 8 Click on  **"Apply"** in the bottom right side of the screen.

 - 9 Click on  **"Enable"** in the upper right side of the screen.

 - 10 Use the following link in a different browser window to test the sample

        http://localhost:8080/isapplication/ 
        changing the address and port to reflect your deployment configuration.

### To debug the programs in this environment follow these instructions:

 - Repeat step 1 in the Stand Alone section above

 - Compile the programs

        iscc -sp=copylib -d *.cbl

 **NOTE:**

        The -sp option passes the copybook directories needed to compile 
        the programs

 - Modify the iscobol.properties adding the following property

        iscobol.rundebug=1 

 - Start the application server:

        iscserver -hostname <hostname | IP address> -port <port-number> 

 - Using an additional command prompt window, navigate to the "$ISCOBOL/sample/iscontrolset" folder
   and run the remote debugger

        iscrun -d -r <hostname | IP address> <port-number> 

 **NOTE:**

     The remote debugger is started with this command. The debugger is still not 
     activated until the remote program starts

 - Start a new instance of the sample from the browser, navigating to the following URL: 

        http://localhost:8080/isapplication/ 
        changing the address and port to reflect your deployment configuration.

----------
### To use ISAPPLICATION with c-treeRTG with automatic sqlize

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/isapplication"
     folder.

 - 2 Create a sub-folder named "iss"

 - 3 Compile the programs

        iscc -sp=copylib:copylib/audit -efc -efo=iss -od=prg source/*.cbl 
        iscc -sp=copylib:copylib/audit -efc -efo=iss -od=prg source/audit/AUDITLOG.cbl 

 **NOTE:**

        The -c option is used to pass the name of the configuration file to the compiler
        The -od option specifies the output directory for the generated java classes
        The -sp option is used to tell the compiler where to find copybooks used by some of the programs

 - 4 Add the following entries in the configuration file (iscobol.properties):

        iscobol.file.index=ctreej
        iscobol.file.index.server=FAIRCOMS
        to set the file system to c-tree

        iscobol.file.prefix=.
        to use the default c-tree data folder as path of the indexed files

        iscobol.file.index.user=admin
        iscobol.file.index.password=ADMIN
        iscobol.sqlserver.iss=1
        iscobol.sqlserver.isspath=iss
        iscobol.sqlserver.database=ctreeSQL
        iscobol.sqlserver.convention=A 
        to use the default  c-tree database

 **NOTE:**

    If you already have a c-treeRTG server use your connection settings
    instead of the default settings**

 - 5 Start c-treeRTG server

 - 6 Start the ISAPPLICATION program
 
        iscrun -c iscobol.properties ISAPPLICATION 

----------
###  To use ISAPPLICATION with DATABASE BRIDGE (example for Oracle)

 - 1 Repeat steps 1-4 in the Stand Alone Section above

 - 2 Edit the genedii-compiler.properties in order to uncomment the section of yours RDBMS

 - 3 Create and compile the EDBI BRIDGE programs
   
        iscc -c=genedii-compiler.properties -sp=copylib:copylib/audit -od=prg source/GEN-EDBII.cbl 

**NOTE:**

        The -c option is used to pass the name of the configuration file to the compiler
        The -od option specifies the output directory for the generated java classes
        The -sp option is used to tell the compiler where to find copybooks used by some of the programs

 - 4 Add the jar (or zip) library that contains the JDBC driver for the RDBMS 
     to the classpath, or copy the file into the "$ISCOBOL/jars" folder
     (example for Oracle 11 the jar file is C:/oraclexe/app/oracle/product/11.2.0/server/jdbc/lib/ojdbc6.jar)

 - 5 Add the following entries in the configuration file (iscobol.properties):

        iscobol.file.index=easydb 
        to set the file system to DATABASE BRIDGE 

        iscobol.easydb.prefix=ora
        iscobol.jdbc.driver=oracle.jdbc.OracleDriver
        iscobol.jdbc.url=jdbc:oracle:thin:@<<machine_name>>:<<port>>:
        iscobol.jbdc.autocommit=1

 - 6 Start the ISAPPLICATION program
 
        iscrun -c iscobol.properties ISAPPLICATION 

----------
###  To run ISAPPLICATION using DBMaker's COBOL Interface (DCI)

 **NOTE:**

        Before execute this sample you need to put the DCI library (dci.dll on Windows or
        libdci.so on Linux) into the bin folder of dbmaker installation.
        Refere to isCOBOL documentation for more information on the DCI library routine and
        where download it.

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/isapplication" folder.

 - 2 Create a sub-folder named "xml"

 - 3 Compile the programs

        iscc -sp=copylib:copylib/audit -efd -efo=xml -od=prg source/*.cbl 
        iscc -sp=copylib:copylib/audit -efd -efo=xml -od=prg source/audit/AUDITLOG.cbl 

 **NOTE:**

        The -sp option is used to tell the compiler where to find the is*.def
                 copybooks used by some of the programs

 - 4 Add the following entry in the configuration file (iscobol.properties):

        iscobol.file.index=dci
        to set the file system to DBMaker

 - 5 Modify the PATH:
     to contain the bin folder of your DBMaker  
     (example 'set PATH=%PATH%:C:/DBMaker/5.4/bin')

 - 6 Create the new file dci_config.txt and add the following entries:

        DCI_DATABASE=DBSAMPLE5
        DCI_LOGIN=SYSADM
        DCI_XMLPATH=XML
        to use the default DBMaker database

 **NOTE:**

        If you already have a DBMaker database use your connection settings
        instead of the default settings

 - 7 Set the system variable DCI_CONFIG

     to contain your DBMaker config file
     (example 'set DCI_CONFIG=dci_config.txt')

 - 8 Start the DBMaker database (example DBSAMPLE5)

 - 9 Start the ISAPPLICATION program
 
        iscrun -c iscobol.properties ISAPPLICATION 

