      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.     RTF-EDITOR.

       configuration section.
       repository.
           class ijb        as "com.iscobol.gui.server.CobolGUIJavaBean"
           class RTFEditorKit  as "javax.swing.text.rtf.RTFEditorKit"
           class FInputStram   as "java.io.FileInputStream"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isopensave.def".

       copy "object.def".
       copy "component.def".
       copy "container.def".
       copy "jcomponent.def".
       copy "jtextcomponent.def".
       copy "jeditorpane.def".

       77  crt-status              special-names crt status pic 9(5).  
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0. 

       77  rtf-doc                 pic x any length.

       77  rtb-read-obj     object reference ijb.
       77  RTFEK-read       object reference RTFEditorKit.
      
      
       SCREEN SECTION.
       01  Mask.
           03 rtb-read     
              java-bean
              clsid  "javax.swing.JEditorPane"
              vscroll
              enabled 1
              use-return
              use-tab
              boxed
              color  513
              line   2
              col    2 
              size   77 cells
              lines  19 cells
              object rtb-read-obj
              .
           03 Ef1  
              entry-field 
              read-only
              line                 22 
              col                  2 
              size                 70 cells
              value                "choose a RTF document"
              .
           03 Pb1  
              push-button
              line                 22 
              col                  73 
              size                 6 cells
              title                "..." 
              exception-value      101
              .
           03 Pb2  
              push-button
              line                 24 
              col                  2 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              display message 
                 "This sample doesn't works in Application server,"
                 x"0A"
                  "because the used javabean doesn't support the" 
                 x"0A"
                  "serialization of the java object"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if.
           initialize rtf-doc.

           set environment "key.up"      to "edit=".
           set environment "key.down"    to "edit=".
      
           display standard graphical window
                   color  65793
                   with   system menu
                   title  "JAVABEAN Control"
                   handle hWin
                   event  WIN-EVT
           display Mask
      
           perform INIT
      
           accept  Mask until crt-status = 27 or close-win = 1
                   on exception
                      if crt-status = 101
                         perform CHOOSE-RTF
                      end-if
           end-accept     

           destroy Mask
           destroy hWin
           goback
           .


       CHOOSE-RTF.
           initialize opensave-data

           string "RTF Files (*.rtf)|*.rtf|"
                  delimited by size
                  into opnsav-filters.

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data.

           if opnsav-basename not = spaces
              modify Ef1 value opnsav-filename  
              move opnsav-filename   to rtf-doc
              perform READ-RTF
           end-if
           .


       INIT.
           set RTFEK-read to RTFEditorKit:>new
           rtb-read-obj:>setProperty("EditorKit" RTFEK-read)
           .
      *
       READ-RTF.
           try
             rtb-read-obj:>callMethod("read" 
                                      FInputStram:>new(rtf-doc)
                                      null)
           catch exception
              display message exception-object
           end-try.
      *
       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .
           
