      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       Program-Id. SendMail.
 
       Configuration Section.
       Repository.
           class j-string         as "java.lang.String"
           class ja-string        as "java.lang.String[]"
           class j-integer        as "java.lang.Integer"
           class j-properties     as "java.util.Properties"
           class j-transport      as "javax.mail.Transport"
           class j-message        as "javax.mail.Message"
           class j-session        as "javax.mail.Session"
           class j-internet-address 
                             as "javax.mail.internet.InternetAddress"
           class j-mime-message   as "javax.mail.internet.MimeMessage"
           class j-recipient-type as "javax.mail.Message.RecipientType"
           class j-attach         as "javax.mail.internet.MimeBodyPart"
           class j-multi          as "javax.mail.internet.MimeMultipart"
           class Authenticator    as "MYAUTHENTICATOR"
           .
       Working-Storage Section.
       77  props                  object reference j-properties.
       77  session                object reference j-session.
       77  msg                    object reference j-mime-message.
       77  mbp                    object reference j-attach.
       77  multi                  object reference j-multi.
       77  attachments            object reference ja-string.
       77  transport              object reference j-transport.
       77  w-Authenticator        object reference Authenticator.

       77  smtp-host              pic x any length.
       77  smtp-port              pic x any length.
       77  smtp-user              pic x any length.
       77  smtp-pwd               pic x any length.
       77  smtp-security          pic x.
 
       77  mail-from              pic x any length.
       77  mail-to                pic x any length.
       77  mail-cc                pic x any length.
       77  mail-bcc               pic x any length.
       77  mail-replyto           pic x any length.
       77  mail-subject           pic x any length.
       77  mail-text              pic x any length.
       77  mail-attach            pic x any length.

       01                         pic 9.
           88 connection-ok       value 1 false 0.
       01                         pic 9.
           88 send-ok             value 1 false 0.

      *> Security type
       78  security-none          value space.
       78  security-ssl           value "S".
       78  security-starttls      value "T".


       77  attachments-count      pic 9(3).
       77  idx                    pic 9(3).
       77  mime-type              pic x any length.

       Procedure Division.
       MAIN.
           perform SET-SMTP-CONNECTION-PARAMETER
           perform CREATE-SMTP-SESSION

           if connection-ok
              perform SET-MAIL-CONTENT
              perform SEND-MAIL
           end-if
           goback.

       SET-SMTP-CONNECTION-PARAMETER.

      *    Put the connection parameter for your SMTP server here
           move "smtp.server.it"   to smtp-host.
           move "110"              to smtp-port.
           move "user"             to smtp-user.
           move "password"         to smtp-pwd.

      *    Uncomment the correct security level for your server
           move security-none      to smtp-security.
      *     move security-ssl       to smtp-security.
      *     move security-starttls  to smtp-security.

       CREATE-SMTP-SESSION.
           display "Connecting to the SMTP server " smtp-host

           set connection-ok to true
           try
              set props to j-properties:>new()
              evaluate smtp-security 
              when security-none
                   continue
              when security-ssl
                   props:>put("mail.smtp.ssl.enable" as string, 
                              "true" as string)
              when security-starttls
                   props:>put("mail.smtp.starttls.enable" as string, 
                          "true" as string)
              end-evaluate

              props:>put ("mail.smtp.host" as string, 
                          smtp-host as string)

              props:>put ("mail.smtp.port" as string, 
                          smtp-port as string)   

              props:>put ("mail.smtp.localhost" as string, 
                          "localhost" as string)

              if smtp-pwd = spaces
                 props:>put ("mail.smtp.auth" as string, 
                             "false" as string)
                 set session to j-session:>getDefaultInstance(props, 
                                                              null)
              else
                 set w-Authenticator to Authenticator:>new(smtp-user, 
                                smtp-pwd)
                 props:>put ("mail.smtp.submitter" as string, 
                 w-Authenticator:>getPasswordAuthentication:>getUserName 
                                as string)
                 props:>put ("mail.smtp.auth" as string, 
                             "true" as string)
                 set session to j-session:>getDefaultInstance(props, 
                                           w-Authenticator)
              end-if
           catch exception
              display "Connection failed"
              display exception-object
              set connection-ok to false
           end-try.
           
           if connection-ok
              display "Connection OK"
           end-if.

       SET-MAIL-CONTENT.
      *    Mutiple recipients can be passed separating them with comma 
      *    in the parameters 'TO', 'CC', 'BCC' and 'ReplyTo' 
           move "my-address@mymail.com"  to mail-from.
           move "to-address@mymail.com"  to mail-to.
           move "cc-address@mymail.com"  to mail-cc.
           move "bcc-address@mymail.com" to mail-bcc.
           move "replayto-address@mymail.com" to mail-replyto.

           move "Subject of the mail"    to mail-subject.

      *    If the text of the message starts with the "<html>" tag, the  
      *    mail is sent as text/html, otherwise it is sent as text/plain
           move "text of the mail"       to mail-text.

      *    Multiple attachments can be specified by separating them with 
      *    commas
      *     move "attach.txt"             to mail-attach.

       SEND-MAIL.
           set send-ok to true
           display "Sending mail"
           try
              if function lower-case (mail-text(1:6)) = "<html>"
                 move "text/html" to mime-type
              else
                 move "text/plain" to mime-type
              end-if
              set msg to j-mime-message:>new(session)
              if mail-from not = spaces
                 msg:>setFrom(j-internet-address:>new(mail-from 
                                                      as string))
              end-if
              if mail-to not = spaces
                 msg:>addRecipients(j-recipient-type:>TO, 
                 j-internet-address:>parse(mail-to as string))
              end-if
              if mail-cc not = spaces
                 msg:>addRecipients(j-recipient-type:>CC, 
                          j-internet-address:>parse(mail-cc as string))
              end-if
              if mail-bcc not = spaces
                 msg:>addRecipients(j-recipient-type:>BCC, 
                          j-internet-address:>parse(mail-bcc as string))
              end-if
              if mail-replyto not = spaces
                 msg:>setReplyTo(j-internet-address:>parse(mail-replyto 
                                            as string))
              end-if
              if mail-subject not = spaces
                 msg:>setSubject(mail-subject as string)
              end-if  
              if mail-attach not = spaces
                 set multi to j-multi:>new()
                 if mail-text not = spaces
                    set mbp to j-attach:>new()
                    mbp:>setContent(mail-text as string, 
                                      mime-type as string)
                    multi:>addBodyPart(mbp)
                 end-if
                 set attachments to j-string:>new(mail-attach 
                                      as string):>split(",")
                 set attachments-count to attachments:>length()
                 perform varying idx from 0 by 1 
                                   until idx = attachments-count
                    set mbp to j-attach:>new()
                    mbp:>attachFile(attachments(idx))
                    multi:>addBodyPart(mbp)
                 end-perform
                 msg:>setContent(multi)
                 transport:>send(msg)
              else
                 if mail-text not = spaces
                    msg:>setContent(mail-text as string, 
                             mime-type as string)
                 end-if   
                 transport:>send(msg)
              end-if   
           catch exception
              display "Send failed"
              display exception-object
              set send-ok to false
           end-try.

           if Send-ok
              display "Send OK"
           end-if.

