      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.


       IDENTIFICATION DIVISION.
       >>DOC
      *STD_DATE provides some methods to handle dates. 
       >>END-DOC
       CLASS-ID. STD_DATE as "IS_DATE.STD_DATE".

       IDENTIFICATION DIVISION.
       FACTORY.

       PROCEDURE DIVISION.


       IDENTIFICATION DIVISION.
       >>DOC
      *check_date method checks if a date is valid or not. <br>
      *It expects a pic 9(9) item as parameter <br>
      *It returns 0 if the date is valid, -1 otherwise
       >>END-DOC
       METHOD-ID. check-date as "check_date".
       WORKING-STORAGE SECTION.
       77  date-to-greg  pic 9(8).
       77  greg-to-date  pic 9(8).
       77  result        pic s9(9).
       LINKAGE SECTION.
       77  date-to-check pic 9(8).
       PROCEDURE DIVISION using date-to-check returning result.
       MAIN.
           move function integer-of-date(date-to-check) to date-to-greg.
           move function date-of-integer(date-to-greg)  to greg-to-date.
           if greg-to-date = date-to-check
              move 0 to result
           else
              move -1 to result
           end-if.
           goback.
       END METHOD.


       IDENTIFICATION DIVISION.
       >>DOC
      *which_day method returns the day of the week corresponding to a 
      *given date. <br> It expects a pic 9(8) item as parameter. <br>
      *It returns a number from 1 to 7 where 1 is Monday and 7 Sunday.
       >>END-DOC
       METHOD-ID. which-day as "which_day" .
       WORKING-STORAGE SECTION.
       77  today     pic 9.
       77  theday    pic s99.
       77  temp-var1 pic s9(8).
       77  date-now  pic 9(8).
       LINKAGE SECTION.
       77  date-to-check pic 9(8).
       PROCEDURE DIVISION using date-to-check returning theday.
       MAIN.    
           accept today from day-of-week.
           accept date-now from century-date.
           compute temp-var1 = function integer-of-date(date-to-check) -
                               function integer-of-date(date-now)
           move function mod(temp-var1, 7) to theday.
           if theday < 0
              add 7 to theday
           end-if
           add  today to theday.
           if theday > 7
              subtract 7 from theday
           end-if. 
           goback.
       END METHOD.   
                        
       END FACTORY.