       IDENTIFICATION DIVISION.

       CLASS-ID. WCWINHANDLER AS 
                  "WINDOWCREATIONHOOK" 
                  IMPLEMENTS JWINDOWCREATEHANDLER.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           CLASS JWINDOWATTRIBUTEHOOK AS 
                 "com.iscobol.gui.server.WindowAttributeHook"
           CLASS JWINDOWCREATEOVERFLOWEXCEPTION AS 
                 "com.iscobol.rts.WindowCreateOverflowException"
           CLASS JWINDOWCREATEHANDLER AS 
                 "com.iscobol.rts.WindowCreateHandler"
           .

       IDENTIFICATION DIVISION.
       OBJECT.
       WORKING-STORAGE SECTION.
       77  wrk-called-by pic x any length.
       77  win-type    pic x any length.
       PROCEDURE DIVISION.

       IDENTIFICATION DIVISION.
       METHOD-ID. IS-WINDOWCREATE AS "beforeWindowCreate" override.
       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscobol.def".

       77  wrk-dimension   pic s9(5)v99.

       LINKAGE SECTION.
       77  MyWinAttribute OBJECT REFERENCE JWINDOWATTRIBUTEHOOK.

       procedure division using MyWinAttribute 
                          raising jwindowcreateoverflowexception.

       MAIN.
           set wrk-called-by to MyWinAttribute:>getProgName
           set win-type to MyWinAttribute:>getType

           evaluate win-type
           when "STANDARD"
                MyWinAttribute:>setResizable(1)
                MyWinAttribute:>setLayoutManager ("LMZOOM")
                MyWinAttribute:>setBackground(-35909)
           when "INDEPENDENT"
                MyWinAttribute:>setResizable(1)
                MyWinAttribute:>setLayoutManager("LM-ZOOM")
                set wrk-dimension to MyWinAttribute:>getLines
                add 1.5  to wrk-dimension;;
                MyWinAttribute:>setLines(wrk-dimension)
                MyWinAttribute:>setMinLines(wrk-dimension)
                MyWinAttribute:>setBackground(-16054783)
                set wrk-dimension  to MyWinAttribute:>getSize
                MyWinAttribute:>setMinSize(wrk-dimension)
           when "FLOATING"
                MyWinAttribute:>setBackground(-13443370)
           end-evaluate.

           goback
           .

       END METHOD.

       IDENTIFICATION DIVISION.
       METHOD-ID. IS-AFTERWINDOWCREATE AS "afterWindowCreate" override.
       WORKING-STORAGE SECTION.
       77  win-handle handle of window.
       77  mystatus handle of status-bar.
       LINKAGE SECTION.
       77  myWinhandler OBJECT REFERENCE JWINDOWATTRIBUTEHOOK.
       procedure division using myWinhandler
                        raising jwindowcreateoverflowexception.
       MAIN.
           evaluate win-type
           when "INDEPENDENT"
                myWinhandler:>getHandle(win-handle);
                display status-bar panel-widths (25, 17, -1)
                        panel-style (1, 1, 1)
                        panel-text (wrk-called-by
                                    " ", " ")
                        handle mystatus
                        upon win-handle
           end-evaluate

           .
       END METHOD.
       END OBJECT.

       
