
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows how to create a REST webservice from a legacy COBOL source code using**
**the isCOBOL Service Bridge and how to insert some custom code into the Bridge program**
**(restPRINTSONGS.cbl).**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
 - 1 Using a command prompt window go to the "$ISCOBOL/sample/eis/webservice/bridge/rest" folder

 - 2 Compile the legacy program that will work as a server

        iscc -whttp SONGS.cbl LISTSONGS.cbl PRINTSONGS.cbl 

 **NOTE:**

        The -whttp option will tell the compiler to show warnings for statements that are 
             not supported by EIS/Mobile 

 - 3 Optional steps for the Url match

   - 3a Add to the classpath the file "servlet-api-3.1.jar" placed into 
          "$ISCOBOL/sample/eis/files" folder
   
            export CLASSPATH=../../../files/servlet-api-3.1.jar:$CLASSPATH

   - 3b Compile the URL filter servlet program

            iscc -whttp SusiFilter.cbl

 **NOTE:**

        The -whttp option will tell the compiler to show warnings for statements that are 
             not supported by EIS/Mobile 

 - 4 Create the "songs-rest.war" running the build.sh for the standard deploy or build-url-match.sh
     for the url match

**NOTE:**

        The war created by build.sh creates a Jakarta servlet (Tomcat 10 or higher).
        If you need to use a JEE servlet (Tomcat 9 or lower), you must modify the build.sh file 
        to copy web.jee.servlet.xml instead of web.xml into the WEB-INF folder, renaming it to web.xml. 
        Update the line as follows:
        copy "$ISCOBOL/sample/eis/files/web.jee.servlet.xml" "$ISCOBOL/sample/eis/webservice/rest/songs-rest/WEB-INF/web.xml"

 - 5 Deploy the webapp from $ISCOBOL/sample/eis/webservice/bridge/rest/songs-rest.war 
     in your servlet container 
   
 **NOTE:**

    To test the application follow the instructions at the end of README.md

 **NOTE:**

    To run this sample in debug mode, follow these steps
    - add the option "-d" or "-dx" during compilation
    - add iscobol.rundebug=1 or iscobol.rundebug=2 to iscobol.properties file
    - optionally add iscobol.debug.port=<port-number>,  useful if you have more than 1 webapps 
    - execute the remote debugger with the following command
      iscrun -d -r <host-name> <port-number>
      from $ISCOBOL/sample/eis/webservice/bridge/rest/songs-rest folder

----------
### There are multiple ways to test the web service application simulating client requests:

----------
 - using a web browser with the html provided with the sample
 - using third party application, such as web browser
 - using the COBOL bean program generated by compiling the web service application
 - using Java to call methods exposed in the COBOL bean program

----------
#### Test using web browser with the html provided with the sample
 To test the webapp from your browser, use the following url:

    http://localhost:8080/songs-rest 

 Change the address and port to reflect your deployment configuration.

----------
#### Test using web browser
 To test the webapp from your browser, use the following url:

    http://localhost:8080/songs-rest/servlet/SONGS?Operation=F 

 Change the address and port to reflect your deployment configuration.
 The browser will show the json data of the first song in the archive.

----------
 - 1 Modify the iscobol.properties file to set the correct connection url for your servlet container 

 - 2 Run the BEANSONGS program to test a sequence of requests

        iscrun beanSONGS 

----------
#### Test using Java to call methods exposed in the COBOL bean program 
 - 1 Edit the Java source code to use the correct connection url

 - 2 Compile the Java program

        "$ISCOBOL_JDK_ROOT/bin/javac" TestBean.java 

 - 3 Run the java program

        "$ISCOBOL_JDK_ROOT/bin/java" TestBean 
