
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**The remote call sample shows how to call a server side program**
**from a client side program**

**The server side program is able to create and access a server side data file**

**The client side program will call the remote side program to perform **
**operations on that data file**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
 - 1 For the server side using a command prompt window, go to the 
     "$ISCOBOL/sample/as/remotecall/server" folder 

 - 2 Compile the server program

        iscc IOFILE.cbl 

 - 3 Start the Server

   - 3a if Isam files are in Jisam format use:

            iscserver -hostname <hostname | IP address> -port <port-number> 

   - 3b if Isam files are in c-tree format use:

            iscserver -hostname <hostname | IP address> -port <port-number> -c runtime.properties  

 **NOTE:**

        if you have already started an instance of the Application Server,
        you can start a new instance of it on a different port

 - 4 For the local side using another command prompt window, go to the 
     "$ISCOBOL/sample/as/remotecall/client" folder 
     and compile the programs in it

 - 5 Compile the client program

        iscc CLIENT.cbl 

 - 6 Modify the iscobol.properties file to set the correct ip adress of your server

 - 7 Run the client sample

        iscrun CLIENT 


### Important considerations:
----------
 If you run this sample from a single PC (using it as server and client)
 then step 2 server startup command will be like any of the following:

    iscserver -hostname 127.0.0.1 -port 10999
    iscserver -hostname 127.0.0.1

 If you use 2 different computers, one for the server and one for the client
 then use the actual IP address of the server on the server startup command on step 3
 and change the IP address on the client side iscobol.properties file as in the
 following sample:

 Startup command:

    iscserver -hostname 10.120.2.5 -port 10999 

 iscobol.properties on the client folder:  

    iscobol.remote.code_prefix=isc://10.120.2.5:10998 

 If for any reason you will not use the default app server port (10999)
 then use the -port <port-number> parameter in the server startup command
 and change the port number on the client side iscobol.properties file
 as in the following sample:

 Startup command:

    iscserver -hostname 127.0.0.1 -port 10998 

 iscobol.properties on the client folder:  

    iscobol.remote.code_prefix=isc://127.0.0.1:10998 

----------
### Note to test this with debugger follow these instructions:

**to debug client side**

 add the option "-d" or "-dx" during compilation
 and add the "-d" option during the execution
  
**to debug the server side**
 add the option "-d" or "-dx" during compilation and follow
 the following steps for the execution:
   
 - 1 For the server side using a command prompt window, go to the 
     "$ISCOBOL/sample/as/remotecall/server" folder 
     and compile the programs in it

        iscc -d IOFILE.cbl 

 - 2 Create a file called iscobol.properties and add the following property

        iscobol.rundebug=1 

 - 3 Start the Server

        iscserver -hostname <hostname | IP address> -port <port-number> 

 - 4 Open another command prompt window on the client side, go to the $ISCOBOL/sample/as/remotecall/server folder 
     and execute the remote debugger

        iscrun -d -r <hostname | IP address> <port-number> 

 **NOTE:**

        With this command the remote debugger is started. The debugger is still not 
        activated until the remote program starts
