/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.Console;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.CLIST;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.directives.LIST;
import com.veryant.cobol.compiler.directives.PREPROCESS;
import com.veryant.cobol.compiler.frontend.CharStream;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import com.veryant.cobol.preproc.AbstractPreprocessor;
import com.veryant.cobol.preproc.CachedCobolLine;
import com.veryant.cobol.preproc.CobolLine;
import com.veryant.cobol.preproc.CopyPreprocessor;
import com.veryant.cobol.preproc.ListWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class CodeStream
implements CharStream,
IDirectiveListener {
    private final AbstractPreprocessor preprocessor;
    private boolean eof;
    private static final int BUFF_SIZE = 257;
    private final Console console;
    private ListWriter listWriter;
    private ListWriter cleanListWriter;
    private boolean listSettings = false;
    private int size;
    private int available;
    private char[] buffer;
    private int[] lines;
    private int[] columns;
    private String[] filenames;
    private int readAgain;
    private int mark;
    private int offset;
    private int maxOffset;
    boolean isInit = true;
    private Directives directives;
    private boolean[] _subscribedDirectivesFlags = null;

    @Override
    public int getEndColumn() {
        return this.columns[this.offset];
    }

    @Override
    public int getEndLine() {
        return this.lines[this.offset];
    }

    @Override
    public int getBeginColumn() {
        return this.columns[this.mark];
    }

    @Override
    public int getBeginLine() {
        return this.lines[this.mark];
    }

    public String getEndSourceFile() {
        return this.filenames[this.offset];
    }

    public String getBeginSourceFile() {
        return this.filenames[this.mark];
    }

    private void initListing(File file) {
        String string;
        this.listWriter = null;
        LIST lIST = (LIST)this.directives.getDirective(178);
        try {
            string = lIST.getOutput(file);
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(iOException.getMessage());
        }
        if (string != null) {
            try {
                this.listWriter = new ListWriter(string, this.directives);
            }
            catch (IOException iOException) {
                throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
            }
        }
        this.cleanListWriter = null;
        CLIST cLIST = (CLIST)this.directives.getDirective(44);
        try {
            string = cLIST.getOutput(file);
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(iOException.getMessage());
        }
        if (string != null) {
            try {
                this.cleanListWriter = new ListWriter(string, this.directives);
            }
            catch (IOException iOException) {
                throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
            }
        }
    }

    private char list(char c) throws IOException {
        if (this.cleanListWriter != null) {
            this.cleanListWriter.write(c);
        }
        return c;
    }

    private void closeListing() throws IOException {
        if (this.listWriter != null) {
            if (this.listSettings) {
                this.listSettings = false;
                this.listSettings();
            }
            this.listWriter.close();
        }
        if (this.cleanListWriter != null) {
            this.cleanListWriter.close();
        }
        IDirectiveListener.super.close();
    }

    public CodeStream(File file, Console console, Directives directives) {
        this.console = console;
        this.registerListener(directives);
        this.available = this.size = 257;
        this.buffer = new char[this.size];
        this.lines = new int[this.size];
        this.columns = new int[this.size];
        this.filenames = new String[this.size];
        this.offset = -1;
        this.maxOffset = 0;
        this.mark = 0;
        this.readAgain = 0;
        PREPROCESS pREPROCESS = (PREPROCESS)directives.getDirective(238);
        try {
            if (pREPROCESS.isNo()) {
                this.preprocessor = new CopyPreprocessor(file.getAbsolutePath(), directives);
            } else {
                Class<?> clazz = Class.forName(pREPROCESS.getPreprocessor());
                Class<AbstractPreprocessor> clazz2 = clazz.asSubclass(AbstractPreprocessor.class);
                this.preprocessor = clazz2.getConstructor(String.class, Directives.class).newInstance(file.getAbsolutePath(), directives);
            }
        }
        catch (IOException iOException) {
            throw new COBOLCompilerException(String.format("Cannot access file: %s", file.getAbsolutePath()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new COBOLCompilerException(String.format("Preprocessor %s not found", pREPROCESS.getPreprocessor()));
        }
        catch (ClassCastException classCastException) {
            throw new COBOLCompilerException("Preprocessor must be an AbstractPreprocessor subclass");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new COBOLCompilerException("Preprocessor has no eligible constructor");
        }
        this.initListing(file);
    }

    private void expandBuffer(boolean bl) {
        char[] cArray = new char[this.size + 257];
        int[] nArray = new int[this.size + 257];
        int[] nArray2 = new int[this.size + 257];
        String[] stringArray = new String[this.size + 257];
        if (bl) {
            System.arraycopy(this.buffer, this.mark, cArray, 0, this.size - this.mark);
            System.arraycopy(this.buffer, 0, cArray, this.size - this.mark, this.offset);
            this.buffer = cArray;
            System.arraycopy(this.lines, this.mark, nArray, 0, this.size - this.mark);
            System.arraycopy(this.lines, 0, nArray, this.size - this.mark, this.offset);
            this.lines = nArray;
            System.arraycopy(this.columns, this.mark, nArray2, 0, this.size - this.mark);
            System.arraycopy(this.columns, 0, nArray2, this.size - this.mark, this.offset);
            this.columns = nArray2;
            System.arraycopy(this.filenames, this.mark, stringArray, 0, this.size - this.mark);
            System.arraycopy(this.filenames, 0, stringArray, this.size - this.mark, this.offset);
            this.filenames = stringArray;
            this.maxOffset = this.offset += this.size - this.mark;
        } else {
            System.arraycopy(this.buffer, this.mark, cArray, 0, this.size - this.mark);
            this.buffer = cArray;
            System.arraycopy(this.lines, this.mark, nArray, 0, this.size - this.mark);
            this.lines = nArray;
            System.arraycopy(this.columns, this.mark, nArray2, 0, this.size - this.mark);
            this.columns = nArray2;
            System.arraycopy(this.filenames, this.mark, stringArray, 0, this.size - this.mark);
            this.filenames = stringArray;
            this.maxOffset = this.offset -= this.mark;
        }
        this.size += 257;
        this.available = this.size;
        this.mark = 0;
    }

    private void eof() throws EOFException {
        --this.offset;
        this.backup(0);
        if (this.mark == -1) {
            this.mark = this.offset;
        }
        throw new EOFException();
    }

    private void fillBuffer() throws IOException {
        while (true) {
            CachedCobolLine cachedCobolLine;
            if ((cachedCobolLine = this.preprocessor.getLine()) == null) {
                this.eof = true;
                return;
            }
            CobolLine cobolLine = cachedCobolLine.getCobolLine();
            if (this.isInit) {
                switch (cobolLine.getType()) {
                    case 4: 
                    case 7: {
                        this.isInit = false;
                        if (!this.listSettings) break;
                        this.listSettings = false;
                        if (this.listWriter == null) break;
                        this.listSettings();
                    }
                }
            }
            switch (cobolLine.getType()) {
                case 7: {
                    int n = cachedCobolLine.getSourceLine();
                    int n2 = cachedCobolLine.getSourceColumn();
                    String string = cachedCobolLine.getSourceFile();
                    String string2 = cachedCobolLine.getCobolLine().getText();
                    int n3 = string2.length();
                    if (this.maxOffset + n3 >= this.available) {
                        if (this.available == this.size) {
                            if (this.mark > 257) {
                                this.maxOffset = 0;
                                this.offset = 0;
                                this.available = this.mark;
                            } else if (this.mark < 0) {
                                this.maxOffset = 0;
                                this.offset = 0;
                            } else {
                                this.expandBuffer(false);
                            }
                        } else if (this.available > this.mark + n3) {
                            this.available = this.size;
                        } else if (this.mark - this.available < 257) {
                            this.expandBuffer(true);
                        } else {
                            this.available = this.mark;
                        }
                    }
                    for (int i = 0; i <= n3; ++i) {
                        this.lines[this.maxOffset] = n;
                        this.columns[this.maxOffset] = ++n2;
                        this.filenames[this.maxOffset] = string;
                        this.buffer[this.maxOffset++] = i >= n3 ? this.list('\n') : this.list(string2.charAt(i));
                    }
                    return;
                }
                case 8: {
                    this.console.write(new CompilerMessage(0, cachedCobolLine, cobolLine.getText()));
                    break;
                }
                case 9: {
                    this.console.write(new CompilerMessage(1, cachedCobolLine, cobolLine.getText()));
                }
            }
            if (this.listWriter == null) continue;
            if (cobolLine.getType() != 7) {
                this.listWriter.write(cobolLine);
            }
            if (this.isInit || !this.listSettings) continue;
            this.listSettings = false;
            this.listSettings();
        }
    }

    private void listSettings() {
        try {
            ArrayList<String> arrayList = this.directives.getSettingsTexts();
            if (arrayList != null) {
                for (String string : arrayList) {
                    this.listWriter.write(string);
                    this.listWriter.newLine();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.eof) {
            this.eof();
        }
        if (this.readAgain > 0) {
            --this.readAgain;
            if (++this.offset == this.size) {
                this.offset = 0;
            }
            c = this.buffer[this.offset];
        } else {
            if (++this.offset >= this.maxOffset) {
                this.fillBuffer();
            }
            c = this.buffer[this.offset];
        }
        return c;
    }

    @Override
    public void backup(int n) {
        this.readAgain += n;
        if ((this.offset -= n) < 0) {
            this.offset += this.size;
        }
    }

    @Override
    public char BeginToken() throws IOException {
        this.mark = -1;
        char c = this.readChar();
        this.mark = this.offset;
        return c;
    }

    @Override
    public void Done() {
        this.buffer = null;
        this.lines = null;
        this.columns = null;
        this.filenames = null;
    }

    @Override
    public String GetImage() {
        if (this.offset >= this.mark) {
            return new String(this.buffer, this.mark, this.offset - this.mark + 1);
        }
        return new String(this.buffer, this.mark, this.size - this.mark) + new String(this.buffer, 0, this.offset + 1);
    }

    @Override
    public char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (this.offset + 1 >= n) {
            System.arraycopy(this.buffer, this.offset - n + 1, cArray, 0, n);
        } else {
            int n2 = n - this.offset - 1;
            System.arraycopy(this.buffer, this.size - n2, cArray, 0, n2);
            System.arraycopy(this.buffer, 0, cArray, n2, this.offset + 1);
        }
        return cArray;
    }

    @Override
    public void close() throws IOException {
        this.closeListing();
    }

    @Override
    public Directives getDirectives() {
        return this.directives;
    }

    @Override
    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    @Override
    public boolean[] getSubscribedDirectivesFlags() {
        if (this._subscribedDirectivesFlags == null) {
            this._subscribedDirectivesFlags = new boolean[323];
            this._subscribedDirectivesFlags[278] = true;
        }
        return this._subscribedDirectivesFlags;
    }

    @Override
    public void onDirectiveChanged(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 278: {
                this.listSettings = baseDirective.isSet();
            }
        }
    }

    public Console getConsole() {
        return this.console;
    }
}

