/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.SourceFormat;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.directives.SOURCEFORMAT;
import com.veryant.cobol.compiler.directives.SOURCETABSTOP;
import com.veryant.cobol.preproc.CachedCobolLine;
import com.veryant.cobol.preproc.FixedFactory;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractPreprocessor
implements IDirectiveListener,
Closeable {
    private final String filePath;
    private Directives directives;
    private final boolean[] subscribedDirectivesFlags = new boolean[323];
    private int commentDelimiter;
    private int codeDelimiter;
    private int tabSize;
    private String tabReplacer;

    @Override
    public void onDirectiveChanged(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 287: {
                this.setSourceFormat(((SOURCEFORMAT)baseDirective).getFormat());
                break;
            }
            case 288: {
                this.setTabSize(((SOURCETABSTOP)baseDirective).getTabSize());
            }
        }
    }

    private void setSourceFormat(SourceFormat sourceFormat) {
        switch (sourceFormat) {
            case FIXED: {
                this.commentDelimiter = 7;
                this.codeDelimiter = 65;
                break;
            }
            case VARIABLE: {
                this.commentDelimiter = 7;
                this.codeDelimiter = 256;
                break;
            }
            default: {
                this.commentDelimiter = 0;
                this.codeDelimiter = 256;
            }
        }
    }

    private void setTabSize(Integer n) {
        if (n != null) {
            this.tabSize = n;
            this.tabReplacer = new String(FixedFactory.SPACES, 0, (int)n);
        } else {
            this.tabReplacer = null;
        }
    }

    public AbstractPreprocessor(String string, Directives directives) {
        this.subscribedDirectivesFlags[287] = true;
        this.subscribedDirectivesFlags[288] = true;
        this.filePath = string;
        this.registerListener(directives);
    }

    @Override
    public void close() throws IOException {
        this.unregisterListener();
    }

    public abstract CachedCobolLine getLine() throws IOException;

    protected String getFilePath() {
        return this.filePath;
    }

    @Override
    public Directives getDirectives() {
        return this.directives;
    }

    @Override
    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    @Override
    public boolean[] getSubscribedDirectivesFlags() {
        return this.subscribedDirectivesFlags;
    }

    protected int getCommentDelimiter() {
        return this.commentDelimiter;
    }

    protected int getCodeDelimiter() {
        return this.codeDelimiter;
    }

    protected int getTabSize() {
        return this.tabSize;
    }

    protected String getTabReplacer() {
        return this.tabReplacer;
    }
}

