/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.filehandler.CobolBufferedFileWriter;
import com.veryant.cobol.filehandler.CobolFileBase;
import com.veryant.cobol.rununit.RunUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public abstract class CobolFileSequentialBase
extends CobolFileBase {
    protected RandomAccessFile randomAccessFile = null;
    protected FileChannel fileChannel = null;
    protected long readPosition = 0L;
    protected RandomAccessFile randomRewriteFile = null;
    protected FileChannel rewriteChannel = null;
    protected long rewriteChannelPosition = 0L;
    protected long rewritePosition = 0L;
    protected CobolBufferedFileWriter cobolBufferedFileWriter = null;
    protected File lockFile = null;
    protected RandomAccessFile lockRandomAccessFile = null;
    protected File file = null;
    protected List<FileLock> fileLocks = new ArrayList<FileLock>(16);
    private final List<FileLock> locks = new ArrayList<FileLock>(16);
    private FileLock singleRecordLock = null;

    public CobolFileSequentialBase(RunUnit runUnit, CobolDataReference cobolDataReference) {
        super(runUnit, cobolDataReference);
    }

    @Override
    public final byte[] open(int n, int n2, String string, byte by, byte by2) {
        byte[] byArray = errSuccess;
        try {
            switch (n2) {
                case 0: {
                    this.createJavaIoFile(string);
                    if (!this.file.exists()) {
                        if (this.fcdIsOptional()) {
                            this.currentOpenMode = n2;
                            return errOptionalFileMissing;
                        }
                        return errFileNotFound;
                    }
                    if ((by & 1) != 0 ? !CobolFileSequentialBase.isStatusSuccess(byArray = this.lockFileExclusive()) : !CobolFileSequentialBase.isStatusSuccess(byArray = this.checkExclusiveFileLock())) {
                        return byArray;
                    }
                    this.randomAccessFile = this.openRandomAccessFile("r");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    byArray = this.afterOpenInput(byArray);
                    break;
                }
                case 1: {
                    this.createJavaIoFile(string);
                    byArray = this.lockFileExclusive();
                    if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
                        return byArray;
                    }
                    byArray = this.beforeOpenInput();
                    if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
                        return byArray;
                    }
                    this.randomAccessFile = this.openRandomAccessFile("rw");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    byArray = this.afterOpenOutput(byArray);
                    this.randomAccessFile.setLength(0L);
                    break;
                }
                case 2: {
                    this.createJavaIoFile(string);
                    if (!this.file.exists() && !this.file.createNewFile()) {
                        return errNoPermissions;
                    }
                    if ((by & 1) != 0 ? !CobolFileSequentialBase.isStatusSuccess(byArray = this.lockFileExclusive()) : !CobolFileSequentialBase.isStatusSuccess(byArray = this.checkExclusiveFileLock())) {
                        return byArray;
                    }
                    byArray = this.beforeOpenOutput();
                    if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
                        return byArray;
                    }
                    this.randomAccessFile = this.openRandomAccessFile("rw");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    this.randomRewriteFile = this.openRandomAccessFile("rw");
                    this.rewriteChannel = this.randomRewriteFile.getChannel();
                    byArray = this.afterOpenIO(byArray);
                    break;
                }
                case 3: {
                    this.createJavaIoFile(string);
                    if (!this.file.exists() && !this.file.createNewFile()) {
                        return errNoPermissions;
                    }
                    if ((by & 1) != 0 ? !CobolFileSequentialBase.isStatusSuccess(byArray = this.lockFileExclusive()) : !CobolFileSequentialBase.isStatusSuccess(byArray = this.checkExclusiveFileLock())) {
                        return byArray;
                    }
                    byArray = this.beforeOpenExtend();
                    if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
                        return byArray;
                    }
                    this.randomAccessFile = this.openRandomAccessFile("rw");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    this.randomAccessFile.seek(this.randomAccessFile.length());
                    byArray = this.afterOpenExtend(byArray);
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        if (CobolFileSequentialBase.isStatusSuccess(byArray)) {
            this.currentOpenMode = n2;
        }
        return byArray;
    }

    @Override
    public final byte[] close(int n) {
        try {
            this.releaseRecordLocks();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.unlockExclusiveFile();
        try {
            if (this.randomRewriteFile != null) {
                this.randomRewriteFile.close();
                this.randomRewriteFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.randomAccessFile != null) {
                if (this.cobolBufferedFileWriter != null) {
                    this.cobolBufferedFileWriter.flush();
                }
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    @Override
    public byte[] commit() {
        try {
            this.releaseRecordLocks();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return errSuccess;
    }

    @Override
    public byte[] delete() {
        return this.automaticLockRelease();
    }

    @Override
    public byte[] read(int n, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = this.automaticLockRelease();
        if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
            return byArray;
        }
        return this.isAccessRandom ? byArray : errFileNotOpenForReadOrStart;
    }

    @Override
    public byte[] next(int n, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = this.automaticLockRelease();
        if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
            return byArray;
        }
        return this.isAccessSequential ? byArray : errFileNotOpenForReadOrStart;
    }

    @Override
    public byte[] previous(int n, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = this.automaticLockRelease();
        if (!CobolFileSequentialBase.isStatusSuccess(byArray)) {
            return byArray;
        }
        return this.isAccessSequential ? byArray : errFileNotOpenForReadOrStart;
    }

    @Override
    public byte[] rollback() {
        try {
            this.releaseRecordLocks();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return errSuccess;
    }

    @Override
    public byte[] start(int n) {
        return this.isAccessSequential ? errSuccess : errFileNotOpenForReadOrStart;
    }

    @Override
    public byte[] unlock() {
        try {
            this.releaseRecordLocks();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return errSuccess;
    }

    @Override
    public byte[] write(int n) {
        return this.automaticLockRelease();
    }

    @Override
    public byte[] rewrite() {
        return this.automaticLockRelease();
    }

    private byte[] automaticLockRelease() {
        try {
            if (this.isLockAutomatic) {
                this.releaseRecordLocks();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return errSuccess;
    }

    protected byte[] beforeOpenInput() {
        return errSuccess;
    }

    protected byte[] beforeOpenOutput() {
        return errSuccess;
    }

    protected byte[] beforeOpenIO() {
        return errSuccess;
    }

    protected byte[] beforeOpenExtend() {
        return errSuccess;
    }

    protected byte[] afterOpenInput(byte[] byArray) {
        return byArray;
    }

    protected byte[] afterOpenOutput(byte[] byArray) {
        return byArray;
    }

    protected byte[] afterOpenIO(byte[] byArray) {
        return byArray;
    }

    protected byte[] afterOpenExtend(byte[] byArray) throws IOException {
        return byArray;
    }

    protected final void createJavaIoFile(String string) {
        this.file = new File(Paths.get(string, new String[0]).toAbsolutePath().toString());
        Path path = this.file.toPath();
        this.lockFile = new File(Paths.get(path.getParent().toString(), "." + path.getFileName() + ".lock").toString());
    }

    protected final RandomAccessFile openRandomAccessFile(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, string);
        this.file = new File(this.file.toPath().toRealPath(new LinkOption[0]).toString());
        return randomAccessFile;
    }

    protected final byte[] lockFileExclusive() {
        try {
            if (this.lockFile.exists() && !this.lockFile.delete()) {
                return errFileLocked;
            }
            this.lockRandomAccessFile = new RandomAccessFile(this.lockFile, "rw");
            return errSuccess;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
            return errNoPermissions;
        }
        return errSuccess;
    }

    protected final void unlockExclusiveFile() {
        if (this.lockRandomAccessFile == null) {
            return;
        }
        try {
            this.lockRandomAccessFile.close();
            this.lockRandomAccessFile = null;
            if (this.lockFile.exists()) {
                this.lockFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final byte[] checkExclusiveFileLock() throws FileNotFoundException {
        if (this.lockFile.exists() && !this.lockFile.renameTo(this.lockFile)) {
            return errFileLocked;
        }
        return errSuccess;
    }

    protected final byte[] lockFileSection(FileChannel fileChannel, long l, long l2) {
        this.singleRecordLock = null;
        try {
            this.singleRecordLock = fileChannel.tryLock(l, l2, false);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return errRecordLocked;
        }
        catch (SecurityException securityException) {
            return errNoPermissions;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.singleRecordLock != null) {
            if (this.isMultiLock) {
                this.locks.add(this.singleRecordLock);
                this.singleRecordLock = null;
            }
            return errSuccess;
        }
        return errRecordLocked;
    }

    protected final void releaseRecordLocks() throws IOException {
        if (this.isMultiLock) {
            for (FileLock fileLock : this.locks) {
                fileLock.release();
            }
            this.locks.clear();
        } else if (this.singleRecordLock != null) {
            this.singleRecordLock.release();
            this.singleRecordLock = null;
        }
    }

    protected final byte[] getSecurityExceptionError(Exception exception) {
        exception.printStackTrace();
        return errPermanent;
    }

    protected final byte[] getPermanentError(Exception exception) {
        exception.printStackTrace();
        return errPermanent;
    }
}

