/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Raw;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class PackedDecimal {
    protected static final int UNSIGNED_ANSI = 0;
    protected static final int SIGNED_ANSI = 1;
    protected static final int UNSIGNED_COMP6 = 2;
    protected static final int SIGNED_ACU = 3;
    protected static final int SIGNED_NCR = 4;
    private static final byte[] ENCODED_BYTES_COUNT;
    private static final byte[] ENCODED_BYTES_NO_SIGN_COUNT;
    protected static final byte PACKED_NO_SIGN = 15;
    protected static final byte PACKED_POS_SIGN = 12;
    protected static final byte PACKED_NEG_SIGN = 13;
    protected static final byte PACKED_NCR_POS_SIGN = 11;
    private static final int[] BYTES_MAP;
    private static final int CACHE_SIGN_SIZE = 100000;
    private static final int CACHE_SIGN_BYTES = 3;
    private static final byte[][] CACHE_SIGN;
    private static final int CACHE_NO_SIGN_SIZE = 10000;
    private static final int CACHE_NO_SIGN_BYTES = 2;
    private static final byte[][] CACHE_NO_SIGN;

    protected static int loadInt(IMemory iMemory, int n, int n2, int n3) {
        if (n3 == 2) {
            int n4;
            int n5 = n;
            int n6 = n + ENCODED_BYTES_NO_SIGN_COUNT[n2];
            do {
                n4 = iMemory.get(n5++) & 0xFF;
                if (n5 != n6) continue;
                return BYTES_MAP[n4];
            } while (n4 == 0);
            n4 = BYTES_MAP[n4];
            do {
                n4 *= 100;
                n4 += BYTES_MAP[iMemory.get(n5++) & 0xFF];
            } while (n5 != n6);
            return n4;
        }
        int n7 = 0;
        int n8 = ENCODED_BYTES_COUNT[n2];
        int n9 = 0;
        while (--n8 > 0 && (n7 = iMemory.get(n++) & 0xFF) == 0) {
        }
        if (n8 > 0) {
            while (true) {
                n9 += BYTES_MAP[n7];
                if (--n8 == 0) {
                    n9 *= 10;
                    break;
                }
                n9 *= 100;
                n7 = iMemory.get(n++) & 0xFF;
            }
        }
        n7 = iMemory.get(n) & 0xFF;
        return n3 != 0 && (n7 & 0xF) == 13 ? -n9 : (n9 += n7 >> 4);
    }

    protected static long loadLong(IMemory iMemory, int n, int n2, int n3) {
        if (n3 == 2) {
            long l;
            int n4 = n;
            int n5 = n + ENCODED_BYTES_NO_SIGN_COUNT[n2];
            do {
                l = iMemory.get(n4++) & 0xFF;
                if (n4 != n5) continue;
                return BYTES_MAP[(int)l];
            } while (l == 0L);
            l = BYTES_MAP[(int)l];
            do {
                l *= 100L;
                l += (long)BYTES_MAP[iMemory.get(n4++) & 0xFF];
            } while (n4 != n5);
            return l;
        }
        int n6 = 0;
        int n7 = ENCODED_BYTES_COUNT[n2];
        long l = 0L;
        while (--n7 > 0 && (n6 = iMemory.get(n++) & 0xFF) == 0) {
        }
        if (n7 > 0) {
            while (true) {
                l += (long)BYTES_MAP[n6];
                if (--n7 == 0) {
                    l *= 10L;
                    break;
                }
                l *= 100L;
                n6 = iMemory.get(n++) & 0xFF;
            }
        }
        n6 = iMemory.get(n) & 0xFF;
        return n3 != 0 && (n6 & 0xF) == 13 ? -l : (l += (long)(n6 >> 4));
    }

    protected static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n, int n2, int n3, int n4) {
        int n5 = n;
        boolean bl = false;
        int n6 = n2 & 1;
        if (n4 == 2) {
            n5 += ENCODED_BYTES_NO_SIGN_COUNT[n2] - 1;
        } else {
            bl = n4 != 0 && (iMemory.get(n5 += ENCODED_BYTES_COUNT[n2] - 1) & 0xF) == 13;
            n6 ^= 1;
            if ((iMemory.get(n5) & 0xF0) == 0) {
                --n2;
                ++n3;
                --n5;
            }
        }
        while (n2 >= 2 && iMemory.get(n5) == 0) {
            n2 -= 2;
            n3 += 2;
            --n5;
        }
        if (n2 != 0 && (iMemory.get(n5) & 0xF) == 0) {
            --n2;
            ++n3;
        }
        if (n2 == 0) {
            return CobolBigDecimal.ZERO;
        }
        if (n6 != 0 && (iMemory.get(n) & 0xF) == 0) {
            n6 = 0;
            ++n;
            --n2;
        }
        if (n6 == 0) {
            while (iMemory.get(n) == 0) {
                n2 -= 2;
                ++n;
            }
            if ((iMemory.get(n) & 0xF0) == 0) {
                n6 = 1;
                --n2;
            }
        }
        byte[] byArray = new byte[n2];
        n5 = 0;
        if (n6 != 0) {
            byArray[n5++] = (byte)(iMemory.get(n) & 0xF);
            --n2;
            ++n;
        }
        while (n2 >= 2) {
            byArray[n5++] = (byte)((iMemory.get(n) & 0xF0) >>> 4);
            byArray[n5++] = (byte)(iMemory.get(n) & 0xF);
            n2 -= 2;
            ++n;
        }
        if (n2 != 0) {
            byArray[n5] = (byte)((iMemory.get(n) & 0xF0) >>> 4);
        }
        return new CobolBigDecimal(bl, byArray, n3 + byArray.length);
    }

    protected static void store(int n, IMemory iMemory, int n2, int n3, int n4) {
        int n5;
        byte[] byArray;
        boolean bl;
        int n6;
        byte by;
        byte by2;
        boolean bl2;
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        switch (n4) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n3];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 11;
            }
        }
        int n7 = n6 = n2 + by2;
        if (n4 == 2) {
            bl = n > 9999;
            byArray = CACHE_NO_SIGN[bl ? n % 10000 : n];
            for (n5 = 0; n5 < 2 && n3 > 0; n3 -= 2, ++n5) {
                iMemory.put(--n7, byArray[n5]);
            }
        } else {
            ++n3;
            bl = n > 99999;
            byArray = CACHE_SIGN[bl ? n % 100000 : n];
            for (n5 = 0; n5 < 3 && n3 > 0; n3 -= 2, ++n5) {
                iMemory.put(--n7, byArray[n5]);
            }
        }
        if (bl && n3 > 0) {
            n /= n4 == 2 ? 10000 : 100000;
            while (n > 0 && n3 > 0) {
                bl = n > 9999;
                byArray = CACHE_NO_SIGN[bl ? n % 10000 : n];
                for (n5 = 0; n5 < 2 && n3 > 0; n3 -= 2, ++n5) {
                    iMemory.put(--n7, byArray[n5]);
                }
                n /= 10000;
            }
        }
        if (n3 == -1) {
            iMemory.and(n7, (byte)15);
        } else {
            while (n7 > n2) {
                iMemory.put(--n7, (byte)0);
            }
        }
        iMemory.or(n6 - 1, by);
    }

    protected static void store(long l, IMemory iMemory, int n, int n2, int n3) {
        int n4;
        byte[] byArray;
        boolean bl;
        int n5;
        byte by;
        byte by2;
        boolean bl2;
        boolean bl3 = bl2 = l < 0L;
        if (bl2) {
            l = -l;
        }
        switch (n3) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = bl2 ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n2];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = bl2 ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = bl2 ? (byte)13 : 11;
            }
        }
        int n6 = n5 = n + by2;
        if (n3 == 2) {
            bl = l > 9999L;
            byArray = CACHE_NO_SIGN[(int)(bl ? l % 10000L : l)];
            for (n4 = 0; n4 < 2 && n2 > 0; n2 -= 2, ++n4) {
                iMemory.put(--n6, byArray[n4]);
            }
        } else {
            ++n2;
            bl = l > 99999L;
            byArray = CACHE_SIGN[(int)(bl ? l % 100000L : l)];
            for (n4 = 0; n4 < 3 && n2 > 0; n2 -= 2, ++n4) {
                iMemory.put(--n6, byArray[n4]);
            }
        }
        if (bl && n2 > 0) {
            l /= n3 == 2 ? 10000L : 100000L;
            while (l > 0L && n2 > 0) {
                bl = l > 9999L;
                byArray = CACHE_NO_SIGN[(int)(bl ? l % 10000L : l)];
                for (n4 = 0; n4 < 2 && n2 > 0; n2 -= 2, ++n4) {
                    iMemory.put(--n6, byArray[n4]);
                }
                l /= 10000L;
            }
        }
        if (n2 == -1) {
            iMemory.and(n6, (byte)15);
        } else {
            while (n6 > n) {
                iMemory.put(--n6, (byte)0);
            }
        }
        iMemory.or(n5 - 1, by);
    }

    protected static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n, int n2, int n3, int n4) {
        byte by;
        byte by2;
        switch (n4) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n2];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n2];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 11;
            }
        }
        Raw.initMemory(iMemory, n, by2, (byte)0);
        int n5 = n + by2 - 1;
        byte[] byArray = cobolBigDecimal.getMantissa();
        int n6 = cobolBigDecimal.getDigits();
        int n7 = cobolBigDecimal.getExp();
        if (!cobolBigDecimal.isZero() && n7 > n3 && n7 - n6 < n3 + n2) {
            int n8;
            int n9 = n2 & 1;
            if (n4 != 2) {
                n9 ^= 1;
            }
            if (n3 + n2 > n7) {
                n8 = n3 + n2 - n7;
                n2 -= n8;
                n += (n8 + n9) / 2;
                n9 = n8 + n9 & 1;
            }
            n8 = n3 + n2 - Math.max(n7 - n6, n3);
            int n10 = n7 - (n3 + n2);
            if (n9 != 0) {
                iMemory.put(n++, byArray[n10++]);
                --n8;
            }
            while (n8 > 1) {
                iMemory.put(n++, (byte)((byArray[n10] << 4) + byArray[n10 + 1]));
                n10 += 2;
                n8 -= 2;
            }
            if (n8 != 0) {
                iMemory.put(n, (byte)(byArray[n10] << 4));
            }
        }
        iMemory.or(n5, by);
    }

    public static int digitsToBytes(int n) {
        return ENCODED_BYTES_COUNT[n];
    }

    public static int digitsToBytesNoSign(int n) {
        return ENCODED_BYTES_NO_SIGN_COUNT[n];
    }

    static {
        byte by;
        int n;
        int n2;
        int n3;
        ENCODED_BYTES_COUNT = new byte[]{0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20};
        ENCODED_BYTES_NO_SIGN_COUNT = new byte[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19};
        BYTES_MAP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 0, 0, 0, 0, 0, 0, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 0, 0, 0, 0, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 0, 0, 0, 0, 0, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 0, 0, 0, 0, 0, 0, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 0, 0, 0, 0, 0, 0, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 0, 0, 0, 0, 0, 0, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 0, 0, 0, 0, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 0, 0, 0, 0, 0, 0, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        CACHE_SIGN = new byte[100000][3];
        CACHE_NO_SIGN = new byte[10000][2];
        for (n3 = 0; n3 < 100000; ++n3) {
            n2 = n3 * 10;
            for (n = 0; n < 3; ++n) {
                by = (byte)(n2 % 10);
                by = (byte)(by | (n2 /= 10) % 10 << 4);
                n2 /= 10;
                PackedDecimal.CACHE_SIGN[n3][n] = by;
            }
        }
        for (n3 = 0; n3 < 10000; ++n3) {
            n2 = n3;
            for (n = 0; n < 2; ++n) {
                by = (byte)(n2 % 10);
                by = (byte)(by | (n2 /= 10) % 10 << 4);
                n2 /= 10;
                PackedDecimal.CACHE_NO_SIGN[n3][n] = by;
            }
        }
    }
}

