/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Binary;
import com.veryant.cobol.converters.CMPXS;
import com.veryant.cobol.converters.Endianness;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class CMP5S
extends Binary {
    private static final boolean BIG_ENDIAN = Endianness.isBigEndian();

    public static int loadInt(IMemory iMemory, int n, int n2) {
        if (BIG_ENDIAN) {
            return CMPXS.loadInt(iMemory, n, n2);
        }
        int n3 = iMemory.get(n += --n2);
        while (n2 > 0) {
            n3 = n3 << 8 | iMemory.get(--n) & 0xFF;
            --n2;
        }
        return n3;
    }

    public static long loadLong(IMemory iMemory, int n, int n2) {
        if (BIG_ENDIAN) {
            return CMPXS.loadLong(iMemory, n, n2);
        }
        long l = iMemory.get(n += --n2);
        while (n2 > 0) {
            l = l << 8 | (long)(iMemory.get(--n) & 0xFF);
            --n2;
        }
        return l;
    }

    public static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n, int n2, int n3) {
        return CMP5S.loadBigDecimal(iMemory, n, n2, n3, true, BIG_ENDIAN);
    }

    public static void store(int n, IMemory iMemory, int n2, int n3) {
        if (BIG_ENDIAN) {
            CMPXS.store(n, iMemory, n2, n3);
            return;
        }
        while (n3 > 0) {
            iMemory.put(n2++, (byte)(n & 0xFF));
            n >>= 8;
            --n3;
        }
    }

    public static void store(long l, IMemory iMemory, int n, int n2) {
        if (BIG_ENDIAN) {
            CMPXS.store(l, iMemory, n, n2);
            return;
        }
        while (n2 > 0) {
            iMemory.put(n++, (byte)(l & 0xFFL));
            l >>= 8;
            --n2;
        }
    }

    public static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n, int n2, int n3, int n4) {
        CMP5S.store(cobolBigDecimal, iMemory, n, n2, n3, n4, true, BIG_ENDIAN);
    }
}

