/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.data.FileBaseData;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Read
extends AbstractStatement {
    private final ReadData data = new ReadData();

    @Override
    public Statements getStatement() {
        return Statements.READ;
    }

    public ReadData getData() {
        return this.data;
    }

    public Read(ISourceReference iSourceReference) {
        super(iSourceReference);
    }

    public static enum LockMode {
        None,
        WithLock,
        WithNoLock,
        WithKeptLock,
        WithIgnoreLock,
        WithWait;

    }

    public static enum ReadType {
        Record,
        Next,
        Previous;

    }

    public class ReadData
    extends FileBaseData {
        private ReadType readType = ReadType.Record;
        private AbstractOperand intoOperand = null;
        private LockMode lockMode = LockMode.None;
        private FileDeclaration.Key key = null;

        public ReadType getReadType() {
            return this.readType;
        }

        public void setReadType(ReadType readType) {
            this.readType = readType;
        }

        public AbstractOperand getIntoOperand() {
            return this.intoOperand;
        }

        public void setIntoOperand(AbstractOperand abstractOperand) {
            this.intoOperand = abstractOperand;
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public void setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
        }

        public FileDeclaration.Key getKey() {
            return this.key;
        }

        public void setKey(FileDeclaration.Key key) {
            this.key = key;
        }

        @Override
        public int getStandardOpcode() {
            switch (this.getReadType()) {
                case Record: {
                    switch (this.getLockMode()) {
                        case None: 
                        case WithIgnoreLock: 
                        case WithWait: {
                            return 246;
                        }
                        case WithLock: 
                        case WithKeptLock: {
                            return this.getFile().isMultipleRecordLock() ? 219 : 218;
                        }
                        case WithNoLock: {
                            return 142;
                        }
                    }
                    break;
                }
                case Next: {
                    switch (this.getLockMode()) {
                        case None: 
                        case WithIgnoreLock: 
                        case WithWait: {
                            return 245;
                        }
                        case WithLock: 
                        case WithKeptLock: {
                            return this.getFile().isMultipleRecordLock() ? 217 : 216;
                        }
                        case WithNoLock: {
                            return 141;
                        }
                    }
                    break;
                }
                case Previous: {
                    switch (this.getLockMode()) {
                        case None: 
                        case WithIgnoreLock: 
                        case WithWait: {
                            return 249;
                        }
                        case WithLock: 
                        case WithKeptLock: {
                            return this.getFile().isMultipleRecordLock() ? 223 : 222;
                        }
                        case WithNoLock: {
                            return 140;
                        }
                    }
                }
            }
            return 127;
        }

        @Override
        public FileBaseData.ExpectedFailure getExpectedFailure() {
            return this.getReadType() == ReadType.Record ? FileBaseData.ExpectedFailure.InvalidKey : FileBaseData.ExpectedFailure.AtEnd;
        }
    }
}

