/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.compiler.memory.IMemoryHandler;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.memory.SimpleChunk;
import java.util.HashMap;
import java.util.Map;

public class LiteralsTable
implements IMemoryHandler<Literal> {
    private int tableSize = 0;
    private Map<Literal, SimpleChunk> literals = new HashMap<Literal, SimpleChunk>();

    public int size() {
        return this.tableSize;
    }

    @Override
    public IChunk add(Literal literal) {
        if (this.literals.containsKey(literal)) {
            SimpleChunk simpleChunk = this.literals.get(literal);
            literal.setChunk(simpleChunk);
            return simpleChunk;
        }
        SimpleChunk simpleChunk = new SimpleChunk(this.tableSize, literal.getLiteralSize());
        literal.setChunk(simpleChunk);
        this.tableSize += simpleChunk.getSize();
        this.literals.put(literal, simpleChunk);
        return simpleChunk;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.tableSize];
        if (this.tableSize > 0) {
            this.literals.forEach((literal, simpleChunk) -> System.arraycopy(literal.getBytes(), 0, byArray, simpleChunk.getOffset(), simpleChunk.getSize()));
        }
        return byArray;
    }
}

