/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.StmtEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.AcceptOmittedEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.AcceptTimeEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.AddEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.BlockEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.CallEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.CancelEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.CloseEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.ComputeEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.ConsoleWriteEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.DeclareEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.DeleteEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.DeleteFileEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.DivideEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.EvaluateEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.ExitEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.GoEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.GobackEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.IfEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.InspectEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.MergeEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.MoveEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.MultiplyEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.OpenEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.PerformEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.PerformNTimesEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.PerformUntilEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.PerformVaryingEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.ReadEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.ReturnEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.RewriteEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.SortEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.StartEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.StopEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.StringEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.SubtractEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.UnlockEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.UnstringEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.WriteEmitter;

public abstract class Mapper {
    public static final StmtEmitter[] emitters = new StmtEmitter[Statements.values().length];

    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        emitters[iStatement.getStatement().ordinal()].emit(jvmCode, iStatement);
    }

    static {
        Mapper.emitters[Statements.ACCEPT_OMITTED.ordinal()] = AcceptOmittedEmitter::emit;
        Mapper.emitters[Statements.ACCEPT_TIME.ordinal()] = AcceptTimeEmitter::emit;
        Mapper.emitters[Statements.ADD.ordinal()] = AddEmitter::emit;
        Mapper.emitters[Statements.BLOCK.ordinal()] = BlockEmitter::emit;
        Mapper.emitters[Statements.CALL.ordinal()] = CallEmitter::emit;
        Mapper.emitters[Statements.CANCEL.ordinal()] = CancelEmitter::emit;
        Mapper.emitters[Statements.CLOSE.ordinal()] = CloseEmitter::emit;
        Mapper.emitters[Statements.COMPUTE.ordinal()] = ComputeEmitter::emit;
        Mapper.emitters[Statements.DECLARE.ordinal()] = DeclareEmitter::emit;
        Mapper.emitters[Statements.DELETE.ordinal()] = DeleteEmitter::emit;
        Mapper.emitters[Statements.DELETE_FILE.ordinal()] = DeleteFileEmitter::emit;
        Mapper.emitters[Statements.DISPLAY.ordinal()] = ConsoleWriteEmitter::emit;
        Mapper.emitters[Statements.DIVIDE.ordinal()] = DivideEmitter::emit;
        Mapper.emitters[Statements.EVALUATE.ordinal()] = EvaluateEmitter::emit;
        Mapper.emitters[Statements.EXIT.ordinal()] = ExitEmitter::emit;
        Mapper.emitters[Statements.GO.ordinal()] = GoEmitter::emit;
        Mapper.emitters[Statements.GOBACK.ordinal()] = GobackEmitter::emit;
        Mapper.emitters[Statements.IF.ordinal()] = IfEmitter::emit;
        Mapper.emitters[Statements.INSPECT.ordinal()] = InspectEmitter::emit;
        Mapper.emitters[Statements.MERGE.ordinal()] = MergeEmitter::emit;
        Mapper.emitters[Statements.MOVE.ordinal()] = MoveEmitter::emit;
        Mapper.emitters[Statements.MULTIPLY.ordinal()] = MultiplyEmitter::emit;
        Mapper.emitters[Statements.OPEN.ordinal()] = OpenEmitter::emit;
        Mapper.emitters[Statements.PERFORM_JMP.ordinal()] = PerformEmitter::emit;
        Mapper.emitters[Statements.PERFORM_N_TIMES.ordinal()] = PerformNTimesEmitter::emit;
        Mapper.emitters[Statements.PERFORM_UNTIL.ordinal()] = PerformUntilEmitter::emit;
        Mapper.emitters[Statements.PERFORM_VARYING.ordinal()] = PerformVaryingEmitter::emit;
        Mapper.emitters[Statements.READ.ordinal()] = ReadEmitter::emit;
        Mapper.emitters[Statements.RETURN.ordinal()] = ReturnEmitter::emit;
        Mapper.emitters[Statements.REWRITE.ordinal()] = RewriteEmitter::emit;
        Mapper.emitters[Statements.SORT.ordinal()] = SortEmitter::emit;
        Mapper.emitters[Statements.START.ordinal()] = StartEmitter::emit;
        Mapper.emitters[Statements.STOP.ordinal()] = StopEmitter::emit;
        Mapper.emitters[Statements.STRING.ordinal()] = StringEmitter::emit;
        Mapper.emitters[Statements.SUBTRACT.ordinal()] = SubtractEmitter::emit;
        Mapper.emitters[Statements.UNLOCK.ordinal()] = UnlockEmitter::emit;
        Mapper.emitters[Statements.UNSTRING.ordinal()] = UnstringEmitter::emit;
        Mapper.emitters[Statements.WRITE.ordinal()] = WriteEmitter::emit;
    }
}

