/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Mapper;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Promoted;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;

public abstract class Opcodes {
    private static final int NEW = 0;
    private static final int LOAD = 1;
    private static final int LOAD_ADDR = 2;
    private static final int STORE = 3;

    public static void NEW(JvmCode jvmCode, AbstractOperand abstractOperand) {
        Mapper.get(abstractOperand.getBuiltIn(), 0).emit(jvmCode, abstractOperand);
    }

    public static void LOAD(JvmCode jvmCode, AbstractOperand abstractOperand) {
        DataItem dataItem;
        if (abstractOperand.getMagnitude() != null && abstractOperand instanceof DataItemReference && (dataItem = ((DataItemReference)abstractOperand).getDataItem()).isPromoted()) {
            Promoted.LOAD.emit(jvmCode, abstractOperand);
            return;
        }
        Mapper.get(abstractOperand.getBuiltIn(), 1).emit(jvmCode, abstractOperand);
    }

    public static void LOAD_ADDR(JvmCode jvmCode, AbstractOperand abstractOperand) {
        Opcodes.LOAD_ADDR(jvmCode, abstractOperand, false);
    }

    public static void LOAD_ADDR(JvmCode jvmCode, AbstractOperand abstractOperand, boolean bl) {
        Mapper.get(abstractOperand.getBuiltIn(), 2).emit(jvmCode, abstractOperand);
        if (!bl) {
            Functions.f_wrap_as_address(jvmCode);
        }
    }

    public static void STORE(JvmCode jvmCode, AbstractOperand abstractOperand) {
        if (abstractOperand.getMagnitude() != null) {
            if (((JvmCodeSnippet)jvmCode.peek()).getVmType() == VMType.ADDRESS) {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.INT128);
            }
            if (abstractOperand instanceof DataItemReference) {
                DataItem dataItem;
                DataItemReference dataItemReference = (DataItemReference)abstractOperand;
                if (dataItemReference.isRounded()) {
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.ROUND(jvmCode, dataItemReference.getMagnitude().getScale());
                }
                if ((dataItem = dataItemReference.getDataItem()).isPromoted()) {
                    Promoted.STORE.emit(jvmCode, abstractOperand);
                    return;
                }
            }
        }
        Mapper.get(abstractOperand.getBuiltIn(), 3).emit(jvmCode, abstractOperand);
    }
}

