/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public abstract class AlphaNumDisplay {
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
        com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.STRING);
    };
    static final BuiltInEmitter STORE = (jvmCode, abstractOperand) -> {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        if (jvmCodeSnippet.getVmType() == VMType.ADDRESS) {
            Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
            jvmCode.push(abstractOperand, VMType.VOID, abstractOperand.getBuiltIn().getStoreConvention().getSimpleName() + ".store(" + jvmCodeSnippet + "," + jvmCode.pop() + ");");
            return;
        }
        if (((VMType)jvmCodeSnippet.getVmType()).is(VMType.INT32, VMType.INT64, VMType.INT128)) {
            Magnitude magnitude = jvmCodeSnippet.getMagnitude();
            Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
            if (jvmCodeSnippet.getVmType() == VMType.INT128) {
                jvmCode.push(abstractOperand, VMType.VOID, abstractOperand.getBuiltIn().getStoreConvention().getSimpleName() + ".store(" + jvmCodeSnippet + "," + magnitude.getDigits() + "," + magnitude.getScale() + "," + jvmCode.pop() + ");");
            } else {
                jvmCode.push(abstractOperand, VMType.VOID, abstractOperand.getBuiltIn().getStoreConvention().getSimpleName() + ".store(" + jvmCodeSnippet + "," + magnitude.getDigits() + "," + jvmCode.pop() + ");");
            }
            return;
        }
        throw new COBOLCompilerException(new CompilerMessage(11, jvmCodeSnippet, new Object[0]));
    };
}

