/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.STDERR;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public final class STDOUT
extends BaseDirective {
    private static final String DEFAULT_EXT = ".err";
    public static final String NAME = "STDOUT";
    private String destination;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkMaxParams(1);
        this.destination = this.getTokenCount() == 0 ? "" : this.getTokenValue(0);
    }

    public PrintStream createStream(File file, Directives directives) throws IOException {
        if (this.destination.equalsIgnoreCase("SYSOUT")) {
            STDERR sTDERR = (STDERR)directives.getDirective(292);
            return sTDERR.isSet() ? System.err : System.out;
        }
        if (this.destination.equalsIgnoreCase("SYSERR")) {
            return System.err;
        }
        return new PrintStream(this.getDestinationFileName(file, this.destination, DEFAULT_EXT));
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.No;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("STDOUT\"SYSOUT\"");
    }

    public String getDestination() {
        return this.destination;
    }

    public STDOUT(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 293;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

