/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.ReservedWordsList;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.ArrayList;

public final class REMOVE
extends BaseDirective {
    public static final String NAME = "REMOVE";
    private ArrayList<String> rwList;

    @Override
    protected void initialize() {
        this.rwList = new ArrayList();
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1, Integer.MAX_VALUE);
        for (int i = 0; i < this.getTokenCount(); ++i) {
            String string = this.getTokenValue(i);
            if (!ReservedWordsList.rwExists(string)) {
                throw Directives.invalidDirectiveException("Directive %s: '%s' not a reserved word.", NAME, string);
            }
            this.rwList.add(ReservedWordsList.normalize(string));
        }
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        for (String string : ((REMOVE)baseDirective).rwList) {
            if (this.rwList.contains(string)) continue;
            this.rwList.add(string);
        }
        return true;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public ArrayList<String> getRwList() {
        return this.rwList;
    }

    public REMOVE(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 260;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

