/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.ReservedWordsList;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.HashMap;

public final class MAKESYN
extends BaseDirective {
    public static final String NAME = "MAKESYN";
    private HashMap<String, String> rwMap;

    @Override
    protected void initialize() {
        this.rwMap = new HashMap();
    }

    @Override
    protected String parseTokensImpl(String string) {
        return super.parseQuotedTokensWithEqualChar(string);
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(2);
        String string = this.getTokenValue(0);
        if (!ReservedWordsList.rwExists(string)) {
            throw Directives.invalidDirectiveException("Directive %s: '%s' not a reserved word.", NAME, string);
        }
        String string2 = this.getTokenValue(1);
        if (!ReservedWordsList.rwExists(string2)) {
            throw Directives.invalidDirectiveException("Directive %s: '%s' not a reserved word.", NAME, string2);
        }
        this.rwMap.put(ReservedWordsList.normalize(string), ReservedWordsList.normalize(string2));
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        this.rwMap.putAll(((MAKESYN)baseDirective).rwMap);
        return true;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public HashMap<String, String> getRwMap() {
        return this.rwMap;
    }

    public MAKESYN(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 190;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

