/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.File;
import java.io.IOException;

public final class JLIST
extends BaseDirective {
    private static final String DEFAULT_EXT = ".jlst";
    public static final String NAME = "JLIST";
    private String destination;

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            this.destination = "";
            return;
        }
        this.checkParameterCount(1);
        this.destination = this.getTokenValue(0);
    }

    public String getOutput(File file) throws IOException {
        return this.getDestinationFileName(file, this.destination, DEFAULT_EXT);
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.No;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOJLIST");
    }

    public String getDestination() {
        return this.destination;
    }

    public JLIST(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 170;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

