/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.File;
import java.io.IOException;

public final class CLIST
extends BaseDirective {
    private static final String DEFAULT_EXT = ".clean";
    public static final String NAME = "CLIST";
    private String destination;

    @Override
    public void checkSetLegal(BaseDirective.Phase phase) throws InvalidDirectiveException {
        super.checkSetLegal(phase, this.getTokenCount() == 0 ? BaseDirective.Set.Any : BaseDirective.Set.No);
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo() || this.getTokenCount() == 0) {
            this.destination = "";
            return;
        }
        this.checkParameterCount(1);
        this.destination = this.getTokenValue(0);
    }

    public String getOutput(File file) throws IOException {
        return this.getDestinationFileName(file, this.destination, DEFAULT_EXT);
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        if (phase.compareTo(BaseDirective.Phase.AfterInit) >= 0) {
            this.isNo = baseDirective.isNo();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOCLIST");
    }

    public String getDestination() {
        return this.destination;
    }

    public CLIST(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 44;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

