/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class ALIGN
extends BaseDirective {
    public static final String NAME = "ALIGN";
    private int value;
    private AlignOptions alignOption;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkMaxParams(1);
        String[] stringArray = this.getTokenValue(0).split(" +");
        if (stringArray.length != 2) {
            throw Directives.invalidDirectiveException("Directive %s: %s", NAME, "'n FIXED|OPT' expected.");
        }
        this.value = this.getTokenIntegerValue(stringArray[0], 1, 255);
        this.alignOption = this.getEnumValue(stringArray[1], true, AlignOptions.class);
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("ALIGN\"8 OPT\"");
    }

    public int getValue() {
        return this.value;
    }

    public AlignOptions getAlignOption() {
        return this.alignOption;
    }

    public ALIGN(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 10;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static enum AlignOptions {
        Opt,
        Fixed;

    }
}

