/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstDataItemReference;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSymbol;
import com.veryant.cobol.compiler.ast.common.AstAdvancing;
import com.veryant.cobol.compiler.ast.common.AstAfterPositioning;
import com.veryant.cobol.compiler.ast.common.AstAtEnd;
import com.veryant.cobol.compiler.ast.common.AstFrom;
import com.veryant.cobol.compiler.ast.common.AstInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstMnemonicName;
import com.veryant.cobol.compiler.ast.common.AstNotAtEnd;
import com.veryant.cobol.compiler.ast.common.AstNotInvalidKey;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.stmts.Write;
import com.veryant.cobol.compiler.types.DataItemReference;

public class AstWriteStatement
extends AstAbstractFileIOStatement {
    private DataItemReference record = null;

    public AstWriteStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstDataItemReference astDataItemReference = (AstDataItemReference)this.getChild(0);
        if (astDataItemReference.isConditionName()) {
            this.consoleWrite(73, astDataItemReference.getToken(), new Object[0]);
            return;
        }
        DataItemReference dataItemReference = (DataItemReference)astDataItemReference.getOperand();
        if (dataItemReference.getDataItem() instanceof RecordItem) {
            this.record = dataItemReference;
            FileDeclaration fileDeclaration = ((RecordItem)this.record.getDataItem()).getFile();
            if (!fileDeclaration.getIsSelectMissing()) {
                FileDeclaration.Organization organization = fileDeclaration.getOrganization();
                AstAdvancing astAdvancing = this.findChild(AstAdvancing.class);
                if (astAdvancing != null) {
                    if (!(organization == FileDeclaration.Organization.LineSequential || this.getContext().isMFSet() && organization == FileDeclaration.Organization.RecordSequential)) {
                        this.consoleWrite(72, astAdvancing.getToken(), fileDeclaration.getOrganization().getDescription());
                    }
                } else {
                    AstAfterPositioning astAfterPositioning = this.findChild(AstAfterPositioning.class);
                    if (astAfterPositioning != null && organization != FileDeclaration.Organization.RecordSequential) {
                        this.consoleWrite(72, astAfterPositioning.getToken(), fileDeclaration.getOrganization().getDescription());
                    }
                }
            }
        } else {
            this.consoleWrite(73, this.getToken(), new Object[0]);
        }
    }

    @Override
    public void walk() {
        Write write = new Write(this.getToken());
        write.getData().setRecord(this.record);
        write.getData().setFile(((RecordItem)this.record.getDataItem()).getFile());
        for (AstNode astNode : this.getChildren()) {
            if (astNode instanceof AstFrom) {
                this.getCode().addStatement(new Move(this.getToken(), astNode.getChildOperand(0), this.record));
                continue;
            }
            if (astNode instanceof AstAfterPositioning) {
                write.getData().setAfterPositioning(astNode.getChildOperand(0));
                continue;
            }
            if (astNode instanceof AstAdvancing) {
                switch (astNode.getToken().kind) {
                    case 66: {
                        write.getData().setAdvancingPosition(Write.AdvancingPosition.Before);
                        break;
                    }
                    case 16: {
                        write.getData().setAdvancingPosition(Write.AdvancingPosition.After);
                    }
                }
                for (AstNode astNode2 : astNode.getChildren()) {
                    if (astNode instanceof AstMnemonicName) {
                        switch (this.getScope().normalize(astNode.getToken().image)) {
                            case "FORMFEED": {
                                write.getData().setAdvancingUnit(Write.AdvancingUnit.Formfeed);
                                break;
                            }
                            case "TAB": {
                                write.getData().setAdvancingUnit(Write.AdvancingUnit.Tab);
                            }
                        }
                        continue;
                    }
                    if (astNode instanceof AstSymbol) {
                        switch (astNode.getToken().kind) {
                            case 530: {
                                write.getData().setAdvancingUnit(Write.AdvancingUnit.Page);
                            }
                        }
                        continue;
                    }
                    write.getData().setAdvancingLines(astNode.getChildOperand(0));
                }
                continue;
            }
            if (astNode instanceof AstNotAtEnd) {
                write.getData().setSuccessBody(this.walkAsBranch(astNode));
                continue;
            }
            if (astNode instanceof AstAtEnd) {
                write.getData().setFailBody(this.walkAsBranch(astNode));
                continue;
            }
            if (astNode instanceof AstNotInvalidKey) {
                write.getData().setSuccessBody(this.walkAsBranch(astNode));
                continue;
            }
            if (!(astNode instanceof AstInvalidKey)) continue;
            write.getData().setFailBody(this.walkAsBranch(astNode));
        }
        this.getCode().addStatement(write);
    }
}

