/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.ast.AstAbstractDataItemReference;
import com.veryant.cobol.compiler.ast.AstDataName;
import com.veryant.cobol.compiler.ast.AstLazyDataItemReference;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.ast.AstSimpleDataItemReference;
import com.veryant.cobol.compiler.ast.AstUnsignedInteger;
import com.veryant.cobol.compiler.ast.common.AstAccessMode;
import com.veryant.cobol.compiler.ast.common.AstAssign;
import com.veryant.cobol.compiler.ast.common.AstDuplicates;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.common.AstFileStatus;
import com.veryant.cobol.compiler.ast.common.AstKey;
import com.veryant.cobol.compiler.ast.common.AstKeyAlternate;
import com.veryant.cobol.compiler.ast.common.AstLockMode;
import com.veryant.cobol.compiler.ast.common.AstOptional;
import com.veryant.cobol.compiler.ast.common.AstOrganization;
import com.veryant.cobol.compiler.ast.common.AstPadding;
import com.veryant.cobol.compiler.ast.common.AstRecordDelimiter;
import com.veryant.cobol.compiler.ast.common.AstReserve;
import com.veryant.cobol.compiler.ast.common.AstSharing;
import com.veryant.cobol.compiler.ast.common.AstSplitKey;
import com.veryant.cobol.compiler.ast.common.AstSuppress;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.scope.SplitKeyDeclaration;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;
import java.util.ArrayList;

public class AstSelectStatement
extends AstNode {
    private FileDeclaration file;

    public FileDeclaration getFile() {
        return this.file;
    }

    public AstSelectStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        boolean bl = false;
        Collector collector = this.getCollector();
        Context context = collector.getContext();
        FileDeclaration.Organization organization = null;
        int n = 0;
        FileDeclaration.Optional optional = null;
        block54: for (AstNode astNode : this.getChildren()) {
            AstDataName astDataName;
            Object t;
            Token token;
            if (astNode instanceof AstOptional) {
                token = ((AstNode)astNode.getChild(0)).getToken();
                switch (token.kind) {
                    case 491: {
                        optional = FileDeclaration.Optional.NotOptional;
                        continue block54;
                    }
                    case 517: {
                        optional = FileDeclaration.Optional.Optional;
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (astNode instanceof AstFileReference) {
                this.file = ((AstFileReference)astNode).getFile();
                if (this.file.getIsSelectDuplicate()) {
                    throw AstSelectStatement.userNameNotUniqueException(astNode.getToken());
                }
                this.file.setOptional(optional);
                continue;
            }
            if (astNode instanceof AstAssign) {
                int n2 = 0;
                t = astNode.getChild(n2);
                if (((AstNode)t).getToken() != null) {
                    n = ((AstNode)t).getToken().kind;
                    switch (n) {
                        case 323: {
                            this.file.getAssign().setExternal(true);
                            ++n2;
                            break;
                        }
                        case 245: {
                            this.file.getAssign().setDynamic(true);
                            ++n2;
                        }
                    }
                }
                if (((AstNode)(t = astNode.getChild(n2))).getToken() == null) continue;
                n = ((AstNode)t).getToken().kind;
                switch (n) {
                    case 443: 
                    case 550: 
                    case 552: 
                    case 553: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Print);
                        ++n2;
                        break;
                    }
                    case 594: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.MultipleReel);
                        ++n2;
                        break;
                    }
                    case 773: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.MultipleUnit);
                        ++n2;
                        break;
                    }
                    case 427: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Keyboard);
                        ++n2;
                        break;
                    }
                    case 236: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Display);
                        ++n2;
                        break;
                    }
                    case 232: 
                    case 234: 
                    case 353: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Disk);
                        ++n2;
                        break;
                    }
                    case 460: 
                    case 679: 
                    case 683: 
                    case 690: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Sort);
                        ++n2;
                        break;
                    }
                    case 398: 
                    case 399: 
                    case 524: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.IO);
                        ++n2;
                        break;
                    }
                    case 579: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Random);
                        ++n2;
                        break;
                    }
                    case 11: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Address);
                        ++n2;
                        break;
                    }
                    default: {
                        this.file.getAssign().setDevice(FileDeclaration.Device.Other);
                        ++n2;
                    }
                }
                continue;
            }
            if (astNode instanceof AstReserve) {
                t = astNode.getChild(0);
                if (((AstNode)t).getToken().kind == 485) {
                    this.file.setReserveAreas(0);
                    continue;
                }
                this.file.setReserveAreas(((AstUnsignedInteger)t).getValue());
                continue;
            }
            if (astNode instanceof AstKey) {
                bl = true;
                token = astNode.getToken();
                switch (token.kind) {
                    case 586: {
                        organization = FileDeclaration.Organization.Indexed;
                        continue block54;
                    }
                    case 598: {
                        organization = FileDeclaration.Organization.Relative;
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (astNode instanceof AstKeyAlternate) {
                token = astNode.getToken();
                switch (token.kind) {
                    case 29: {
                        organization = FileDeclaration.Organization.Indexed;
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (astNode instanceof AstOrganization) {
                token = astNode.getToken();
                switch (token.kind) {
                    case 69: {
                        this.setOrganization(astNode, FileDeclaration.Organization.BinarySequential);
                        continue block54;
                    }
                    case 586: {
                        this.setOrganization(astNode, FileDeclaration.Organization.RecordSequential);
                        continue block54;
                    }
                    case 443: {
                        this.setOrganization(astNode, FileDeclaration.Organization.LineSequential);
                        continue block54;
                    }
                    case 663: {
                        this.setOrganization(astNode, FileDeclaration.Organization.Sequential);
                        continue block54;
                    }
                    case 598: {
                        this.setOrganization(astNode, FileDeclaration.Organization.Relative);
                        continue block54;
                    }
                    case 385: {
                        this.setOrganization(astNode, FileDeclaration.Organization.Indexed);
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (astNode instanceof AstAccessMode) {
                token = astNode.getToken();
                switch (token.kind) {
                    case 663: {
                        this.setAccessMode(astNode, FileDeclaration.AccessMode.Sequential);
                        continue block54;
                    }
                    case 579: {
                        this.setAccessMode(astNode, FileDeclaration.AccessMode.Random);
                        continue block54;
                    }
                    case 245: {
                        this.setAccessMode(astNode, FileDeclaration.AccessMode.Dynamic);
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (astNode instanceof AstLockMode) {
                Object t2 = astNode.getChild(0);
                token = ((AstNode)t2).getToken();
                switch (token.kind) {
                    case 457: {
                        this.file.setLockMode(FileDeclaration.LockMode.Manual);
                        break;
                    }
                    case 48: {
                        this.file.setLockMode(FileDeclaration.LockMode.Automatic);
                        break;
                    }
                    case 313: {
                        this.file.setLockMode(FileDeclaration.LockMode.Exclusive);
                        break;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
                if (((AstNode)t2).getChildrenCount() <= 0) continue;
                token = ((AstNode)((AstNode)t2).getChild(0)).getToken();
                switch (token.kind) {
                    case 586: {
                        break;
                    }
                    case 471: 
                    case 589: {
                        this.file.setMultipleRecordLock(true);
                        break;
                    }
                    case 634: {
                        this.file.setWithRollback(true);
                        break;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
                continue;
            }
            if (astNode instanceof AstPadding) {
                this.file.setPaddingCharacter(((AstOperand)astNode.getChild(0)).getOperand());
                continue;
            }
            if (astNode instanceof AstRecordDelimiter) {
                Object t3 = astNode.getChild(0);
                if (t3 instanceof AstOperand) {
                    this.file.setRecordDelimiter(((AstOperand)t3).getOperand());
                    continue;
                }
                if (((AstNode)t3).getToken().kind == 699) {
                    this.file.setStandardRecordDelimiter(true);
                    continue;
                }
                throw AstSelectStatement.unexpectedTokenException(((AstNode)t3).getToken());
            }
            if (astNode instanceof AstSharing) {
                token = ((AstNode)astNode.getChild(0)).getToken();
                switch (token.kind) {
                    case 18: {
                        this.file.setSharingMode(FileDeclaration.SharingMode.WithAllOthers);
                        continue block54;
                    }
                    case 485: {
                        this.file.setSharingMode(FileDeclaration.SharingMode.WithNoOther);
                        continue block54;
                    }
                    default: {
                        throw AstSelectStatement.unexpectedTokenException(token);
                    }
                }
            }
            if (!(astNode instanceof AstKey) && !(astNode instanceof AstKeyAlternate) || (astDataName = this.tryGetSplitKeyNameFromNode(astNode)) == null || this.file.storeSplitKey(this.getScope().normalize(astDataName.getDataName()))) continue;
            this.consoleWrite(42, astDataName.getToken(), astDataName.getDataName());
        }
        if (this.file.getOrganization() == null) {
            this.file.setOrganization(FileDeclaration.Organization.Sequential);
        }
        if (organization != null && this.file.getOrganization() != organization) {
            this.consoleWrite(35, this.getToken(), new Object[0]);
        }
        if (!bl && this.file.getOrganization() == FileDeclaration.Organization.Indexed) {
            this.consoleWrite(35, this.getToken(), new Object[0]);
        }
        if (this.file.getAccessMode() == null) {
            this.file.setAccessMode(FileDeclaration.AccessMode.Sequential);
        }
        if (!this.file.checkOrganizationAccessKeyCombination()) {
            this.consoleWrite(35, this.getToken(), new Object[0]);
        }
    }

    private void setAccessMode(AstNode astNode, FileDeclaration.AccessMode accessMode) {
        if (this.file.getAccessMode() == null) {
            this.file.setAccessMode(accessMode);
        } else if (this.file.getAccessMode() != accessMode) {
            this.consoleWrite(35, astNode.getToken(), new Object[0]);
        }
    }

    private void setOrganization(AstNode astNode, FileDeclaration.Organization organization) {
        if (this.file.getOrganization() == FileDeclaration.Organization.Undefined) {
            this.file.setOrganization(organization);
        } else if (this.file.getOrganization() != organization) {
            this.consoleWrite(35, astNode.getToken(), new Object[0]);
        }
    }

    public void validateAfterDataDivision() {
        for (AstNode astNode : this.getChildren()) {
            AstOperand astOperand;
            ArrayList<AbstractOperand> arrayList;
            if (astNode instanceof AstAssign) {
                arrayList = new ArrayList<AbstractOperand>();
                for (AstNode astNode2 : astNode.getChildren()) {
                    if (!(astNode2 instanceof AstOperand)) continue;
                    astOperand = (AstOperand)astNode2;
                    if (this.file.getFileName() == null) {
                        this.file.setFileName(astOperand.getOperand());
                    }
                    arrayList.add(astOperand.getOperand());
                }
                this.file.getAssign().setTargets(arrayList.toArray(new IOperand[arrayList.size()]));
                continue;
            }
            if (astNode instanceof AstKey) {
                this.file.addPrimeKey(this.getKeyFromNode(astNode));
                continue;
            }
            if (astNode instanceof AstKeyAlternate) {
                this.file.addKey(this.getKeyFromNode(astNode));
                continue;
            }
            if (!(astNode instanceof AstFileStatus)) continue;
            arrayList = new ArrayList();
            for (AstNode astNode2 : astNode.getChildren()) {
                if (!(astNode2 instanceof AstLazyDataItemReference)) continue;
                astOperand = (AstLazyDataItemReference)astNode2;
                if (((AstAbstractDataItemReference)astOperand).isConditionName()) {
                    this.consoleWrite(74, ((AstNode)astNode2.getChild(0)).getToken(), ((AstAbstractDataItemReference)astOperand).getOperand());
                    continue;
                }
                DataItemReference dataItemReference = (DataItemReference)((AstAbstractDataItemReference)astOperand).getOperand();
                if (dataItemReference == null) continue;
                if (dataItemReference.getStaticSize() != 2) {
                    this.consoleWrite(74, ((AstNode)astNode2.getChild(0)).getToken(), dataItemReference.getDataItem().getName());
                }
                arrayList.add(dataItemReference);
            }
            this.file.setFileStatuses(arrayList.toArray(new DataItemReference[arrayList.size()]));
        }
    }

    private AstDataName tryGetSplitKeyNameFromNode(AstNode astNode) {
        AstSplitKey astSplitKey = astNode.getUniqueChild(AstSplitKey.class);
        if (astSplitKey != null) {
            return astNode.findChild(AstSimpleDataItemReference.class).getAstDataName();
        }
        return null;
    }

    private FileDeclaration.Key getKeyFromNode(AstNode astNode) {
        FileDeclaration.Key key;
        boolean bl = false;
        AstSplitKey astSplitKey = astNode.getUniqueChild(AstSplitKey.class);
        if (astSplitKey != null) {
            key = this.file.createSplitKey(astNode.findChild(AstSimpleDataItemReference.class).getAstDataName().getDataName(), astSplitKey.getSegments());
            this.getScope().add(new SplitKeyDeclaration((ISourceReference)this.getToken(), key));
        } else {
            AstAbstractDataItemReference astAbstractDataItemReference = (AstAbstractDataItemReference)astNode.getChild(0);
            key = this.file.createKey((DataItemReference)astAbstractDataItemReference.getOperand());
        }
        if (key != null) {
            this.setKeyOptions(key, astNode);
        }
        return key;
    }

    private void setKeyOptions(FileDeclaration.Key key, AstNode astNode) {
        for (AstNode astNode2 : astNode.getChildren()) {
            Token token = astNode2.getToken();
            if (token.kind == 535) {
                key.setPassword(((AstOperand)astNode2.getChild(0)).getOperand());
                continue;
            }
            if (astNode2 instanceof AstDuplicates) {
                key.setWithDuplicates(astNode2.getToken().kind == 244);
                continue;
            }
            if (!(astNode2 instanceof AstSuppress)) continue;
            astNode2 = astNode2.getChild(0);
            token = astNode2.getToken();
            if (token.kind == 835 || token.kind == 834) {
                key.setSuppress(FileDeclaration.Suppress.Zeroes);
                continue;
            }
            if (token.kind == 696) {
                key.setSuppress(FileDeclaration.Suppress.Spaces);
                continue;
            }
            key.setSuppress(FileDeclaration.Suppress.Literal);
            AstOperand astOperand = (AstOperand)astNode2;
            key.setSuppressLiteral(astOperand.getOperand());
        }
    }
}

