/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.DataUsage;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.ast.AstDataLevel;
import com.veryant.cobol.compiler.ast.AstDataName;
import com.veryant.cobol.compiler.ast.AstDataOccurs;
import com.veryant.cobol.compiler.ast.AstDataOccursIndexes;
import com.veryant.cobol.compiler.ast.AstDataRedefines;
import com.veryant.cobol.compiler.ast.AstDataRenames;
import com.veryant.cobol.compiler.ast.AstDataSign;
import com.veryant.cobol.compiler.ast.AstDataUsage;
import com.veryant.cobol.compiler.ast.AstFileDescription;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstPicture;
import com.veryant.cobol.compiler.ast.common.AstValue;
import com.veryant.cobol.compiler.directives.COMP1;
import com.veryant.cobol.compiler.directives.COMP2;
import com.veryant.cobol.compiler.directives.SIGN;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.NamedConditionDeclaration;
import com.veryant.cobol.compiler.scope.NamedConstantDeclaration;
import com.veryant.cobol.compiler.types.AbstractLiteral;
import com.veryant.cobol.converters.PackedDecimal;

public class AstDataDescriptionEntry
extends AstNode {
    private String name;
    private BuiltIn builtIn;
    private Magnitude magnitude;
    private Literal mask;
    private int size;
    private int level;

    public boolean denyPromotionByDefault() {
        AstPicture astPicture = this.getUniqueChild(AstPicture.class);
        if (astPicture != null) {
            return astPicture.isEditedPicture();
        }
        return false;
    }

    public AstDataRedefines getRedefines() {
        return this.getUniqueChild(AstDataRedefines.class);
    }

    public AstDataRenames getRenames() {
        return this.getUniqueChild(AstDataRenames.class);
    }

    private int getSizeMultiplier() {
        AstDataOccurs astDataOccurs = this.getUniqueChild(AstDataOccurs.class);
        if (astDataOccurs != null) {
            return astDataOccurs.getTimes();
        }
        return 0;
    }

    private int getSize() {
        if (this.builtIn == null) {
            return 0;
        }
        switch (this.builtIn) {
            case LEADING_SEP: 
            case TRAILING_SEP: 
            case LEADING_SEP_EBCDIC: 
            case TRAILING_SEP_EBCDIC: {
                return this.size + 1;
            }
        }
        return this.size;
    }

    public AstDataDescriptionEntry(Collector collector, Token token) {
        super(collector, token);
    }

    private static DataUsage safeGetUsage(AstDataUsage astDataUsage) {
        return astDataUsage == null ? DataUsage.DISPLAY : astDataUsage.getDataUsage();
    }

    private boolean isPictureRejected(AstDataUsage astDataUsage) {
        switch (AstDataDescriptionEntry.safeGetUsage(astDataUsage)) {
            case COMP_2: {
                if (this.getContext().getCOMP2().getType() == COMP2.Comp2Type.Decimal) {
                    return false;
                }
            }
            case INDEX: 
            case POINTER: 
            case POINTER_32: 
            case COMP_1: 
            case STRING: 
            case OBJECT: 
            case CONDITION_VALUE: 
            case BINARY_CHAR_SIGNED: 
            case BINARY_CHAR_UNSIGNED: 
            case BINARY_DOUBLE_SIGNED: 
            case BINARY_DOUBLE_UNSIGNED: 
            case BINARY_SHORT_SIGNED: 
            case BINARY_SHORT_UNSIGNED: 
            case BINARY_LONG_SIGNED: 
            case BINARY_LONG_UNSIGNED: 
            case FLOAT_SHORT: 
            case FLOAT_LONG: 
            case CHARACTER: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    private void apply(AstDataUsage astDataUsage) {
        boolean bl = false;
        switch (AstDataDescriptionEntry.safeGetUsage(astDataUsage)) {
            case DISPLAY: {
                this.builtIn = this.getContext().isAscii() ? BuiltIn.ALPHA_NUM : BuiltIn.ALPHA_NUM_EBCDIC;
                break;
            }
            case NATIONAL: {
                this.builtIn = BuiltIn.NATIONAL;
                break;
            }
            case BINARY_CHAR_SIGNED: {
                this.builtIn = BuiltIn.COMP_5_SIGNED;
                this.size = BuiltIn.getSizeByDigits(2, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(true, 2);
                break;
            }
            case BINARY_CHAR_UNSIGNED: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = BuiltIn.getSizeByDigits(2, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(false, 2);
                break;
            }
            case INDEX: 
            case BINARY_SHORT_SIGNED: {
                this.builtIn = BuiltIn.COMP_5_SIGNED;
                this.size = BuiltIn.getSizeByDigits(4, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(true, 4);
                break;
            }
            case BINARY_SHORT_UNSIGNED: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = BuiltIn.getSizeByDigits(4, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(false, 4);
                break;
            }
            case BINARY_LONG_SIGNED: {
                this.builtIn = BuiltIn.COMP_5_SIGNED;
                this.size = BuiltIn.getSizeByDigits(9, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(true, 9);
                break;
            }
            case POINTER_32: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = 4;
                this.magnitude = new Magnitude(false, 9);
                break;
            }
            case POINTER: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = 8;
                this.magnitude = new Magnitude(false, 18);
                break;
            }
            case BINARY_LONG_UNSIGNED: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = BuiltIn.getSizeByDigits(9, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(false, 9);
                break;
            }
            case BINARY_DOUBLE_SIGNED: {
                this.builtIn = BuiltIn.COMP_5_SIGNED;
                this.size = BuiltIn.getSizeByDigits(18, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(true, 18);
                break;
            }
            case BINARY_DOUBLE_UNSIGNED: {
                this.builtIn = BuiltIn.COMP_5_UNSIGNED;
                this.size = BuiltIn.getSizeByDigits(18, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(false, 18);
                break;
            }
            case COMP_1: {
                if (this.getContext().getCOMP1().getType() == COMP1.Comp1Type.Binary) {
                    this.builtIn = BuiltIn.COMP_X_SIGNED;
                    this.size = BuiltIn.getSizeByDigits(4);
                    this.magnitude = new Magnitude(true, 4);
                    break;
                }
            }
            case FLOAT_SHORT: {
                bl = true;
                break;
            }
            case COMP_2: 
            case FLOAT_LONG: {
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            this.consoleWrite(13, astDataUsage.getToken(), new Object[0]);
            this.builtIn = this.getContext().isAscii() ? BuiltIn.ALPHA_NUM : BuiltIn.ALPHA_NUM_EBCDIC;
        }
    }

    private void apply(AstDataUsage astDataUsage, AstPicture astPicture) {
        DataUsage dataUsage = AstDataDescriptionEntry.safeGetUsage(astDataUsage);
        int n = astPicture.getType();
        block0 : switch (dataUsage) {
            case NATIONAL: {
                if (n != 32) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                }
                dataUsage = DataUsage.DISPLAY;
                break;
            }
            case BIT: {
                if (n != 128) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                }
                dataUsage = DataUsage.DISPLAY;
                break;
            }
            case COMP: {
                switch (this.getContext().getCOMP().getOption()) {
                    case Binary: {
                        dataUsage = DataUsage.COMP_4;
                        break block0;
                    }
                    case Display: {
                        dataUsage = DataUsage.DISPLAY;
                        break block0;
                    }
                    case Packed: {
                        dataUsage = DataUsage.COMP_3;
                        break block0;
                    }
                    case Unpacked: {
                        dataUsage = DataUsage.COMP_2;
                    }
                }
            }
        }
        boolean bl = astPicture.isSigned();
        int n2 = astPicture.getDigits();
        int n3 = astPicture.getScale();
        block11 : switch (dataUsage) {
            case COMP_2: {
                if (n != 1) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                }
                if (bl) {
                    this.builtIn = BuiltIn.COMP_2_SIGNED_DECIMAL;
                    this.size = n2 + 1;
                } else {
                    this.builtIn = BuiltIn.COMP_2_UNSIGNED_DECIMAL;
                    this.size = n2;
                }
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case COMP_3: {
                if (n != 1) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                }
                this.builtIn = bl ? BuiltIn.COMP_3_SIGNED : BuiltIn.COMP_3_UNSIGNED;
                this.size = PackedDecimal.digitsToBytes(n2);
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case COMP_4: {
                if (n != 1) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                }
                this.builtIn = bl ? BuiltIn.COMP_4_SIGNED : (this.getContext().getCOMP().isNo() ? BuiltIn.COMP_4_UNSIGNED_SIGN_DROP : BuiltIn.COMP_4_UNSIGNED);
                this.size = BuiltIn.getSizeByDigits(n2, this.getContext().getIBMCOMP().isSet());
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case COMP_5: {
                if (n != 1 && n != 8 && n != 4) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                }
                switch (this.getContext().getCOMP5().getInteger()) {
                    case 1: {
                        this.builtIn = bl ? BuiltIn.COMP_5_SIGNED : BuiltIn.COMP_5_UNSIGNED_SIGN_DROP;
                        break;
                    }
                    default: {
                        BuiltIn builtIn = this.builtIn = bl ? BuiltIn.COMP_5_SIGNED : BuiltIn.COMP_5_UNSIGNED;
                    }
                }
                if (n == 1) {
                    this.size = BuiltIn.getSizeByDigits(n2, this.getContext().getIBMCOMP().isSet());
                } else {
                    this.size = astPicture.getSize();
                    if (this.size > 16) {
                        this.consoleWrite(16, astPicture.getToken(), new Object[0]);
                        this.size = 16;
                    }
                    n2 = BuiltIn.getDigitsBySize(this.size);
                }
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case COMP_X: {
                if (n != 1 && n != 8 && n != 4) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                } else if (bl) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                }
                this.builtIn = BuiltIn.COMP_X_UNSIGNED;
                if (n == 1) {
                    this.size = BuiltIn.getSizeByDigits(n2);
                } else {
                    this.size = astPicture.getSize();
                    if (this.size > 16) {
                        this.consoleWrite(16, astPicture.getToken(), new Object[0]);
                        this.size = 16;
                    }
                    n2 = BuiltIn.getDigitsBySize(this.size);
                }
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case COMP_6: {
                if (n != 1) {
                    this.consoleWrite(59, astPicture.getToken(), new Object[0]);
                    bl = false;
                    n2 = 1;
                    n3 = 0;
                }
                switch (this.getContext().getCOMP6().getInteger()) {
                    case 1: {
                        this.builtIn = BuiltIn.COMP_4_UNSIGNED_SIGN_DROP;
                        this.size = BuiltIn.getSizeByDigits(n2);
                        this.magnitude = new Magnitude(bl, n2, n3);
                        break block11;
                    }
                    case 3: {
                        this.builtIn = BuiltIn.COMP_6;
                        this.size = PackedDecimal.digitsToBytesNoSign(n2);
                        this.magnitude = new Magnitude(bl, n2, n3);
                        break block11;
                    }
                }
                if (bl) {
                    this.builtIn = BuiltIn.COMP_3_SIGNED;
                    this.size = PackedDecimal.digitsToBytes(n2);
                } else {
                    this.builtIn = BuiltIn.COMP_6;
                    this.size = PackedDecimal.digitsToBytesNoSign(n2);
                }
                this.magnitude = new Magnitude(bl, n2, n3);
                break;
            }
            case DISPLAY: {
                this.size = astPicture.getSize();
                switch (n) {
                    case 1: {
                        this.builtIn = bl ? (this.getContext().isAscii() ? BuiltIn.TRAILING : BuiltIn.TRAILING_EBCDIC) : (this.getContext().isAscii() ? BuiltIn.UNSIGNED : BuiltIn.UNSIGNED_EBCDIC);
                        this.magnitude = new Magnitude(bl, n2, n3);
                        break;
                    }
                    case 4: {
                        this.builtIn = this.getContext().isAscii() ? BuiltIn.ALPHA : BuiltIn.ALPHA_EBCDIC;
                        this.magnitude = null;
                        break;
                    }
                    case 2: {
                        this.mask = new Literal(this.getContext().getCodepage(), astPicture.getEditMask());
                        this.getContext().getLiterals().add(this.mask);
                        this.builtIn = this.getContext().isAscii() ? BuiltIn.EDT_NUM_ASCII : BuiltIn.EDT_NUM_EBCDIC;
                        this.magnitude = new Magnitude(bl, n2, n3);
                        break;
                    }
                    case 16: 
                    case 32: 
                    case 64: 
                    case 128: {
                        this.consoleWrite(87, astPicture.getToken(), new Object[0]);
                    }
                    case 0: 
                    case 8: {
                        this.builtIn = this.getContext().isAscii() ? BuiltIn.ALPHA_NUM : BuiltIn.ALPHA_NUM_EBCDIC;
                        this.magnitude = null;
                    }
                }
                break;
            }
            default: {
                this.consoleWrite(13, astDataUsage.getToken(), new Object[0]);
            }
        }
    }

    @Override
    public void validate() {
        this.level = this.getUniqueChild(AstDataLevel.class).getValue();
        AstDataName astDataName = this.getUniqueChild(AstDataName.class);
        if (astDataName != null) {
            this.name = astDataName.getDataName();
        }
        if (this.level == 78) {
            AbstractLiteral abstractLiteral = this.getUniqueChild(AstValue.class).getValue();
            if (abstractLiteral != null) {
                NamedConstantDeclaration namedConstantDeclaration = new NamedConstantDeclaration(this.getToken(), this.name, abstractLiteral);
                if (!this.getScope().add(namedConstantDeclaration)) {
                    this.consoleWrite(62, namedConstantDeclaration, namedConstantDeclaration.getName());
                }
            }
            return;
        }
        AstDataUsage astDataUsage = this.getUniqueChild(AstDataUsage.class);
        AstPicture astPicture = this.getUniqueChild(AstPicture.class);
        if (astPicture != null) {
            if (this.isPictureRejected(astDataUsage)) {
                this.consoleWrite(40, astPicture.getToken(), new Object[0]);
                this.apply(astDataUsage);
            } else {
                this.apply(astDataUsage, astPicture);
            }
        } else {
            this.apply(astDataUsage);
        }
        SIGN.StorageConventions storageConventions = this.getContext().getSIGN().getStorageConvention();
        SIGN.SignModes signModes = this.getContext().getSIGN().getDefaultSignMode();
        AstDataSign astDataSign = this.getUniqueChild(AstDataSign.class);
        if (astDataSign != null) {
            switch (this.builtIn) {
                case TRAILING: 
                case TRAILING_EBCDIC: {
                    if (astDataSign.isLeding()) {
                        signModes = astDataSign.isSeparate() ? SIGN.SignModes.LeadingSeparate : SIGN.SignModes.Leading;
                        break;
                    }
                    signModes = astDataSign.isSeparate() ? SIGN.SignModes.TrailingSeparate : SIGN.SignModes.Trailing;
                    break;
                }
                default: {
                    this.consoleWrite(40, astDataSign.getToken(), new Object[0]);
                }
            }
        }
        block3 : switch (this.builtIn) {
            case COMP_3_SIGNED: {
                switch (storageConventions) {
                    case Acu: {
                        this.builtIn = BuiltIn.COMP_3_SIGNED_ACU;
                        break;
                    }
                    case NCR: {
                        this.builtIn = BuiltIn.COMP_3_SIGNED_NCR;
                    }
                }
                break;
            }
            case COMP_3_UNSIGNED: {
                if (storageConventions != SIGN.StorageConventions.Vax) break;
                this.builtIn = BuiltIn.COMP_3_UNSIGNED_VAX;
                break;
            }
            case COMP_2_SIGNED_DECIMAL: {
                if (storageConventions != SIGN.StorageConventions.Acu) break;
                this.builtIn = BuiltIn.COMP_2_SIGNED_DECIMAL_ACU;
                break;
            }
            case TRAILING: {
                switch (signModes) {
                    case Included: 
                    case Trailing: {
                        switch (storageConventions) {
                            case NCR: 
                            case IBM: 
                            case Vax: 
                            case EBCDIC: {
                                this.builtIn = BuiltIn.TRAILING_SIGN_EBCDIC;
                                break;
                            }
                            case Acu: {
                                this.builtIn = BuiltIn.TRAILING_ACU;
                                break;
                            }
                            case MBP: {
                                this.builtIn = BuiltIn.TRAILING_MBP;
                                break;
                            }
                            case Realia: {
                                this.builtIn = BuiltIn.TRAILING_REA;
                            }
                        }
                        break;
                    }
                    case Separate: 
                    case TrailingSeparate: {
                        this.builtIn = BuiltIn.TRAILING_SEP;
                        break;
                    }
                    case Leading: {
                        this.builtIn = BuiltIn.LEADING;
                        switch (storageConventions) {
                            case NCR: 
                            case IBM: 
                            case Vax: 
                            case EBCDIC: {
                                this.builtIn = BuiltIn.LEADING_SIGN_EBCDIC;
                                break;
                            }
                            case Acu: {
                                this.builtIn = BuiltIn.LEADING_ACU;
                                break;
                            }
                            case MBP: {
                                this.builtIn = BuiltIn.LEADING_MBP;
                                break;
                            }
                            case Realia: {
                                this.builtIn = BuiltIn.LEADING_REA;
                            }
                        }
                        break;
                    }
                    case LeadingSeparate: {
                        this.builtIn = BuiltIn.LEADING_SEP;
                    }
                }
                break;
            }
            case TRAILING_EBCDIC: {
                switch (signModes) {
                    case Included: 
                    case Trailing: {
                        switch (storageConventions) {
                            case MF: 
                            case ASCII: {
                                this.builtIn = BuiltIn.TRAILING_EBCDIC_SIGN_ASCII;
                            }
                        }
                        break block3;
                    }
                    case Separate: 
                    case TrailingSeparate: {
                        this.builtIn = BuiltIn.TRAILING_SEP_EBCDIC;
                        break block3;
                    }
                    case Leading: {
                        this.builtIn = BuiltIn.LEADING_EBCDIC;
                        switch (storageConventions) {
                            case MF: 
                            case ASCII: {
                                this.builtIn = BuiltIn.LEADING_EBCDIC_SIGN_ASCII;
                            }
                        }
                        break block3;
                    }
                    case LeadingSeparate: {
                        this.builtIn = BuiltIn.LEADING_SEP_EBCDIC;
                    }
                }
            }
        }
    }

    public DataItemDeclaration toDataItemDeclaration() {
        AstDataOccursIndexes astDataOccursIndexes;
        AstDataOccurs astDataOccurs;
        DataItem dataItem = this.isRecordItem() ? new RecordItem(this.name, this.builtIn, this.magnitude, this.getSize(), this.getSizeMultiplier()) : new DataItem(this.name, this.builtIn, this.magnitude, this.getSize(), this.getSizeMultiplier());
        DataItemDeclaration dataItemDeclaration = new DataItemDeclaration((ISourceReference)this.getToken(), dataItem);
        dataItemDeclaration.setMask(this.mask);
        AstValue astValue = this.getUniqueChild(AstValue.class);
        if (astValue != null) {
            dataItemDeclaration.setValue(astValue.getValue());
        }
        if ((astDataOccurs = this.getUniqueChild(AstDataOccurs.class)) != null && (astDataOccursIndexes = astDataOccurs.getUniqueChild(AstDataOccursIndexes.class)) != null) {
            dataItemDeclaration.setIndexes(astDataOccursIndexes.getIndexes());
        }
        return dataItemDeclaration;
    }

    private boolean isRecordItem() {
        switch (this.getLevel()) {
            case 1: 
            case 77: {
                break;
            }
            default: {
                return false;
            }
        }
        return this.findParent(AstFileDescription.class) != null;
    }

    public NamedConditionDeclaration toNamedConditionDeclaration() {
        return new NamedConditionDeclaration(this.getToken(), this.name, this.getUniqueChild(AstValue.class).getValues());
    }

    @Override
    public String toString() {
        return "data-description-entry";
    }

    public Literal getMask() {
        return this.mask;
    }

    public int getLevel() {
        return this.level;
    }
}

