/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.DataCategory;
import com.veryant.cobol.compiler.DataUsage;
import com.veryant.cobol.compiler.IStaticCast;
import com.veryant.cobol.compiler.TruncConvention;
import com.veryant.cobol.converters.CHA;
import com.veryant.cobol.converters.CHE;
import com.veryant.cobol.converters.CMP2SACU;
import com.veryant.cobol.converters.CMP2SDEC;
import com.veryant.cobol.converters.CMP2UDEC;
import com.veryant.cobol.converters.CMP3S;
import com.veryant.cobol.converters.CMP3SACU;
import com.veryant.cobol.converters.CMP3SNCR;
import com.veryant.cobol.converters.CMP3U;
import com.veryant.cobol.converters.CMP3UVAX;
import com.veryant.cobol.converters.CMP5S;
import com.veryant.cobol.converters.CMP5U;
import com.veryant.cobol.converters.CMP6;
import com.veryant.cobol.converters.CMPXS;
import com.veryant.cobol.converters.CMPXU;
import com.veryant.cobol.converters.EDTNA;
import com.veryant.cobol.converters.EDTNE;
import com.veryant.cobol.converters.LA;
import com.veryant.cobol.converters.LACU;
import com.veryant.cobol.converters.LAE;
import com.veryant.cobol.converters.LE;
import com.veryant.cobol.converters.LEA;
import com.veryant.cobol.converters.LMBP;
import com.veryant.cobol.converters.LREA;
import com.veryant.cobol.converters.LSA;
import com.veryant.cobol.converters.LSE;
import com.veryant.cobol.converters.TA;
import com.veryant.cobol.converters.TACU;
import com.veryant.cobol.converters.TAE;
import com.veryant.cobol.converters.TE;
import com.veryant.cobol.converters.TEA;
import com.veryant.cobol.converters.TMBP;
import com.veryant.cobol.converters.TREA;
import com.veryant.cobol.converters.TSA;
import com.veryant.cobol.converters.TSE;
import com.veryant.cobol.converters.UA;
import com.veryant.cobol.converters.UE;

public enum BuiltIn {
    ALPHA("alphabetic", DataUsage.DISPLAY, DataCategory.ALPHABETIC, TruncConvention.YES, CHA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CHA.store(cobolBigDecimal, n2, magnitude.getScale(), iMemory, 0, n2)),
    ALPHA_EBCDIC("alphabetic", DataUsage.DISPLAY, DataCategory.ALPHABETIC, TruncConvention.YES, CHE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CHE.store(cobolBigDecimal, n2, magnitude.getScale(), iMemory, 0, n2)),
    ALPHA_NUM("alphanumeric", DataUsage.DISPLAY, DataCategory.ALPHANUMERIC, TruncConvention.YES, CHA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CHA.store(cobolBigDecimal, n2, magnitude.getScale(), iMemory, 0, n2)),
    ALPHA_NUM_EBCDIC("alphanumeric", DataUsage.DISPLAY, DataCategory.ALPHANUMERIC, TruncConvention.YES, CHE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CHE.store(cobolBigDecimal, n2, magnitude.getScale(), iMemory, 0, n2)),
    NATIONAL("national", DataUsage.DISPLAY, DataCategory.NATIONAL, TruncConvention.YES, CHA.class),
    UNSIGNED("numeric-unsigned", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, UA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> UA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    UNSIGNED_EBCDIC("numeric-unsigned", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, UE.class, UA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> UE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_EBCDIC("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LE.class, LA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_SIGN_EBCDIC("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LAE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LAE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_ACU("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LACU.class, LAE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LACU.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_EBCDIC_SIGN_ASCII("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LEA.class, LA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LEA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_MBP("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LMBP.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LMBP.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_REA("leading-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LREA.class, LA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LREA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_SEP("leading-separated", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LSA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LSA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    LEADING_SEP_EBCDIC("leading-separated", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, LSE.class, LSA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> LSE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_EBCDIC("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TE.class, TA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_SIGN_EBCDIC("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TAE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TAE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_ACU("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TACU.class, TAE.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TACU.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_EBCDIC_SIGN_ASCII("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TEA.class, TA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TEA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_MBP("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TMBP.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TMBP.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_REA("trailing-signed", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TREA.class, TA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TREA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_SEP("trailing-separated", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TSA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TSA.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    TRAILING_SEP_EBCDIC("trailing-separated", DataUsage.DISPLAY, DataCategory.NUMERIC, TruncConvention.YES, TSE.class, TSA.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> TSE.store(cobolBigDecimal, iMemory, n, n2, magnitude.getScale())),
    COMP_2_SIGNED_DECIMAL("comp-2", DataUsage.COMP_2, DataCategory.NUMERIC, TruncConvention.YES, CMP2SDEC.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP2SDEC.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_2_SIGNED_DECIMAL_ACU("comp-2", DataUsage.COMP_2, DataCategory.NUMERIC, TruncConvention.YES, CMP2SACU.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP2SACU.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_2_UNSIGNED_DECIMAL("comp-2", DataUsage.COMP_2, DataCategory.NUMERIC, TruncConvention.YES, CMP2UDEC.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP2UDEC.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_3_SIGNED("comp-3", DataUsage.COMP_3, DataCategory.NUMERIC, TruncConvention.YES, CMP3S.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP3S.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_3_SIGNED_NCR("comp-3", DataUsage.COMP_3, DataCategory.NUMERIC, TruncConvention.YES, CMP3SNCR.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP3SNCR.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_3_SIGNED_ACU("comp-3", DataUsage.COMP_3, DataCategory.NUMERIC, TruncConvention.YES, CMP3SACU.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP3SACU.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_3_UNSIGNED("comp-3", DataUsage.COMP_3, DataCategory.NUMERIC, TruncConvention.YES, CMP3U.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP3U.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_3_UNSIGNED_VAX("comp-3", DataUsage.COMP_3, DataCategory.NUMERIC, TruncConvention.YES, CMP3UVAX.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP3UVAX.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    COMP_4_SIGNED("comp-4", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.CONFIGURABLE, CMPXS.class),
    COMP_4_UNSIGNED("comp-4", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.CONFIGURABLE, CMPXS.class, CMPXU.class),
    COMP_4_UNSIGNED_SIGN_DROP("comp-4", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.CONFIGURABLE, CMPXU.class),
    COMP_5_SIGNED("comp-5", DataUsage.COMP_5, DataCategory.NUMERIC, TruncConvention.NO, CMP5S.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP5S.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_5_UNSIGNED("comp-5", DataUsage.COMP_5, DataCategory.NUMERIC, TruncConvention.NO, CMP5S.class, CMP5U.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP5S.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_5_UNSIGNED_SIGN_DROP("comp-5", DataUsage.COMP_5, DataCategory.NUMERIC, TruncConvention.NO, CMP5U.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP5U.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_X_SIGNED("comp-x", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.NO, CMPXS.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMPXS.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_X_UNSIGNED("comp-x", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.NO, CMPXS.class, CMPXU.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMPXS.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_X_UNSIGNED_SIGN_DROP("comp-x", DataUsage.COMP_X, DataCategory.NUMERIC, TruncConvention.NO, CMPXU.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMPXU.store(cobolBigDecimal, iMemory, n, n2, 0, magnitude.getScale())),
    COMP_6("comp-6", DataUsage.COMP_6, DataCategory.NUMERIC, TruncConvention.YES, CMP6.class, (cobolBigDecimal, iMemory, n, n2, magnitude) -> CMP6.store(cobolBigDecimal, iMemory, n, magnitude.getDigits(), magnitude.getScale())),
    EDT_NUM_ASCII("numeric-edited", DataUsage.DISPLAY, DataCategory.NUMERIC_EDITED, TruncConvention.YES, EDTNA.class),
    EDT_NUM_EBCDIC("numeric-edited", DataUsage.DISPLAY, DataCategory.NUMERIC_EDITED, TruncConvention.YES, EDTNE.class),
    BOOLEAN_LITERAL("boolean-literal", DataUsage.CONDITION_VALUE, DataCategory.BOOLEAN),
    NUMERIC_LITERAL("numeric-literal", DataUsage.DISPLAY, DataCategory.NUMERIC),
    STRING_LITERAL("string-literal", DataUsage.DISPLAY, DataCategory.ALPHANUMERIC),
    INTERMEDIATE_CONDITION("intermediate-condition", DataUsage.CONDITION_VALUE, DataCategory.BOOLEAN),
    INTERMEDIATE_RESULT("intermediate-result", DataUsage.DISPLAY, DataCategory.NUMERIC);

    public static final int MAX_DIGITS = 38;
    public static final int MAX_SIZE = 16;
    public static final int MAX_PROMOTABLE_DIGITS = 18;
    private static final int[] digitsBySize;
    private static final int[] sizeByDigits;
    private static final int[] sizeByDigitsWordsMode;
    private final String name;
    private final DataUsage usage;
    private final DataCategory category;
    private final TruncConvention truncConvention;
    private final Class<?> storeConvention;
    private final Class<?> loadConvention;
    private final IStaticCast staticCastFunction;

    public static int getDigitsBySize(int n) {
        if (n < 1) {
            return digitsBySize[0];
        }
        if (n > 16) {
            return digitsBySize[16];
        }
        return digitsBySize[n];
    }

    public static int getSizeByDigits(int n) {
        return BuiltIn.getSizeByDigits(n, false);
    }

    public static int getSizeByDigits(int n, boolean bl) {
        int[] nArray;
        int[] nArray2 = nArray = bl ? sizeByDigitsWordsMode : sizeByDigits;
        if (n < 1) {
            return nArray[0];
        }
        if (n > 38) {
            return nArray[38];
        }
        return nArray[n];
    }

    public boolean is(DataUsage dataUsage) {
        return this.usage == dataUsage;
    }

    private BuiltIn(String string2, DataUsage dataUsage, DataCategory dataCategory) {
        this(string2, dataUsage, dataCategory, TruncConvention.YES, null, null, null);
    }

    private BuiltIn(String string2, DataUsage dataUsage, DataCategory dataCategory, TruncConvention truncConvention, Class<?> clazz) {
        this(string2, dataUsage, dataCategory, truncConvention, clazz, clazz, null);
    }

    private BuiltIn(String string2, DataUsage dataUsage, DataCategory dataCategory, TruncConvention truncConvention, Class<?> clazz, IStaticCast iStaticCast) {
        this(string2, dataUsage, dataCategory, truncConvention, clazz, clazz, iStaticCast);
    }

    private BuiltIn(String string2, DataUsage dataUsage, DataCategory dataCategory, TruncConvention truncConvention, Class<?> clazz, Class<?> clazz2) {
        this(string2, dataUsage, dataCategory, truncConvention, clazz, clazz2, null);
    }

    private BuiltIn(String string2, DataUsage dataUsage, DataCategory dataCategory, TruncConvention truncConvention, Class<?> clazz, Class<?> clazz2, IStaticCast iStaticCast) {
        this.name = string2;
        this.usage = dataUsage;
        this.category = dataCategory;
        this.truncConvention = truncConvention;
        this.storeConvention = clazz;
        this.loadConvention = clazz2;
        this.staticCastFunction = iStaticCast;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3 = 0;
        System.out.print("digits to bytes: ");
        for (n2 = 1; n2 <= 38; ++n2) {
            n = (n2 * 3402 >>> 10) + 1;
            n3 = (n + 7) / 8;
            System.out.print(n3 + " ");
        }
        System.out.println();
        System.out.print("bytes to digits: ");
        for (n2 = 1; n2 <= n3; ++n2) {
            n = n2 * 8 * 1024 / 3402 + 1;
            System.out.print(n + " ");
        }
        System.out.println();
    }

    public String getName() {
        return this.name;
    }

    public DataUsage getUsage() {
        return this.usage;
    }

    public DataCategory getCategory() {
        return this.category;
    }

    public TruncConvention getTruncConvention() {
        return this.truncConvention;
    }

    public Class<?> getStoreConvention() {
        return this.storeConvention;
    }

    public Class<?> getLoadConvention() {
        return this.loadConvention;
    }

    public IStaticCast getStaticCastFunction() {
        return this.staticCastFunction;
    }

    static {
        digitsBySize = new int[]{0, 3, 5, 8, 10, 13, 15, 17, 20, 22, 25, 27, 29, 32, 34, 37, 39};
        sizeByDigits = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 15, 15, 15, 16, 16};
        sizeByDigitsWordsMode = new int[]{0, 2, 2, 2, 2, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    }
}

