/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.web;

import com.iscobol.web.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequest {
    private InputStream inp;
    private String boundary;
    private int eolToSkip;
    private int maxRead = 0x100000;
    private int readCnt = 0;
    private File directory;
    private String prefix;
    private boolean inRam = false;
    private String charset = "ISO-8859-1";
    Vector params = new Vector();
    byte[] buffer = new byte[65536];
    int bufPos = 0;
    int bufCnt = 0;

    public MultipartRequest(HttpServletRequest req, int maxSize, File dir, String pref) throws IOException {
        Part p;
        String s1 = req.getContentType();
        String s2 = req.getHeader("Content-Type");
        this.setCharset(req.getCharacterEncoding());
        this.maxRead = maxSize;
        this.directory = dir;
        this.prefix = pref;
        this.inRam = false;
        String contentType = s1 == null ? (s2 == null ? null : s2) : (s2 == null ? s1 : (s1.length() > s2.length() ? s1 : s2));
        if (!req.getMethod().equalsIgnoreCase("POST") || contentType != null && !contentType.toLowerCase().startsWith("multipart/form-data")) {
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String pName = (String)en.nextElement();
                String pValue = req.getParameter(pName);
                this.params.addElement(new Part(this, pName, pValue));
            }
            return;
        }
        if (contentType == null) {
            throw new IOException("null content-type");
        }
        this.initFile((InputStream)req.getInputStream());
        int len = req.getContentLength();
        if (len > this.maxRead) {
            throw new IOException("Content length of " + len + " exceeds limit of " + this.maxRead);
        }
        int index = contentType.lastIndexOf("boundary=");
        if (index == -1) {
            throw new IOException("Boundary not found");
        }
        this.boundary = contentType.substring(index + 9);
        if (this.boundary.charAt(0) == '\"') {
            index = this.boundary.lastIndexOf(34);
            this.boundary = this.boundary.substring(1, index);
        }
        this.boundary = "--" + this.boundary;
        String line = this.readLine();
        if (line == null) {
            throw new IOException("Corrupted form data: premature EOF");
        }
        if (!line.startsWith(this.boundary)) {
            throw new IOException("Corrupted form data: missing boundary: " + line + " != " + this.boundary);
        }
        while ((p = this.nextPart()) != null) {
            this.params.addElement(p);
        }
    }

    public void setCharset(String cs) {
        if (cs != null) {
            try {
                "A".getBytes(cs);
                this.charset = cs;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public Part getPart(String name) {
        Part Return2 = null;
        if (name != null) {
            Enumeration en = this.params.elements();
            while (en.hasMoreElements()) {
                Part p = (Part)en.nextElement();
                if (!name.equals(p.getName())) continue;
                Return2 = p;
                break;
            }
        }
        return Return2;
    }

    public Map getParameterMap() {
        HashMap<String, String> Return2 = new HashMap<String, String>();
        Enumeration en = this.params.elements();
        while (en.hasMoreElements()) {
            Part p = (Part)en.nextElement();
            String key = p.getName();
            String value = p.getFileName() == null ? p.getValue() : p.getFullPathName();
            Return2.put(key, value);
        }
        return Return2;
    }

    public String getStringParameter(String name) {
        String Return2 = null;
        if (name != null) {
            Enumeration en = this.params.elements();
            while (en.hasMoreElements()) {
                Part p = (Part)en.nextElement();
                if (!name.equals(p.getName()) || p.isFile()) continue;
                Return2 = p.getValue();
                break;
            }
        }
        return Return2;
    }

    public byte[] getBytesParameter(String name) {
        byte[] Return2 = null;
        if (name != null) {
            Enumeration en = this.params.elements();
            while (en.hasMoreElements()) {
                Part p = (Part)en.nextElement();
                if (!name.equals(p.getName()) || !p.isFile()) continue;
                Return2 = p.getBytes();
                if (Return2 != null) break;
                InputStream is = p.getInputStream();
                try {
                    is.reset();
                    Return2 = new byte[is.available()];
                    is.read(Return2);
                }
                catch (IOException e) {
                    System.err.println(e);
                }
                break;
            }
        }
        return Return2;
    }

    public Enumeration getParameterNames() {
        Vector<String> a = new Vector<String>();
        Enumeration en = this.params.elements();
        while (en.hasMoreElements()) {
            a.addElement(((Part)en.nextElement()).getName());
        }
        return a.elements();
    }

    private Part nextPart() throws IOException {
        Vector<String> header = new Vector<String>();
        String line = this.readLine();
        if (line == null || line.length() == 0) {
            return null;
        }
        header.addElement(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            header.addElement(line);
        }
        if (line == null) {
            return null;
        }
        String name = null;
        String fileName = null;
        String contentType = "text/plain";
        Enumeration en = header.elements();
        while (en.hasMoreElements()) {
            line = (String)en.nextElement();
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("content-disposition: ")) {
                if (!"form-data;".equals(line.substring(21, 31))) {
                    throw new IOException("Wrong Content-Disposition: " + line);
                }
                int start = lowerLine.indexOf("name=\"", 31);
                int end = lowerLine.indexOf("\"", start += 6);
                if (start < 6 || end < 0) {
                    throw new IOException("Wrong name in Content-Disposition:" + line);
                }
                name = line.substring(start, end);
                start = lowerLine.indexOf("filename=\"", end);
                end = lowerLine.indexOf("\"", start += 10);
                if (start < 10 || end < 0) {
                    fileName = null;
                    continue;
                }
                fileName = line.substring(start, end);
                continue;
            }
            if (!lowerLine.startsWith("content-type: ")) continue;
            if (line.length() > 14) {
                contentType = line.substring(14);
                continue;
            }
            throw new IOException("Wrong Content-Type:" + line);
        }
        return new Part(this, name, fileName, contentType, this.boundary, this.inRam, this.directory, this.prefix);
    }

    private boolean read() throws IOException {
        boolean Return2 = false;
        this.bufCnt = this.inp.read(this.buffer);
        this.bufPos = 0;
        if (this.bufCnt > 0) {
            this.readCnt += this.bufCnt;
            Return2 = true;
        }
        if (this.readCnt > this.maxRead) {
            throw new IOException("real stream length > " + this.maxRead + " bytes");
        }
        return Return2;
    }

    private void initFile(InputStream in) throws IOException {
        this.inp = in;
        if (!this.read()) {
            throw new IOException("void input stream");
        }
        int rc = this.eol();
        if (rc < 0) {
            throw new IOException("Corrupted input stream");
        }
        this.eolToSkip = this.buffer[rc - 1] == 13 ? 1 : 0;
    }

    private int eol(int max) {
        if ((max += this.bufPos) > this.bufCnt) {
            max = this.bufCnt;
        }
        for (int i = this.bufPos; i < max; ++i) {
            if (this.buffer[i] != 10 || this.eolToSkip != 0 && (i <= 0 || this.buffer[i - 1] != 13)) continue;
            return i;
        }
        return -1;
    }

    private int eol() {
        for (int i = this.bufPos; i < this.bufCnt; ++i) {
            if (this.buffer[i] != 10 || this.eolToSkip != 0 && (i <= 0 || this.buffer[i - 1] != 13)) continue;
            return i;
        }
        return -1;
    }

    String readLine() throws IOException {
        StringBuffer iBuf = new StringBuffer();
        String Return2 = null;
        if (this.bufCnt >= 0) {
            int rc = this.eol();
            while (rc < 0 && this.bufCnt >= 0) {
                if (this.bufCnt > this.bufPos) {
                    iBuf.append(new String(this.buffer, this.bufPos, this.bufCnt - this.bufPos));
                }
                this.read();
                rc = this.eol();
            }
            if (rc > this.bufPos + this.eolToSkip) {
                iBuf.append(new String(this.buffer, this.bufPos, rc - this.bufPos - this.eolToSkip));
            }
            if (iBuf.length() > 0) {
                Return2 = iBuf.toString();
            } else if (rc == this.bufPos + this.eolToSkip) {
                Return2 = "";
            }
            this.bufPos = rc + 1;
        }
        return Return2;
    }

    int readLine(byte[] b, int offs, int len) throws IOException {
        int Return2 = 0;
        if (this.bufCnt >= 0) {
            int tmp;
            int rc = this.eol(len);
            while (len > 0 && rc < 0 && this.bufCnt >= 0) {
                tmp = this.bufCnt - this.bufPos;
                if (tmp > 0) {
                    if (tmp <= len) {
                        System.arraycopy(this.buffer, this.bufPos, b, offs, tmp);
                        this.read();
                        Return2 += tmp;
                        offs += tmp;
                        len -= tmp;
                    } else {
                        System.arraycopy(this.buffer, this.bufPos, b, offs, len);
                        Return2 += len;
                        offs += len;
                        this.bufPos += len;
                        len = 0;
                    }
                } else {
                    this.read();
                }
                rc = this.eol(len);
            }
            tmp = rc - this.bufPos + 1;
            if (tmp > 0) {
                if (tmp <= len) {
                    System.arraycopy(this.buffer, this.bufPos, b, offs, tmp);
                    Return2 += tmp;
                    this.bufPos += tmp;
                } else {
                    System.arraycopy(this.buffer, this.bufPos, b, offs, len);
                    Return2 += len;
                    this.bufPos += len;
                }
            }
        }
        return Return2;
    }

    int getEolToSkip() {
        return this.eolToSkip;
    }

    public void finalize() {
        if (this.params != null) {
            Enumeration en = this.params.elements();
            while (en.hasMoreElements()) {
                try {
                    ((Part)en.nextElement()).finalize();
                }
                catch (Throwable throwable) {}
            }
        }
        this.params = null;
    }
}

