/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RuntimeProperties;
import com.iscobol.utility.Json2Wrk;
import com.iscobol.utility.WSDL2Wrk;
import com.iscobol.utility.Xml2Wrk;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class Stream2Wrk {
    public static final String JSON = "json";
    public static final String WSDL = "wsdl";
    public static final String XML = "xml";
    public static final String XSD = "xsd";
    private static final String usageXml = "  uri [-o outputfile] [-p prefix] [-se enumeration-suffix] [-sa attribute-suffix] [-sc count-suffix] [-scp capacity-suffix] [-sd data-suffix] [-d] [-c] [-e] [-iu] [-l[=len]] [-nc]";
    public static final String usage = "JSON: java " + Stream2Wrk.class.getName() + " json uri [-o outputfile] [-p prefix] [-r rootname] [-d] [-anyescape]\nWSDL: java " + Stream2Wrk.class.getName() + " wsdl uri [-o outputfile] [-v1.1]\nXML : java " + Stream2Wrk.class.getName() + " xml" + "  uri [-o outputfile] [-p prefix] [-se enumeration-suffix] [-sa attribute-suffix] [-sc count-suffix] [-scp capacity-suffix] [-sd data-suffix] [-d] [-c] [-e] [-iu] [-l[=len]] [-nc]" + "\nXSD : java " + Stream2Wrk.class.getName() + " xsd" + "  uri [-o outputfile] [-p prefix] [-se enumeration-suffix] [-sa attribute-suffix] [-sc count-suffix] [-scp capacity-suffix] [-sd data-suffix] [-d] [-c] [-e] [-iu] [-l[=len]] [-nc]" + "\n-v print version number";

    public static void main(String[] argv) throws Exception {
        String outBaseName;
        if (argv.length == 1 && "-v".equals(argv[0])) {
            String version = RuntimeProperties.getFullVersionNumber();
            if (version.startsWith("isCOBOL")) {
                version = "isCOBOL-Stream2Wrk" + version.substring(7);
            }
            System.out.println(version);
            System.exit(0);
        }
        if (argv.length < 2) {
            Stream2Wrk.usage();
        }
        String format = argv[0];
        String uri = argv[1];
        String outputFile = null;
        int wsdlV11 = 1;
        String prefix = null;
        String suffixEnum = null;
        String suffixData = null;
        String suffixAttr = null;
        String suffixCap = null;
        String suffixCount = null;
        boolean ignoreUnb = false;
        boolean disambiguate = false;
        String rootName = null;
        boolean anyEscape = false;
        boolean genCount = false;
        boolean gen88 = false;
        boolean genComments = true;
        int genFixedLen = -1;
        StringBuilder hs = new StringBuilder();
        hs.append("Stream2Wrk options:");
        try {
            for (int i = 2; i < argv.length; ++i) {
                if ("-o".equals(argv[i])) {
                    Stream2Wrk.logOpt(hs, argv[i]);
                    outputFile = argv[++i];
                    Stream2Wrk.logOpt(hs, argv[i]);
                    continue;
                }
                if ("-v1.1".equals(argv[i])) {
                    if (WSDL.equals(format)) {
                        wsdlV11 = 0;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-p".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format) || JSON.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        prefix = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-se".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        suffixEnum = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-sd".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        suffixData = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-sa".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        suffixAttr = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-sc".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        suffixCount = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-scp".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        suffixCap = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-d".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format) || JSON.equals(format)) {
                        disambiguate = true;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-iu".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        ignoreUnb = true;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-c".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        genCount = true;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-l".equals(argv[i]) || argv[i].startsWith("-l=")) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        if ("-l".equals(argv[i])) {
                            genFixedLen = 0;
                            Stream2Wrk.logOpt(hs, argv[i]);
                            continue;
                        }
                        try {
                            genFixedLen = Integer.parseInt(argv[i].substring(3));
                            if (genFixedLen <= 0) {
                                Stream2Wrk.usage();
                                continue;
                            }
                            Stream2Wrk.logOpt(hs, argv[i]);
                        }
                        catch (NumberFormatException ex) {
                            Stream2Wrk.usage();
                        }
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-e".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        gen88 = true;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-nc".equals(argv[i])) {
                    if (XML.equals(format) || XSD.equals(format)) {
                        genComments = false;
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if ("-r".equals(argv[i])) {
                    if (JSON.equals(format)) {
                        Stream2Wrk.logOpt(hs, argv[i]);
                        rootName = argv[++i];
                        Stream2Wrk.logOpt(hs, argv[i]);
                        continue;
                    }
                    Stream2Wrk.usage();
                    continue;
                }
                if (!"-anyescape".equals(argv[i])) continue;
                if (JSON.equals(format)) {
                    Stream2Wrk.logOpt(hs, argv[i]);
                    anyEscape = true;
                    continue;
                }
                Stream2Wrk.usage();
            }
        }
        catch (Exception ex) {
            Stream2Wrk.usage();
        }
        String[] resultContents = null;
        String[] resultSuffix = null;
        if (JSON.equals(format)) {
            Json2Wrk json2wrk = new Json2Wrk(uri, prefix, disambiguate, rootName, anyEscape);
            json2wrk.setHeaderString(hs.toString());
            resultContents = new String[]{json2wrk.generateCopyFile()};
            resultSuffix = new String[]{""};
        } else if (WSDL.equals(format)) {
            WSDL2Wrk wsdl2wrk = new WSDL2Wrk(uri, wsdlV11);
            wsdl2wrk.setHeaderString(hs.toString());
            Map<String, StringBuilder> map = wsdl2wrk.generateCopyfiles();
            resultContents = new String[map.size()];
            resultSuffix = new String[map.size()];
            int i = 0;
            for (String str : map.keySet()) {
                resultContents[i] = map.get(str).toString();
                resultSuffix[i] = "-" + str;
                ++i;
            }
        } else if (XML.equals(format) || XSD.equals(format)) {
            Xml2Wrk xml2wrk = new Xml2Wrk(uri, XSD.equals(format), disambiguate, gen88, genCount, genFixedLen, prefix, suffixData, suffixAttr, suffixEnum, suffixCount, suffixCap, ignoreUnb, genComments);
            xml2wrk.setHeaderString(hs.toString());
            resultContents = new String[]{xml2wrk.generateCopyFile()};
            resultSuffix = new String[]{""};
        } else {
            Stream2Wrk.usage();
        }
        if (outputFile != null) {
            outBaseName = outputFile;
        } else {
            try {
                URL url = new URL(uri);
                outBaseName = new File(url.getPath()).getName();
            }
            catch (MalformedURLException ex) {
                outBaseName = uri;
            }
        }
        String outExt = ".wrk";
        int idx = outBaseName.lastIndexOf(46);
        if (idx >= 0) {
            if (outputFile != null) {
                outExt = outBaseName.substring(idx);
            }
            outBaseName = outBaseName.substring(0, idx);
        }
        for (int i = 0; i < resultContents.length; ++i) {
            String out = outBaseName + resultSuffix[i] + outExt;
            PrintWriter pw = new PrintWriter(new FileOutputStream(out));
            pw.println(resultContents[i]);
            pw.close();
            System.out.println("Generated '" + out + "'.");
        }
    }

    private static void logOpt(StringBuilder hs, String s) {
        hs.append(" ");
        if (s.length() > 0) {
            hs.append(s);
        } else {
            hs.append("\"\"");
        }
    }

    private static void usage() {
        System.err.println(usage);
        System.exit(1);
    }
}

