/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public class PicShort
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public PicShort(Memory mem, int offs, int il, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, PicShort.bDigits(2, il, 0), 0, true, 2, dimSize, dim, name, pComma);
        if (mem != null) {
            this.updateCache(mem, this.theValue);
        }
    }

    public PicShort(CobolVar par, int offs, int il, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, PicShort.bDigits(2, il, 0), 0, true, 2, dimSize, dim, name, pComma);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[2] + 1;
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        this.internalSet(mem, cn.getUnscaledLong());
    }

    @Override
    void updateMemory(Memory mem) {
        this.internalSet(mem, this.num().getUnscaledLong());
    }

    protected void internalSet(Memory buf, long unscaled) {
        int start = this.curOffset;
        buf.put(start++, (byte)(unscaled >>> 8));
        buf.put(start, (byte)unscaled);
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        cn.set(this.getLongFromMem(mem), this.decLen);
    }

    @Override
    public void defaultInitialize() {
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, (byte)0);
        this.theValue.lnUnscValue = 0L;
    }

    protected long getLongFromMem(Memory buf) {
        int start = this.curOffset;
        short unscaled = (short)((buf.get(start++) & 0xFF) << 8);
        unscaled = (short)(unscaled | (short)(buf.get(start) & 0xFF));
        return unscaled;
    }

    @Override
    public boolean set(long unscaled) {
        this.theValue.lnUnscValue = (short)unscaled;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        if (scale != 0) {
            unscaled = rounded ? CobolNum.roundUpIfNeeded(unscaled, scale) / CobolNum.fact[scale] : (unscaled /= CobolNum.fact[scale]);
        }
        if (checkOverflow && CobolNum.isLongOverflowByte(unscaled, this.len, this.signed, scale - this.decLen)) {
            return true;
        }
        this.theValue.lnUnscValue = (short)unscaled;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        if (checkOverflow && d.isOverflowByte(this.theValue, this.len, this.signed)) {
            return true;
        }
        this.theValue.lnUnscValue = (short)d.shortValue(rounded);
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public void addToMe(long i) {
        Memory mem = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(mem) + i);
        this.internalSet(mem, this.theValue.lnUnscValue);
    }

    @Override
    public void subFromMe(long i) {
        Memory mem = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(mem) - i);
        this.internalSet(mem, this.theValue.lnUnscValue);
    }

    @Override
    public void multiplyByMe(long i) {
        Memory mem = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(mem) * i);
        this.internalSet(mem, this.theValue.lnUnscValue);
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        Memory mem = this.memory.getMemory();
        if (i == 0L) {
            this.theValue.set(this.getLongFromMem(mem));
            this.theValue.divideIntoMe(checkdivbyzero, (short)i);
            this.internalSet(mem, this.theValue.intValue());
        } else {
            short v = (short)(this.getLongFromMem(mem) / i);
            this.internalSet(mem, v);
        }
    }
}

