/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.PictureAnalyzer;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicX;
import java.io.UnsupportedEncodingException;

public class PicNumEdit
extends PicX
implements EncBytes,
IPicNumEdit {
    private static final long serialVersionUID = 123L;
    protected static final int checkNC;
    private CobolNum theValue;
    protected final PictureAnalyzer format;
    private byte[] buffer;
    private final String picture;
    protected boolean blankWhenZero;
    private int end;

    public PicNumEdit(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        this(m, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, String.valueOf(currChar), currChar);
    }

    public PicNumEdit(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, String currSign, char currChar) {
        super(m, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = pic;
        this.end = this.curOffset + this.getLength();
        this.format = new PictureAnalyzer(pic, pComma, currSign, currChar);
        this.blankWhenZero = blWhen0 || this.format.isBlankWhenZero();
        this.theValue = CobolNum.get(this.format.getTotLen(), this.format.getDecLen());
        this.buffer = new byte[phisicLen + 1];
    }

    public PicNumEdit(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, char currChar) {
        this(parent, offs, phisicLen, dimSize, dim, name, pic, pComma, blWhen0, String.valueOf(currChar), currChar);
    }

    public PicNumEdit(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma, boolean blWhen0, String currSign, char currChar) {
        super(parent, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = pic;
        this.end = this.curOffset + this.getLength();
        this.format = new PictureAnalyzer(pic, pComma, currSign, currChar);
        this.blankWhenZero = blWhen0 || this.format.isBlankWhenZero();
        this.theValue = CobolNum.get(this.format.getTotLen(), this.format.getDecLen());
        this.buffer = new byte[phisicLen + 1];
    }

    public PicNumEdit(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        this(m, offs, phisicLen, dimSize, dim, name, pic, pComma, false, "$", '$');
    }

    public PicNumEdit(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        this(parent, offs, phisicLen, dimSize, dim, name, pic, pComma, false, "$", '$');
    }

    protected Object clone() {
        PicNumEdit Return2;
        try {
            Return2 = (PicNumEdit)super.clone();
            Return2.theValue = CobolNum.noo(this.theValue);
            Return2.buffer = new byte[this.buffer.length];
        }
        catch (CloneNotSupportedException _ex) {
            Return2 = null;
        }
        return Return2;
    }

    @Override
    public char getCurrencyChar() {
        return this.format.getCurrencyChar();
    }

    public boolean isNumericCheckContent() {
        char[] mem = this.toString().toCharArray();
        char[] intPicture = this.format.getPicture();
        if (this.blankWhenZero) {
            int i;
            for (i = 0; i < mem.length && mem[i] == ' '; ++i) {
            }
            if (i == mem.length) {
                return true;
            }
        }
        int ccEnd = this.format.getCCEnd();
        int i = 0;
        int j = 0;
        while (i < mem.length) {
            if (intPicture[j] == '9' && !Character.isDigit(mem[i])) {
                return false;
            }
            if (intPicture[j] == '+' && mem[i] != '+' && mem[i] != '-' && !Character.isDigit(mem[i])) {
                return false;
            }
            if (intPicture[j] == '-' && mem[i] != '-' && mem[i] != ' ' && !Character.isDigit(mem[i])) {
                return false;
            }
            if (intPicture[j] == 'Z' && mem[i] != ' ' && !Character.isDigit(mem[i])) {
                return false;
            }
            if (j == ccEnd) {
                i += this.format.currencySignBytes.length - 1;
            }
            ++i;
            ++j;
        }
        return true;
    }

    @Override
    public CobolVar moveTo(NumericVar dest) {
        dest.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicNumEdit dest) {
        dest.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this);
        return this;
    }

    void updateMemory(Memory mem, CobolNum value) {
        if (value.signum() == 0) {
            if (this.blankWhenZero) {
                for (int i = this.curOffset; i < this.end; ++i) {
                    mem.put(i, C_SPACE);
                }
                return;
            }
            if (this.format.isStarWhenZero()) {
                int csLen = 0;
                byte[] ccBytes = this.format.currencySignBytes;
                for (int i = this.curOffset; i < this.end; ++i) {
                    int formatOffs = i - this.curOffset;
                    byte b = this.format.getByte(formatOffs - csLen);
                    if (b == 0) {
                        mem.put(i, C_STAR);
                    } else {
                        mem.put(i, b);
                    }
                    if (formatOffs != this.format.getCCStart() || ccBytes.length <= 1) continue;
                    csLen = ccBytes.length - 1;
                    for (int j = 0; j < csLen; ++j) {
                        mem.put(++i, C_STAR);
                    }
                }
                return;
            }
        }
        if (this.format.getFoundP()) {
            value = this.P(value, true);
        }
        value.setScale(this.format.getDecLen(), false, false);
        int srcLen = value.toByteArray(this.buffer);
        this.internalSet(this.buffer, 0, srcLen, false, mem);
    }

    @Override
    void updateMemory(Memory mem) {
        this.updateMemory(mem, this.num());
    }

    @Override
    public boolean set(CobolNum d) {
        return this.set(d, false, false);
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        if (this.format.getFoundP()) {
            d = this.P(d, true);
        }
        if ((overflow = d.isOverflow(this.theValue, this.format.getIntLen())) && checkOverflow) {
            return true;
        }
        this.theValue.set(d, rounded, false);
        if (!this.format.getSigned() && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.format.getDecLen() != d.scale()) {
            this.theValue.setScale(this.format.getDecLen(), rounded, false);
        }
        if (overflow) {
            this.theValue.setSizeDigit(this.format.getIntLen(), this.format.getDecLen());
        }
        if (this.format.getFoundP()) {
            this.updateMemory(this.memory.getMemory(), this.P(this.theValue, false));
        } else {
            this.updateMemory(this.memory.getMemory(), this.theValue);
        }
        return false;
    }

    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        boolean overflow;
        if (this.isFinal) {
            return true;
        }
        if (this.format.getFoundP()) {
            unscaled = this.P(unscaled, true);
        }
        int decLen = this.format.getDecLen();
        int intLen = this.format.getIntLen();
        boolean signed = this.format.getSigned();
        int scaleDiff = scale - decLen;
        if (rounded && scaleDiff > 0) {
            unscaled = CobolNum.roundUpIfNeeded(unscaled, scaleDiff);
        }
        if ((overflow = CobolNum.isLongOverflow(unscaled, scale, intLen)) && checkOverflow) {
            return true;
        }
        if (!signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        this.theValue.set(unscaled, scale);
        if (decLen != scale) {
            this.theValue.setScale(decLen, false, false);
        }
        if (overflow) {
            this.theValue.setSizeDigit(intLen, decLen);
        }
        if (this.format.getFoundP()) {
            this.updateMemory(this.memory.getMemory(), this.P(this.theValue, false));
        } else {
            this.updateMemory(this.memory.getMemory(), this.theValue);
        }
        return false;
    }

    @Override
    void setBytes(Memory srcMem, int srcStart, int srcLen) {
        byte[] src = srcMem.toByteArray(srcStart, srcLen);
        for (srcStart = 0; srcStart < src.length && src[srcStart] == C_0; ++srcStart) {
        }
        this.internalSet(src, srcStart, src.length, true, this.getMemory());
    }

    @Override
    public boolean set(String s) {
        int srcOffs;
        byte[] src = s.getBytes();
        for (srcOffs = 0; srcOffs < src.length && src[srcOffs] == C_0; ++srcOffs) {
        }
        this.internalSet(src, srcOffs, src.length, true, this.getMemory());
        return false;
    }

    @Override
    public boolean set(boolean value) {
        return this.set(CobolNum.noo(value ? 1L : 0L, 0), false, false);
    }

    @Override
    public boolean set(byte value) {
        return this.set(CobolNum.noo(value, 0), false, false);
    }

    @Override
    public boolean set(char value) {
        return this.set(CobolNum.noo(value, 0), false, false);
    }

    @Override
    public boolean set(short value) {
        return this.set(CobolNum.noo(value, 0), false, false);
    }

    @Override
    public boolean set(int value) {
        return this.set(CobolNum.noo(value, 0), false, false);
    }

    @Override
    public boolean set(long value) {
        return this.set(CobolNum.noo(value, 0), false, false);
    }

    @Override
    public boolean set(float value) {
        return this.set(CobolNum.noo((double)value), false, false);
    }

    @Override
    public boolean set(double value) {
        return this.set(CobolNum.noo(value), false, false);
    }

    @Override
    protected void set(NumericVar nv) {
        this.set(nv.num(), false, false);
    }

    @Override
    void internalSet(CobolVar cv) {
        boolean save = this.blankWhenZero;
        this.blankWhenZero = false;
        cv.moveTo(this);
        this.blankWhenZero = save;
    }

    @Override
    protected void set(PicX px) {
        this.set(px.toString());
    }

    @Override
    protected void set(PicNumEdit pne) {
        this.set(pne.num(), false, false);
    }

    @Override
    public boolean toboolean() {
        return this.num().signum() != 0;
    }

    @Override
    public byte tobyte() {
        return (byte)this.num().intValue();
    }

    @Override
    public char tochar() {
        return (char)this.num().intValue();
    }

    @Override
    public short toshort() {
        return (short)this.num().intValue();
    }

    @Override
    public int toint() {
        return this.num().intValue();
    }

    @Override
    public long tolong() {
        return this.num().longValue();
    }

    @Override
    public float tofloat() {
        return this.num().floatValue();
    }

    @Override
    public double todouble() {
        return this.num().doubleValue();
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        this.theValue.set(0L, this.format.getDecLen());
        this.updateMemory(this.memory.getMemory(), this.theValue);
    }

    @Override
    public void setZero() {
        this.defaultInitialize();
    }

    @Override
    public void setAllZero() {
        this.defaultInitialize();
    }

    public int scale() {
        return this.format.getDecLen();
    }

    @Override
    public CobolNum num() {
        this.updateCache(this.memory.getMemory(), this.theValue);
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false);
        }
        return this.theValue;
    }

    protected void internalSet(byte[] src, int srcOffs, int srcEnd, boolean isString, Memory mem) {
        byte b;
        int p;
        int init;
        int dotIdx;
        if (srcEnd - srcOffs <= 0) {
            this.internalSet(new byte[]{C_0}, 0, 1, false, mem);
            return;
        }
        boolean minus = false;
        int i = srcOffs;
        if (!isString && src[srcOffs] == C_MINUS) {
            ++i;
            if (this.format.getSigned()) {
                minus = true;
            }
        }
        if (isString) {
            dotIdx = srcEnd;
        } else {
            for (dotIdx = srcOffs; dotIdx < srcEnd && src[dotIdx] != C_POINT; ++dotIdx) {
            }
        }
        int temp = this.format.getIntLen() - dotIdx + i;
        int j = temp < 0 ? this.curOffset : this.curOffset + temp;
        int ccStart = this.format.getCCStart();
        int signPosition = this.format.getSignPosition();
        for (int x = this.curOffset; x <= j; ++x) {
            if (this.format.getByte(x - this.curOffset) == 0 && this.curOffset + signPosition != x && x - this.curOffset != ccStart) continue;
            ++j;
        }
        if (src[i] == C_0 && !isString) {
            ++i;
            ++j;
        }
        if (temp < 0) {
            i -= temp;
        }
        int currSignPosition = signPosition;
        int decimalPointPosition = this.format.getDecimalPointPosition();
        if (this.format.getFoundSign() && this.format.getSignOnHead()) {
            int init2 = j - this.curOffset;
            int lastPos = this.end - 1;
            if (signPosition >= init2) {
                currSignPosition = init2;
                int x = ++j;
                while (this.curOffset + currSignPosition < lastPos && this.format.getByte(x - this.curOffset) != 0 && x++ - this.curOffset != decimalPointPosition) {
                    ++currSignPosition;
                }
            }
        }
        int currccStart = ccStart;
        if (this.format.getFoundCurrencyChar() && ccStart >= (init = j - this.curOffset)) {
            currccStart = init;
            int formatIdx = currccStart + 1;
            int formatLen = this.format.length();
            if (formatIdx < formatLen) {
                ++j;
                while (formatIdx < formatLen && this.curOffset + currccStart < this.end && this.format.getByte(formatIdx) != 0 && formatIdx != decimalPointPosition) {
                    ++formatIdx;
                    ++currccStart;
                }
            } else {
                ++currccStart;
            }
        }
        int replacementPosition = this.format.getReplacementPosition();
        byte replacementChar = this.format.getReplacementByte();
        int csLen = 0;
        byte[] ccBytes = this.format.currencySignBytes;
        for (int x = this.curOffset; x < this.end; ++x) {
            int formatOffs = x - this.curOffset;
            byte formatChar = this.format.getByte(formatOffs - csLen);
            if (formatOffs == 0 && formatChar != 0) {
                mem.put(x, formatChar);
            } else if (formatOffs - csLen < replacementPosition) {
                mem.put(x, replacementChar);
            } else if (formatChar != 0) {
                mem.put(x, formatChar);
            } else {
                mem.put(x, C_0);
            }
            if (formatOffs != currccStart || ccBytes.length <= 1) continue;
            csLen = ccBytes.length - 1;
            for (int idx = 0; idx < csLen; ++idx) {
                mem.put(++x, replacementChar);
            }
        }
        j += csLen;
        while (i < srcEnd && j < this.end) {
            int formatOffs = j - this.curOffset;
            if (i == dotIdx && !isString) {
                ++i;
            } else {
                if (this.format.getByte(formatOffs - csLen) == 0) {
                    if (this.curOffset + currSignPosition != j && formatOffs != currccStart) {
                        mem.put(j, src[i++]);
                    }
                } else {
                    mem.put(j, this.format.getByte(formatOffs - csLen));
                }
                ++j;
            }
            if (formatOffs != currccStart || ccBytes.length <= 1) continue;
            csLen = ccBytes.length - 1;
            j += csLen;
        }
        if (this.format.getFoundCurrencyChar()) {
            p = currccStart != -1 ? this.curOffset + currccStart : this.end - ccBytes.length;
            for (int idx = 0; idx < ccBytes.length && p < mem.length; ++idx, ++p) {
                mem.put(p, ccBytes[idx]);
            }
        }
        if (this.format.getSigned()) {
            p = currSignPosition != -1 ? this.curOffset + currSignPosition : this.end - 1;
            switch (this.format.getSign()) {
                case 0: {
                    if (minus) {
                        mem.put(p, C_MINUS);
                        break;
                    }
                    mem.put(p, C_PLUS);
                    break;
                }
                case 1: {
                    if (minus) {
                        mem.put(p, C_MINUS);
                        break;
                    }
                    mem.put(p, C_SPACE);
                    break;
                }
                case 3: {
                    if (minus) {
                        mem.put(this.end - 2, C_D);
                        mem.put(this.end - 1, C_B);
                        break;
                    }
                    mem.put(this.end - 2, C_SPACE);
                    mem.put(this.end - 1, C_SPACE);
                    break;
                }
                case 2: {
                    if (minus) {
                        mem.put(this.end - 2, C_C);
                        mem.put(this.end - 1, C_R);
                        break;
                    }
                    mem.put(this.end - 2, C_SPACE);
                    mem.put(this.end - 1, C_SPACE);
                }
            }
        }
        if ((b = mem.get(this.curOffset)) < C_0 || b > C_9) {
            int myEnd = decimalPointPosition >= 0 ? this.curOffset + decimalPointPosition : this.end;
            for (int x = this.curOffset + 1; x < myEnd && ((b = mem.get(x)) < C_0 || b > C_9); ++x) {
                if (b != C_POINT && b != C_COMMA) continue;
                for (int y = x; y > this.curOffset; --y) {
                    mem.put(y, mem.get(y - 1));
                }
                if (mem.get(this.curOffset) == C_STAR) continue;
                mem.put(this.curOffset, C_SPACE);
            }
        }
    }

    void updateCache(Memory mem, CobolNum cn) {
        String str;
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        try {
            str = new String(mem.toByteArray(this.getOffset(), this.getLen()), encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = "";
        }
        cn.set(CobolNum.get(str, this.format.getDecLen()), false, false);
    }

    @Override
    protected void updateEnd() {
        this.end = this.curOffset + this.getLength();
    }

    public PicNumEdit atEdit(int[] idxs) {
        return (PicNumEdit)this.intAt(idxs);
    }

    public PicNumEdit atEdit(int ix) {
        return (PicNumEdit)this.intAt(ix);
    }

    @Override
    protected int getCategory() {
        return 5;
    }

    private long P(long orig, boolean set) {
        if (this.format.getPOnLeft() ^ set) {
            return orig / this.format.getPNum().lnUnscValue;
        }
        return orig * this.format.getPNum().lnUnscValue;
    }

    private CobolNum P(CobolNum orig, boolean set) {
        if (this.format.getPOnLeft() ^ set) {
            return orig.divide(false, this.format.getPNum());
        }
        return orig.multiply(this.format.getPNum());
    }

    @Override
    public int compareTo(NumericVar nv) {
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false).compareTo(nv.num());
        }
        return super.compareTo(nv);
    }

    @Override
    public int compareTo(NumericVar nv, int[] collSeq) {
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false).compareTo(nv.num());
        }
        return super.compareTo(nv, collSeq);
    }

    @Override
    int internalCompare(ICobolVar value) {
        return -((CobolVar)value).compareTo(this);
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public void valueToTable(CobolVar cv, int[] idxs, int[] nDim, int dim) {
        if (nDim == null) {
            if (cv.isAll() || cv instanceof NumericVar) {
                super.internalSet(cv);
            } else {
                this.set(cv.getMemory(), cv.getOffset(), cv.getLen(), true);
            }
        } else {
            for (int i = 1; i <= nDim[dim]; ++i) {
                idxs[dim] = i;
                if (dim == nDim.length - 1) {
                    ((PicNumEdit)this.atNoClone(idxs)).valueToTable(cv, idxs, null, 0);
                    continue;
                }
                this.valueToTable(cv, idxs, nDim, dim + 1);
            }
        }
    }

    protected final void checkNumericContent() {
        if (!this.isNumericCheckContent()) {
            if (checkNC == 1) {
                throw new IscobolRuntimeException(31, this.name == null ? "" : this.name);
            }
            if (checkNC == -1) {
                Factory.log("CHECK NUMERIC CONTENT: detected not numeric " + (this.name == null ? "" : this.name));
            }
        }
    }

    @Override
    protected void setInitialValue() {
        this.set(this.initialValue.getMemory(), this.initialValue.getOffset(), this.initialValue.getLen(), true);
    }

    static {
        char tmp = Config.getProperty(".check.numeric_content", "N").charAt(0);
        checkNC = tmp == 'Y' || tmp == 'y' || tmp == 'S' || tmp == 's' || tmp == 'T' || tmp == 't' || tmp == '1' ? 1 : (tmp == 'N' || tmp == 'n' || tmp == 'F' || tmp == 'f' || tmp == '0' ? 0 : Config.getProperty(".check.numeric_content", 0));
    }
}

