/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.rts.Memory;
import com.iscobol.types.Dbcs;
import com.iscobol.types.PictureAnalyzer;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.PicG;
import com.iscobol.types_n.PicX;

public final class PicAlphaEditG
extends PicG
implements EncBytes,
IPicAlphaEdit {
    private static final long serialVersionUID = 123L;
    private char[] picture;
    protected int len;
    protected int end;
    private boolean editEnabled = true;

    public PicAlphaEditG(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(m, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    public PicAlphaEditG(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(parent, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    @Override
    public boolean set(String value) {
        return this.set(value.getBytes());
    }

    @Override
    public boolean set(byte[] src) {
        return this.set(src, 0, src.length, true);
    }

    @Override
    public void setLowValues() {
        this.setAll(Dbcs.lwBA);
    }

    @Override
    public void setHighValues() {
        this.setAll(Dbcs.hwBA);
    }

    @Override
    protected void set(PicX px) {
        int ft = px.getFigurativeType();
        switch (ft) {
            case -4: {
                this.setAll(Dbcs.quoteBA);
                break;
            }
            case -2: {
                this.setAll(Dbcs.fillBA);
                break;
            }
            case -3: {
                this.setAll(Dbcs.zeroBA);
                break;
            }
            case -1: {
                super.set(px);
                break;
            }
            default: {
                if (ft < Dbcs.dbcs.length) {
                    this.setAll(Dbcs.dbcs[ft]);
                    break;
                }
                super.set(px);
            }
        }
    }

    @Override
    protected void setAll(byte[] b) {
        Memory mem = this.getMemory();
        int j = this.curOffset;
        int pIdx = 0;
        while (j < this.end) {
            int c = this.editEnabled ? this.picture[pIdx] : 78;
            switch (c) {
                case 47: {
                    mem.put(j, Dbcs.slashBA[0]);
                    mem.put(j + 1, Dbcs.slashBA[1]);
                    break;
                }
                case 48: {
                    mem.put(j, Dbcs.zeroBA[0]);
                    mem.put(j + 1, Dbcs.zeroBA[1]);
                    break;
                }
                case 66: {
                    mem.put(j, Dbcs.fillBA[0]);
                    mem.put(j + 1, Dbcs.fillBA[1]);
                    break;
                }
                default: {
                    mem.put(j, b[0]);
                    mem.put(j + 1, b[1]);
                }
            }
            j += 2;
            ++pIdx;
        }
    }

    @Override
    public boolean set(byte[] src, int offs, int len, boolean filling) {
        Memory mem = this.getMemory();
        boolean error = false;
        for (int k = this.curOffset; k < this.end; k += 2) {
            mem.put(k, Dbcs.fillBA[0]);
            mem.put(k + 1, Dbcs.fillBA[1]);
        }
        int vIdx = 0;
        int j = this.curOffset;
        int pIdx = 0;
        while (j < this.end) {
            int c = this.editEnabled ? this.picture[pIdx] : 78;
            switch (c) {
                case 57: {
                    if (vIdx < len) {
                        mem.put(j, src[offs + vIdx++]);
                        if (vIdx < len) {
                            mem.put(j + 1, src[offs + vIdx++]);
                            break;
                        }
                        mem.put(j + 1, Dbcs.zeroBA[0]);
                        break;
                    }
                    mem.put(j, Dbcs.zeroBA[0]);
                    mem.put(j + 1, Dbcs.zeroBA[1]);
                    break;
                }
                case 71: 
                case 78: {
                    if (vIdx >= len) break;
                    mem.put(j, src[offs + vIdx++]);
                    if (vIdx < len) {
                        mem.put(j + 1, src[offs + vIdx++]);
                        break;
                    }
                    mem.put(j + 1, Dbcs.fillBA[0]);
                    break;
                }
                case 47: {
                    mem.put(j, Dbcs.slashBA[0]);
                    mem.put(j + 1, Dbcs.slashBA[1]);
                    break;
                }
                case 48: {
                    mem.put(j, Dbcs.zeroBA[0]);
                    mem.put(j + 1, Dbcs.zeroBA[1]);
                    break;
                }
                case 66: {
                    mem.put(j, Dbcs.fillBA[0]);
                    mem.put(j + 1, Dbcs.fillBA[1]);
                }
            }
            j += 2;
            ++pIdx;
        }
        return error && vIdx < len;
    }

    @Override
    void internalSet(CobolVar cv) {
        if (PictureAnalyzer.storeValueWithoutEdit) {
            this.editEnabled = false;
            super.internalSet(cv);
            this.editEnabled = true;
        } else {
            super.internalSet(cv);
        }
    }

    @Override
    public boolean set(Memory src, int offs, int len, boolean filling) {
        Memory mem = this.getMemory();
        boolean error = false;
        for (int k = this.curOffset; k < this.end; k += 2) {
            mem.put(k, Dbcs.fillBA[0]);
            mem.put(k + 1, Dbcs.fillBA[1]);
        }
        int vIdx = 0;
        int j = this.curOffset;
        int pIdx = 0;
        while (j < this.end) {
            int c = this.editEnabled ? this.picture[pIdx] : 78;
            switch (c) {
                case 57: {
                    if (vIdx < len) {
                        mem.put(j, src.get(offs + vIdx++));
                        if (vIdx < len) {
                            mem.put(j + 1, src.get(offs + vIdx++));
                            break;
                        }
                        mem.put(j + 1, Dbcs.zeroBA[0]);
                        break;
                    }
                    mem.put(j, Dbcs.zeroBA[0]);
                    mem.put(j + 1, Dbcs.zeroBA[1]);
                    break;
                }
                case 71: 
                case 78: {
                    if (vIdx >= len) break;
                    mem.put(j, src.get(offs + vIdx++));
                    if (vIdx < len) {
                        mem.put(j + 1, src.get(offs + vIdx++));
                        break;
                    }
                    mem.put(j + 1, Dbcs.fillBA[0]);
                    break;
                }
                case 47: {
                    mem.put(j, Dbcs.slashBA[0]);
                    mem.put(j + 1, Dbcs.slashBA[1]);
                    break;
                }
                case 48: {
                    mem.put(j, Dbcs.zeroBA[0]);
                    mem.put(j + 1, Dbcs.zeroBA[1]);
                    break;
                }
                case 66: {
                    mem.put(j, Dbcs.fillBA[0]);
                    mem.put(j + 1, Dbcs.fillBA[1]);
                }
            }
            j += 2;
            ++pIdx;
        }
        return error && vIdx < len;
    }

    @Override
    public void defaultInitialize() {
        this.setSpace();
    }

    @Override
    protected int getCategory() {
        return 3;
    }

    @Override
    protected void updateEnd() {
        this.end = this.getEnd();
    }

    @Override
    public String getPicture() {
        return new String(this.picture);
    }

    @Override
    public void enableEdit() {
        this.editEnabled = true;
    }

    @Override
    public void disableEdit() {
        this.editEnabled = false;
    }
}

