/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public final class Pic9Comp_2
extends NumericVar
implements SignEncOpt {
    private static final long serialVersionUID = 123L;
    int compOption = 0;
    byte POSITIVE = (byte)11;
    byte NEGATIVE = (byte)13;

    public Pic9Comp_2(Memory m, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(m, i, il, dl, signed, il + dl + (signed ? 1 : 0), dimSize, dim, name, pComma);
        this.compOption = opt;
        if (opt != 0) {
            this.POSITIVE = (byte)12;
        }
        if (m != null) {
            this.updateCache(m, this.theValue);
        }
    }

    public Pic9Comp_2(CobolVar par, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(par, i, il, dl, signed, il + dl + (signed ? 1 : 0), dimSize, dim, name, pComma);
        this.compOption = opt;
        if (opt != 0) {
            this.POSITIVE = (byte)12;
        }
    }

    private void putBDToMem(Memory mem, BigCobolDec _bcd) {
        BigCobolDec val = new BigCobolDec(_bcd);
        int i = this.end - 1;
        if (this.signed) {
            if (val.isNegative()) {
                mem.put(i--, this.NEGATIVE);
            } else {
                mem.put(i--, this.POSITIVE);
            }
        }
        while (i >= this.curOffset) {
            byte digit = val.getDecDigit(0);
            val.shift(-1);
            mem.put(i--, digit);
        }
    }

    private void putLongToMem(Memory mem, long val) {
        int i = this.end - 1;
        if (this.signed) {
            if (val < 0L) {
                val = -val;
                mem.put(i--, this.NEGATIVE);
            } else {
                mem.put(i--, this.POSITIVE);
            }
        }
        while (i >= this.curOffset) {
            byte digit = (byte)(val % 10L);
            val /= 10L;
            mem.put(i--, digit);
        }
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, (byte)0);
        if (this.signed) {
            mem.put(this.end - 1, this.POSITIVE);
        }
    }

    private void setByteArray(byte[] src, int srcLen, Memory mem) {
        int j;
        int dotIdx;
        boolean minus;
        int i = 0;
        if (src[0] == C_MINUS) {
            ++i;
            minus = this.signed;
        } else {
            minus = false;
        }
        for (dotIdx = 0; dotIdx < srcLen && src[dotIdx] != C_POINT; ++dotIdx) {
        }
        int temp = this.intLen - dotIdx + i;
        int n = j = temp < 0 ? this.curOffset : this.curOffset + temp;
        if (temp < 0) {
            i -= temp;
        }
        for (int k = this.curOffset; k < this.end; ++k) {
            mem.put(k, (byte)0);
        }
        while (i < srcLen && j < this.end) {
            if (i != dotIdx) {
                mem.put(j++, (byte)(src[i] - C_0));
            }
            ++i;
        }
        if (this.signed) {
            if (minus) {
                mem.put(this.end - 1, this.NEGATIVE);
            } else {
                mem.put(this.end - 1, this.POSITIVE);
            }
        }
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    private long getLongFromMem(Memory mem) {
        long Return2 = 0L;
        int i = this.end - 1;
        long decFact = 1L;
        boolean negative = this.myIsNegative();
        if (this.signed) {
            --i;
        }
        while (i >= this.curOffset) {
            Return2 += (long)mem.get(i) * decFact;
            decFact *= 10L;
            --i;
        }
        if (negative) {
            return -Return2;
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(Memory mem) {
        int i = this.end - 1;
        boolean negative = this.myIsNegative();
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        if (this.signed) {
            --i;
        }
        while (i >= this.curOffset) {
            cNum[--cnIdx] = (char)mem.get(i);
            --i;
        }
        return Pic9Comp_2.getBD(cNum, cnIdx, negative, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        Memory mem = this.getMemory();
        int en = this.end - (this.signed ? 2 : 1);
        for (int i = this.curOffset; i < en; ++i) {
            byte c = mem.get(i);
            if (c >= 0 && c <= 9) continue;
            return false;
        }
        return !this.signed || mem.get(this.end - 1) == this.POSITIVE || mem.get(this.end - 1) == this.NEGATIVE;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.myIsNegative();
    }

    private boolean myIsNegative() {
        return this.signed && this.getMemory().get(this.end - 1) == this.NEGATIVE;
    }
}

