/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolVar;
import java.io.Serializable;

public class ArrayCache
implements RuntimeErrorsNumbers,
Serializable {
    private static final long serialVersionUID = 123L;
    private static final int SIZE = Config.getProperty("iscobol.array_cache", 101);
    private static final int[] empty;
    final CobolVar[] cache;
    final int[] indexes;
    final int size;

    private ArrayCache(int dim) {
        this.size = dim < SIZE ? dim : SIZE;
        this.cache = new CobolVar[this.size];
        this.indexes = new int[this.size];
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public static ArrayCache getInstance(int dim) {
        return SIZE > 0 ? new ArrayCache(dim) : null;
    }

    public final void clear() {
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final CobolVar get(int idx) {
        int hash = (idx & Integer.MAX_VALUE) % this.size;
        if (this.indexes[hash] == idx) {
            return this.cache[hash];
        }
        return null;
    }

    public final void put(CobolVar c, int idx) {
        int hash = (idx & Integer.MAX_VALUE) % this.size;
        this.indexes[hash] = idx;
        this.cache[hash] = c;
    }

    static {
        if (SIZE > 0) {
            empty = new int[SIZE];
            for (int i = SIZE - 1; i >= 0; --i) {
                ArrayCache.empty[i] = -1;
            }
        } else {
            empty = null;
        }
    }
}

