/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.preview.Preview;
import com.iscobol.preview.PreviewDialog;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.rts.File;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.AttrTable;
import com.iscobol.rts.print.AutoHeaderFooter;
import com.iscobol.rts.print.CustomMediaSizeName;
import com.iscobol.rts.print.DrawGraph;
import com.iscobol.rts.print.PDF;
import com.iscobol.rts.print.Page;
import com.iscobol.rts.print.PrintAt;
import com.iscobol.rts.print.PrintBitmap;
import com.iscobol.rts.print.PrintBytes;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.rts.print.PrintNewLine;
import com.iscobol.rts.print.PrintString;
import com.iscobol.rts.print.RemotePrintCommand;
import com.iscobol.rts.print.SetBackground;
import com.iscobol.rts.print.SetBoxShade;
import com.iscobol.rts.print.SetColor;
import com.iscobol.rts.print.SetCursor;
import com.iscobol.rts.print.SetDataColumns;
import com.iscobol.rts.print.SetFont;
import com.iscobol.rts.print.SetGraphBrush;
import com.iscobol.rts.print.SetGraphPen;
import com.iscobol.rts.print.SetLinesPerPage;
import com.iscobol.rts.print.SetNewPage;
import com.iscobol.rts.print.SetOrientation;
import com.iscobol.rts.print.SetPageColumns;
import com.iscobol.types.CobolVar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.ImageIcon;

public class SpoolPrinter
extends OutputStream
implements Printable,
RuntimeErrorsNumbers {
    public static final float FONT_DEFAULT_HEIGHT = 12.0f;
    public static final float FONT_DEFAULT_ADVANCE = 7.0f;
    public static final int MU_DEFAULT = 0;
    public static final int MU_CELLS = 1;
    public static final int MU_INCHES = 2;
    public static final int MU_CENTIMETERS = 3;
    public static final int MU_PIXELS = 4;
    public static final int MU_CELLS_ABS = 5;
    public static final int MU_INCHES_ABS = 6;
    public static final int MU_CENTIMETERS_ABS = 7;
    public static final float MARGIN_TOP_DEF_CM = 0.0f;
    public static final float MARGIN_BOTTOM_DEF_CM = 0.0f;
    public static final float MARGIN_LEFT_DEF_CM = 0.0f;
    public static final float MARGIN_RIGHT_DEF_CM = 0.0f;
    public static final float MARGIN_CMxINCH = 2.54f;
    public static final float DOTxINCH = 72.0f;
    public static final float DOTxCM = 28.346457f;
    public static final int OR_DEFAULT = 0;
    public static final int OR_PORTRAIT = 1;
    public static final int OR_LANDSCAPE = 2;
    public static final int OR_REVERSE_PORTRAIT = 3;
    public static final int OR_REVERSE_LANDSCAPE = 4;
    public static final int QU_UNKNOWN = 0;
    public static final int QU_HIGH = -1;
    public static final int QU_MEDIUM = -2;
    public static final int QU_LOW = -3;
    public static final int QU_DRAFT = -4;
    public static final int CO_UNKNOWN = -1;
    public static final int CO_MONOCHROME = 0;
    public static final int CO_COLOR = 1;
    public static final int CL_UNCOLLATED = 0;
    public static final int CL_COLLATED = 1;
    public static final int CAPSIDX_HOR_SIZE = 0;
    public static final int CAPSIDX_VER_SIZE = 1;
    public static final int CAPSIDX_HOR_OFFS = 2;
    public static final int CAPSIDX_VER_OFFS = 3;
    public static final int CAPSIDX_HOR_RES_DPI = 4;
    public static final int CAPSIDX_VER_RES_DPI = 5;
    public static final int CAPSIDX_CURR_UNITS = 6;
    public static final int CAPSIDX_MY_SIZE = 7;
    public static final int DUPLEX_UNSET = 0;
    public static final int DUPLEX_SIMPLEX = 1;
    public static final int DUPLEX_VERTICAL = 2;
    public static final int DUPLEX_HORIZONTAL = 3;
    static final char eolCh = '\n';
    static final char eopCh = '\f';
    static final String searchpreviewname = "print-preview";
    private static final String DUMMY_PRINT_CANCELED = "$Dummy print canceled$";
    private static final Class win32mt;
    private static final int javaMajorVersion;
    private static final MediaTray[] mediaTrays;
    private static final MediaSizeName[] mediaSizes;
    private static Setting staticSetting;
    private static PreviewDialogSettings prDialogSettings;
    private static final String jobName = "Iscobol job";
    private static StreamPrintServiceFactory sps;
    private final byte defaultTxtAlign = (byte)2;
    protected Events events;
    protected Setting setting;
    private MediaSize customPdfMediaSize;
    private boolean rmCompat;
    private byte nextTxtAlign = (byte)2;
    private double leftMargin;
    private double topMargin;
    private double rightMargin;
    private double bottomMargin;
    private boolean preview;
    private boolean direct;
    private boolean pdf;
    private boolean binary;
    private String fileName;
    private boolean openFileChooser;
    private java.io.File tmpFile;
    private Writer out;
    private OutputStream binOut;
    private PrintCommandList allCommands;
    private Vector<Page> pages;
    private String[] header;
    private String[] footer;
    private Font headerFooterFont;
    private AutoHeaderFooter aHeadFoot;
    private String reportName;
    PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    private PrintRequestAttributeSet asetSave;
    PrintService[] services;
    private Font currFont;
    AttrTable genericAttrs = new AttrTable();
    private int numLines = -1;
    private int initialOrientation = -1;
    private boolean printed;
    private boolean jobCancelled;
    protected AbstractGuiFactoryImpl gf;
    Vector<RemotePrintCommand> notYetExecutedCommands = new Vector();

    public static void main(String[] argv) {
        System.out.println(mediaSizes[70]);
        System.out.println(mediaTrays[13]);
    }

    private static MediaTray getWinMediaTray(String name) {
        if (win32mt != null) {
            try {
                Field f = win32mt.getDeclaredField(name);
                f.setAccessible(true);
                return (MediaTray)f.get(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static SpoolPrinter get(GuiFactory gf) {
        if (staticSetting == null) {
            staticSetting = new Setting();
        }
        SpoolPrinter Return2 = new SpoolPrinter(gf, staticSetting.copy());
        Return2.init();
        if (prDialogSettings.getTitle() == null) {
            SpoolPrinter.setDialogTitle(((AbstractGuiFactoryImpl)gf).getCsProperty().get("iscobol.print.preview.title", null));
        }
        if (prDialogSettings.getIconImage() == null) {
            AbstractGuiFactoryImpl agf = (AbstractGuiFactoryImpl)gf;
            LocalImage im = agf.getPrintPreviewIconImage();
            if (im != null && im.getImage() != null) {
                prDialogSettings.setIconImage(im.getImage());
            } else if (agf.getIcon() != null) {
                prDialogSettings.setIconImage(agf.getIcon());
            } else {
                prDialogSettings.setIconImage(null);
            }
        }
        return Return2;
    }

    public static SpoolPrinter get(GuiFactory gf, boolean preview, boolean direct, boolean pdf, String fileName, boolean binary) {
        return SpoolPrinter.get(gf, preview, direct, pdf, fileName, binary, null);
    }

    public static SpoolPrinter get(GuiFactory gf, boolean preview, boolean direct, boolean pdf, String fileName, boolean binary, Events events) {
        SpoolPrinter Return2 = SpoolPrinter.get(gf);
        if ("PRINTER?".equalsIgnoreCase(fileName)) {
            Return2.rmCompat = true;
        }
        Return2.events = events;
        Return2.setAttrs(preview, direct, pdf, fileName, binary);
        return Return2;
    }

    protected SpoolPrinter(GuiFactory gf) {
        this(gf, null);
    }

    private SpoolPrinter(GuiFactory gf, Setting s) {
        this.gf = (AbstractGuiFactoryImpl)gf;
        this.setDefaultFont();
        this.allCommands = new PrintCommandList(gf);
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
        if (s != null) {
            this.setting = s;
        } else {
            s = (Setting)IscobolSystem.get(Setting.class);
            if (s == null) {
                this.setting = new Setting();
                IscobolSystem.set(Setting.class, this.setting);
            } else {
                this.setting = s;
            }
        }
    }

    private void setDefaultFont() {
        String defFont;
        if (this.gf != null && (defFont = this.gf.getCsProperty().get("iscobol.print.default_font", null)) != null) {
            Object[] ret = IsguiUtility.parseFontString(defFont);
            this.currFont = new Font((String)ret[0], (int)((Integer)ret[1]), 12).deriveFont(((Float)ret[2]).floatValue());
        } else {
            this.currFont = Font.decode(null);
        }
    }

    public AbstractGuiFactoryImpl getGuiFactory() {
        return this.gf;
    }

    public void setAttrs(SpoolPrinter sp) {
        this.notYetExecutedCommands.addAll(sp.notYetExecutedCommands);
        this.setting = sp.setting.copy();
        this.nextTxtAlign = sp.nextTxtAlign;
        this.leftMargin = sp.leftMargin;
        this.rightMargin = sp.rightMargin;
        this.topMargin = sp.topMargin;
        this.bottomMargin = sp.bottomMargin;
        this.currFont = sp.currFont;
        this.customPdfMediaSize = sp.customPdfMediaSize;
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
        this.aset = new HashPrintRequestAttributeSet(sp.aset);
        this.genericAttrs = new AttrTable(sp.genericAttrs);
        this.numLines = sp.numLines;
        this.initialOrientation = sp.initialOrientation;
        if (this.numLines >= 0) {
            this.addCommand(new SetLinesPerPage((GuiFactory)this.gf, this.numLines));
        }
    }

    protected void setAttrs(boolean preview, boolean direct, boolean pdf, String fileName, boolean binary) {
        this.preview = preview;
        this.direct = direct;
        this.pdf = pdf;
        this.binary = binary;
        this.setFileName(fileName);
    }

    private void setFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            this.openFileChooser = false;
            this.fileName = "iscobolPrint.pdf";
        } else if (fileName.charAt(0) == '@') {
            this.openFileChooser = true;
            this.fileName = fileName.substring(1).trim();
        } else {
            this.openFileChooser = false;
            this.fileName = fileName;
        }
    }

    public void reset() {
        this.aset = new HashPrintRequestAttributeSet();
        this.setting.currOrientation = OrientationRequested.PORTRAIT;
        this.setting.currMediaSizeName = SpoolPrinter.getDefaultLocaleMediaSizeName();
        this.setting.currQuality = null;
        this.setting.currentPrinter = null;
        this.customPdfMediaSize = null;
        this.init();
    }

    protected void init() {
        this.aset.add(this.setting.currOrientation);
        this.aset.add(new Copies(1));
        this.aset.add(new JobName(jobName, null));
        if (this.setting.currMediaSizeName != null) {
            this.aset.add(this.setting.currMediaSizeName);
        }
        this.setMargins(0.0, 0.0, 0.0, 0.0, 3);
        if (this.setting.currQuality != null) {
            this.aset.add(this.setting.currQuality);
        }
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        this.setting.currentPrinter = null;
        this.setGraphPen(0, 1.0, null);
        this.initialOrientation = -1;
    }

    protected PrintService getDefaultPrinter() {
        PrintService defaultPrinter = SpoolPrinter.lookupDefaultPrintService();
        if (defaultPrinter == null && this.services != null && this.services.length > 0) {
            defaultPrinter = this.services[0];
        }
        return defaultPrinter;
    }

    public void updatePrinters() {
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        if (this.setting.currentPrinter != null) {
            int i;
            for (i = 0; i < this.services.length && this.setting.currentPrinter != this.services[i]; ++i) {
            }
            if (i == this.services.length) {
                this.setting.currentPrinter = null;
            }
        }
    }

    static PrintService lookupDefaultPrintService() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        try {
            pj.setPrintable(null);
            return pj.getPrintService();
        }
        catch (Exception ex) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
    }

    private void fakePrint(PrinterJob pj, Printable prn) {
        this.fakePrint(pj, prn, null);
    }

    private void fakePrint(PrinterJob pj, Printable prn, Pageable pg) {
        PrintService printer;
        if (sps == null) {
            StreamPrintServiceFactory[] a = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(DocFlavor.SERVICE_FORMATTED.PAGEABLE, "application/postscript");
            if (a != null && a.length > 0) {
                sps = a[0];
                printer = sps.getPrintService(new ByteArrayOutputStream());
            } else {
                printer = this.getCurrPrintService();
            }
        } else {
            printer = sps.getPrintService(new ByteArrayOutputStream());
        }
        if (prn != null) {
            pj.setPrintable(prn);
        } else {
            pj.setPageable(pg);
        }
        try {
            SpoolPrinter.setPrintService(pj, printer);
            pj.print(this.aset);
        }
        catch (PrinterException ex) {
            if (ex.getMessage().indexOf(DUMMY_PRINT_CANCELED) < 0) {
                ex.printStackTrace();
            }
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof PrinterException) {
                if (cause.getMessage().indexOf(DUMMY_PRINT_CANCELED) < 0) {
                    cause.printStackTrace();
                }
            }
            throw ex;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.printAndClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOException printAndClose() {
        IOException Return2 = null;
        this.numLines = -1;
        if (this.direct) {
            this.closeDirect();
        } else {
            try {
                if (!this.jobCancelled) {
                    Preview p = null;
                    if (!this.preview || (p = this.printPreview()).isDoPrint()) {
                        if (this.pdf) {
                            this.printPDF();
                        } else if (p != null && p.isDoPdf()) {
                            this.printPDF(p.getFilename());
                        } else {
                            PrinterJob pj = PrinterJob.getPrinterJob();
                            PrintService currPrinter = this.getCurrPrintService();
                            if (currPrinter != null) {
                                PageFormat pf = this.buildPageFormat(this.initialOrientation);
                                SpoolPrinter.setPrintService(pj, currPrinter);
                                pf = pj.validatePage(pf);
                                pj.setPageable(new MyPageable(this, pf));
                                pj.print(this.aset);
                            }
                        }
                    }
                }
            }
            catch (PrinterException ex) {
                Return2 = new IOException("" + ex);
            }
            catch (IOException ex) {
                Return2 = ex;
            }
            finally {
                this.printed = true;
                this.pages = null;
                this.initialOrientation = -1;
                this.allCommands.finalize();
                this.allCommands = new PrintCommandList(this.gf);
            }
            this.restorePrintRequestAttributeSet();
        }
        return Return2;
    }

    private static void setPrintService(PrinterJob pj, PrintService ps) {
        try {
            pj.setPrintService(ps);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    protected void addCommand(PrintCommand cmd) {
        this.allCommands.addItem(cmd);
    }

    private void newLine() {
        this.addCommand(new PrintNewLine(this.gf));
    }

    public void newPage() {
        this.addCommand(new SetNewPage(this.gf));
    }

    public void textOut(byte[] b, int offs, int len) {
        if (this.direct) {
            this.writeDirect(b);
        } else {
            this.addCommand(new PrintBytes(this.gf, b, offs, len, this.rmCompat ? (byte)this.nextTxtAlign : (byte)2));
            this.nextTxtAlign = (byte)2;
        }
    }

    public void printAt(String s, float x, float y, float w, boolean rpos, char algn, byte ys, boolean clp) {
        if (this.direct) {
            this.writeDirect(s.toCharArray());
        } else {
            this.addCommand(new PrintAt(this.gf, s, x, y, w, rpos, algn, ys, clp));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.direct) {
            this.writeDirect(b, off, len);
        } else {
            char[] c = new char[len];
            for (int i = 0; i < len; ++i) {
                c[i] = (char)b[i];
            }
            this.write(c, off, len);
        }
    }

    public void write(byte b) {
        if (this.direct) {
            this.writeDirect(b);
        } else {
            this.write(new byte[]{b}, 0, 1);
        }
    }

    @Override
    public void write(int ch) {
        if (this.direct) {
            this.writeDirect(ch);
        } else {
            this.write(new char[]{(char)ch}, 0, 1);
        }
    }

    @Override
    public void write(byte[] b) {
        if (this.direct) {
            this.writeDirect(b);
        } else {
            this.write(b, 0, b.length);
        }
    }

    public void write(char[] b) {
        if (this.direct) {
            this.writeDirect(b);
        } else {
            this.write(b, 0, b.length);
        }
    }

    public void write(char[] b, int off, int len) {
        if (this.direct) {
            this.writeDirect(b, off, len);
        } else {
            byte yoffs = this.rmCompat ? (byte)3 : 2;
            StringBuffer buf = new StringBuffer();
            int end = off + len;
            while (off < end) {
                switch (b[off]) {
                    case '\n': {
                        if (buf.length() > 0) {
                            this.addCommand(new PrintString((GuiFactory)this.gf, buf.toString(), yoffs));
                            buf = new StringBuffer();
                        }
                        this.newLine();
                        break;
                    }
                    case '\f': {
                        if (buf.length() > 0) {
                            this.addCommand(new PrintString((GuiFactory)this.gf, buf.toString(), yoffs));
                            buf = new StringBuffer();
                        }
                        this.newPage();
                        break;
                    }
                    default: {
                        buf.append(b[off]);
                    }
                }
                ++off;
            }
            if (buf.length() > 0) {
                this.addCommand(new PrintString((GuiFactory)this.gf, buf.toString(), yoffs));
            }
        }
    }

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.direct) {
            char[] chars = new String(b, off, len, CobolVar.encoding).toCharArray();
            this.writeDirect(chars, 0, chars.length);
        } else {
            byte[] l;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte yoffs = this.rmCompat ? (byte)3 : 2;
            int end = off + len;
            while (off < end) {
                switch (b[off]) {
                    case 10: {
                        if (baos.size() > 0) {
                            l = baos.toByteArray();
                            this.addCommand(new PrintBytes(this.gf, l, 0, l.length, yoffs));
                            baos.close();
                            baos = new ByteArrayOutputStream();
                        }
                        this.newLine();
                        break;
                    }
                    case 12: {
                        if (baos.size() > 0) {
                            l = baos.toByteArray();
                            this.addCommand(new PrintBytes(this.gf, l, 0, l.length, yoffs));
                            baos.close();
                            baos = new ByteArrayOutputStream();
                        }
                        this.newPage();
                        break;
                    }
                    default: {
                        baos.write(b[off]);
                    }
                }
                ++off;
            }
            if (baos.size() > 0) {
                l = baos.toByteArray();
                this.addCommand(new PrintBytes(this.gf, l, 0, l.length, yoffs));
            }
            baos.close();
        }
    }

    public double[] setup(double top, double bottom, double left, double right) throws IOException {
        double[] Return2 = new double[]{};
        MediaPrintableArea mpa = (MediaPrintableArea)this.aset.get(MediaPrintableArea.class);
        this.aset.add(this.getMediaPrintableArea(this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        boolean ok = this.setup();
        if (ok) {
            Attribute attr = this.aset.get(MediaPrintableArea.class);
            if (!(attr instanceof MediaPrintableArea)) {
                return Return2;
            }
            MediaPrintableArea mpa2 = (MediaPrintableArea)attr;
            Size2DSyntax ms = this.getMediaSize();
            attr = this.aset.get(OrientationRequested.class);
            if (!(attr instanceof OrientationRequested)) {
                return Return2;
            }
            boolean orientation = attr != OrientationRequested.LANDSCAPE && attr != OrientationRequested.REVERSE_LANDSCAPE;
            float width = ms.getX(25400);
            float height = ms.getY(25400);
            float imageableX = mpa2.getX(25400);
            float imageableY = mpa2.getY(25400);
            float imageableWidth = mpa2.getWidth(25400);
            float imageableHeight = mpa2.getHeight(25400);
            Return2 = new double[]{(double)orientation, orientation ? (double)width : (double)height, orientation ? (double)height : (double)width, imageableY, height - imageableY - imageableHeight, imageableX, width - imageableWidth - imageableX};
            this.setMargins(this.aset);
        } else if (mpa != null) {
            this.aset.add(mpa);
        }
        return Return2;
    }

    public boolean setup() {
        KeyboardBuffer.setBufferOff();
        boolean Return2 = false;
        PrinterJob pj = PrinterJob.getPrinterJob();
        SpoolPrinter.setPrintService(pj, this.getCurrPrintService());
        boolean ok = pj.printDialog(this.aset);
        KeyboardBuffer.setBufferOn();
        Media msn = (Media)this.aset.get(Media.class);
        if (msn != null && msn instanceof MediaSizeName) {
            this.setting.currMediaSizeName = (MediaSizeName)msn;
        }
        if (ok) {
            this.setting.currentPrinter = pj.getPrintService();
            Return2 = true;
        } else {
            Return2 = false;
        }
        return Return2;
    }

    public void setMargins(PrintRequestAttributeSet aset) {
        MediaPrintableArea mpa = (MediaPrintableArea)aset.get(MediaPrintableArea.class);
        Size2DSyntax ms = this.getMediaSize();
        float width = ms.getX(25400);
        float height = ms.getY(25400);
        float left = mpa.getX(25400);
        float top = mpa.getY(25400);
        float imageableWidth = mpa.getWidth(25400);
        float imageableHeight = mpa.getHeight(25400);
        float right = width - imageableWidth - left;
        float bottom = height - imageableHeight - top;
        if (aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE) {
            this.setMargins(left, right, bottom, top, 2);
        } else {
            this.setMargins(top, bottom, left, right, 2);
        }
    }

    private int[] getMaxResolution() {
        int[] Return2;
        PrintService currPrinter = this.getCurrPrintService();
        PrinterResolution[] sr = currPrinter != null ? (PrinterResolution[])currPrinter.getSupportedAttributeValues(PrinterResolution.class, null, null) : null;
        if (sr != null && sr.length > 0) {
            Return2 = sr[0].getResolution(100);
            int max = Return2[0] * Return2[1];
            for (int i = 1; i < sr.length; ++i) {
                int[] res = sr[i].getResolution(100);
                if (res[0] * res[1] <= max) continue;
                Return2 = res;
                max = res[0] * res[1];
            }
        } else {
            Return2 = new int[]{600, 600};
        }
        return Return2;
    }

    public int[] getCurrPrinterCapabilities() {
        int[] Return2 = new int[7];
        Return2[6] = this.setting.currUnits;
        PrintService s = this.getCurrPrintService();
        if (s != null) {
            MediaPrintableArea[] mpas = (MediaPrintableArea[])s.getSupportedAttributeValues(MediaPrintableArea.class, null, null);
            if (mpas != null) {
                double max = 0.0;
                for (int i = 0; i < mpas.length; ++i) {
                    float y;
                    float x;
                    if (mpas[i] == null || !((double)((x = mpas[i].getWidth(1000)) * (y = mpas[i].getHeight(1000))) > max)) continue;
                    Return2[0] = (int)x;
                    Return2[1] = (int)y;
                    Return2[2] = (int)mpas[i].getX(1000);
                    Return2[3] = (int)mpas[i].getY(1000);
                    max = x * y;
                }
            }
            int[] res = this.getMaxResolution();
            Return2[4] = res[0];
            Return2[5] = res[1];
        }
        return Return2;
    }

    public int getNoPrinters() {
        if (this.services != null) {
            return this.services.length;
        }
        return 0;
    }

    public int getCurrPrinter() {
        PrintService s = this.getCurrPrintService();
        for (int i = 0; i < this.services.length; ++i) {
            if (!this.services[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public PrintService getCurrPrintService() {
        return this.setting.currentPrinter != null ? this.setting.currentPrinter : this.getDefaultPrinter();
    }

    public int getPrinterNumber(String s) {
        for (int i = 0; i < this.services.length; ++i) {
            if (!this.services[i].getName().equals(s)) continue;
            return i;
        }
        return -1;
    }

    public boolean setPrinter(int nr) {
        if (nr >= 0 && nr < this.services.length) {
            this.setting.currentPrinter = this.services[nr];
            this.numLines = -1;
            return true;
        }
        return false;
    }

    public boolean setPrinter(String s) {
        return this.setPrinter(this.getPrinterNumber(s));
    }

    public void setOrientation(int or) {
        int pfor = 1;
        switch (or) {
            case 1: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.PORTRAIT);
                pfor = 1;
                break;
            }
            case 2: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.LANDSCAPE);
                pfor = 0;
                break;
            }
            case 3: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.REVERSE_PORTRAIT);
                pfor = 1;
                break;
            }
            case 4: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.REVERSE_LANDSCAPE);
                pfor = 2;
            }
        }
        this.addCommand(new SetOrientation((GuiFactory)this.gf, or));
        if (this.initialOrientation < 0) {
            this.initialOrientation = pfor;
        }
    }

    public int getOrientation() {
        if (this.setting.currOrientation == OrientationRequested.LANDSCAPE) {
            return 2;
        }
        if (this.setting.currOrientation == OrientationRequested.REVERSE_LANDSCAPE) {
            return 4;
        }
        if (this.setting.currOrientation == OrientationRequested.REVERSE_PORTRAIT) {
            return 3;
        }
        return 1;
    }

    public void setQuality(int qu) {
        switch (qu) {
            case -1: {
                this.aset.add(this.setting.currQuality = PrintQuality.HIGH);
                break;
            }
            case -2: {
                this.aset.add(this.setting.currQuality = PrintQuality.NORMAL);
                break;
            }
            case -4: 
            case -3: {
                this.aset.add(this.setting.currQuality = PrintQuality.DRAFT);
            }
        }
    }

    public int getQuality() {
        PrintQuality pq = (PrintQuality)this.aset.get(PrintQuality.class);
        if (pq == PrintQuality.HIGH) {
            return -1;
        }
        if (pq == PrintQuality.NORMAL) {
            return -2;
        }
        if (pq == PrintQuality.DRAFT) {
            return -4;
        }
        return 0;
    }

    public String getPrinterName(int idx) {
        if (idx >= 0 && this.services != null && idx < this.services.length) {
            return this.services[idx].getName();
        }
        return "";
    }

    public String getPrinterURI(int idx) {
        PrinterURI psa;
        if (idx >= 0 && this.services != null && idx < this.services.length && (psa = this.services[idx].getAttribute(PrinterURI.class)) != null) {
            return ((Object)psa).toString();
        }
        return "";
    }

    public int getColorSupport(int idx) {
        ColorSupported psa;
        if (idx >= 0 && this.services != null && idx < this.services.length && (psa = this.services[idx].getAttribute(ColorSupported.class)) != null) {
            if (psa == ColorSupported.SUPPORTED) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public void setChromaticity(int co) {
        switch (co) {
            case 1: {
                this.aset.add(Chromaticity.COLOR);
                break;
            }
            case 0: {
                this.aset.add(Chromaticity.MONOCHROME);
            }
        }
    }

    public int getChromaticity() {
        Chromaticity chro = (Chromaticity)this.aset.get(Chromaticity.class);
        if (chro == Chromaticity.COLOR) {
            return 1;
        }
        if (chro == Chromaticity.MONOCHROME) {
            return 0;
        }
        return -1;
    }

    public int getCurrOrientation() {
        this.setting.currOrientation = (OrientationRequested)this.aset.get(OrientationRequested.class);
        if (this.setting.currOrientation != null) {
            if (this.setting.currOrientation == OrientationRequested.PORTRAIT) {
                return 1;
            }
            if (this.setting.currOrientation == OrientationRequested.LANDSCAPE) {
                return 2;
            }
            if (this.setting.currOrientation == OrientationRequested.REVERSE_PORTRAIT) {
                return 3;
            }
            if (this.setting.currOrientation == OrientationRequested.REVERSE_LANDSCAPE) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public void setCollate(int cl) {
        switch (cl) {
            case 1: {
                this.aset.add(SheetCollate.COLLATED);
                break;
            }
            case 0: {
                this.aset.add(SheetCollate.UNCOLLATED);
            }
        }
    }

    public int getCollate() {
        SheetCollate sc = (SheetCollate)this.aset.get(SheetCollate.class);
        if (sc != null && SheetCollate.COLLATED.equals(sc)) {
            return 1;
        }
        return 0;
    }

    public int getCurrCopies() {
        Copies c = (Copies)this.aset.get(Copies.class);
        if (c != null) {
            return c.getValue();
        }
        return 0;
    }

    public void setCurrCopies(int n) {
        this.aset.add(new Copies(n > 0 ? n : 1));
    }

    public boolean hasDuplexPrinting() {
        PrintService currPrinter = this.getCurrPrintService();
        return currPrinter != null && (currPrinter.isAttributeValueSupported(Sides.DUPLEX, null, null) || currPrinter.isAttributeValueSupported(Sides.TUMBLE, null, null));
    }

    public void setDuplexPrinting(int dp) {
        switch (dp) {
            case 1: {
                this.aset.add(Sides.ONE_SIDED);
                break;
            }
            case 2: {
                this.aset.add(Sides.DUPLEX);
                break;
            }
            case 3: {
                this.aset.add(Sides.TUMBLE);
            }
        }
    }

    public int getDuplexPrinting() {
        Attribute sd = this.aset.get(Sides.class);
        if (sd == Sides.DUPLEX) {
            return 2;
        }
        if (sd == Sides.TUMBLE) {
            return 3;
        }
        if (sd == Sides.ONE_SIDED) {
            return 1;
        }
        return 0;
    }

    public boolean isPrinterDefault(int idx) {
        boolean Return2;
        try {
            Return2 = this.getDefaultPrinter().equals(this.services[idx]);
        }
        catch (Exception e) {
            Return2 = false;
        }
        return Return2;
    }

    protected Font getFont(Map attrs) {
        if (javaMajorVersion >= 21 && "Courier".equals(attrs.get(TextAttribute.FAMILY))) {
            attrs.put(TextAttribute.FAMILY, "Monospaced");
        }
        return new Font(attrs);
    }

    protected Font getFont(int fontId) {
        Object lfcmp = this.gf.getClient().getId(fontId);
        if (lfcmp instanceof LocalFontCmp) {
            return ((LocalFontCmp)lfcmp).getFont();
        }
        return null;
    }

    public Hashtable getFontMetrics(Hashtable attrs) {
        Font font = attrs != null ? this.getFont(FontAttribute.convertToTextAttributes(attrs)) : this.currFont;
        Hashtable Return2 = FontAttribute.convertFromTextAttributes(font.getAttributes());
        if (Return2.get(FontAttribute.FAMILY) == null) {
            Return2.put(FontAttribute.FAMILY, font.getFamily());
        }
        if (Return2.get(FontAttribute.SIZE) == null) {
            Return2.put(FontAttribute.SIZE, new Float(font.getSize()));
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        Printable prn = (g, pf, pageIndex) -> {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            if (fm.charWidth('W') == fm.charWidth('i')) {
                Return2.put(FontAttribute.PITCHFIXED, FontAttribute.PITCHFIXED_ON);
            }
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout lo = new TextLayout("xxxxxxxxxx", g2d.getFont(), frc);
            Return2.put(FontAttribute.ASCENT, new Float(lo.getAscent()));
            Return2.put(FontAttribute.DESCENT, new Float(lo.getDescent()));
            Return2.put(FontAttribute.LEADING, new Float(lo.getLeading()));
            Return2.put(FontAttribute.AVEWIDTH, new Float(lo.getAdvance() / 10.0f));
            Return2.put(FontAttribute.MAXWIDTH, new Float(fm.getMaxAdvance()));
            pj.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(pj, prn);
        return Return2;
    }

    public void setPitch(char type, float factor) {
        switch (type) {
            case 'c': 
            case 'e': 
            case 'n': {
                break;
            }
            default: {
                return;
            }
        }
        if (this.currFont == null) {
            this.setDefaultFont();
        }
        Map<TextAttribute, ?> attrs = this.currFont.getAttributes();
        switch (type) {
            case 'n': {
                attrs.remove(TextAttribute.TRANSFORM);
                break;
            }
            case 'c': {
                if (factor <= 0.0f) {
                    factor = 1.65f;
                }
                if (factor == 1.0f) break;
                Object oldtr = attrs.get(TextAttribute.TRANSFORM);
                AffineTransform tr = oldtr instanceof TransformAttribute ? ((TransformAttribute)oldtr).getTransform() : (oldtr instanceof AffineTransform ? (AffineTransform)oldtr : new AffineTransform());
                tr.scale(1.0f / factor, 1.0f / factor);
                attrs.put(TextAttribute.TRANSFORM, tr);
                break;
            }
            case 'e': {
                if (factor <= 0.0f) {
                    factor = 2.0f;
                }
                if (factor == 1.0f) break;
                Object oldtr = attrs.get(TextAttribute.TRANSFORM);
                AffineTransform tr = oldtr instanceof TransformAttribute ? ((TransformAttribute)oldtr).getTransform() : (oldtr instanceof AffineTransform ? (AffineTransform)oldtr : new AffineTransform());
                tr.scale(factor, factor);
                attrs.put(TextAttribute.TRANSFORM, tr);
            }
        }
        this.currFont = this.getFont(attrs);
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setFont(Map attrs) {
        if (attrs == null) {
            this.setDefaultFont();
        } else {
            this.currFont = this.getFont(attrs);
        }
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setFont(int fontId) {
        this.setFont(this.getFont(fontId));
    }

    protected void setFont(Font font) {
        if (font == null) {
            this.setDefaultFont();
        } else {
            this.currFont = font;
        }
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.addCommand(new SetColor((GuiFactory)this.gf, new Color(red, green, blue, alpha)));
    }

    public void setBackground(int red, int green, int blue, int alpha) {
        if (red == 255 && green == 255 && blue == 255 || alpha == 0) {
            this.addCommand(new SetBackground((GuiFactory)this.gf, (Color)null));
        } else {
            this.addCommand(new SetBackground((GuiFactory)this.gf, new Color(red, green, blue, alpha)));
        }
    }

    public void setLinesPerPage(int lines) {
        if (lines == 0) {
            this.numLines = -1;
            this.getPageLayout(null);
            lines = this.numLines;
        } else {
            this.numLines = lines;
        }
        this.addCommand(new SetLinesPerPage((GuiFactory)this.gf, lines));
    }

    public void printBitmap(int imageId, double row, double col, int locType, double height, double width, int sizeType) {
        Object obj = this.gf.getClient().getId(imageId);
        this.printBitmap(obj instanceof LocalImage ? ((LocalImage)obj).getImage() : null, row, col, locType, height, width, sizeType);
    }

    protected void printBitmap(Image image, double row, double col, int locType, double height, double width, int sizeType) {
        if (image != null) {
            boolean locCells = false;
            boolean sizeCells = false;
            if (locType == 0) {
                locType = this.setting.currUnits;
            }
            switch (locType) {
                case 2: {
                    row *= 72.0;
                    col *= 72.0;
                    break;
                }
                case 3: {
                    row *= 28.34645652770996;
                    col *= 28.34645652770996;
                    break;
                }
                case 1: {
                    locCells = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("printBitmap:Type " + locType + " not supported!");
                }
            }
            if (sizeType == 0) {
                sizeType = this.setting.currUnits;
            }
            switch (sizeType) {
                case 2: {
                    width *= 72.0;
                    height *= 72.0;
                    break;
                }
                case 3: {
                    width *= 28.34645652770996;
                    height *= 28.34645652770996;
                    break;
                }
                case 1: {
                    sizeCells = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (width == 0.0 || height == 0.0) break;
                    System.err.println("printBitmap:Type " + sizeType + " not supported!");
                }
            }
            this.addCommand(new PrintBitmap(this.gf, this.allCommands.locHandles, image, row, col, locCells, height, width, sizeCells));
        }
    }

    public void drawGraph(int shape, double startX, double startY, double stopX, double stopY, int type, String shade) {
        boolean cells = false;
        if (type == 0) {
            type = this.setting.currUnits;
        }
        switch (type) {
            case 2: {
                startX *= 72.0;
                startY *= 72.0;
                stopX *= 72.0;
                stopY *= 72.0;
                break;
            }
            case 6: {
                startX = startX * 72.0 - this.leftMargin;
                startY = startY * 72.0 - this.topMargin;
                stopX = stopX * 72.0 - this.leftMargin;
                stopY = stopY * 72.0 - this.topMargin;
                break;
            }
            case 3: {
                startX *= 28.34645652770996;
                startY *= 28.34645652770996;
                stopX *= 28.34645652770996;
                stopY *= 28.34645652770996;
                break;
            }
            case 7: {
                startX = startX * 28.34645652770996 - this.leftMargin;
                startY = startY * 28.34645652770996 - this.topMargin;
                stopX = stopX * 28.34645652770996 - this.leftMargin;
                stopY = stopY * 28.34645652770996 - this.topMargin;
                break;
            }
            case 1: {
                cells = true;
                break;
            }
            case 4: {
                break;
            }
            default: {
                System.err.println("drawGraph:Type " + type + " not supported!");
            }
        }
        this.addCommand(new DrawGraph(this.gf, shape, startX, startY, stopX, stopY, cells, shade));
    }

    public void setCursor(double startX, double startY, double[] stopX, double[] stopY, int type, int shape, byte txtAlign) {
        boolean prevCells;
        boolean cells = false;
        this.nextTxtAlign = txtAlign == 0 ? (byte)2 : (byte)(txtAlign == 0 ? 2 : (int)txtAlign);
        if (type == 0) {
            type = this.setting.currUnits;
        }
        switch (type) {
            case 2: {
                startX *= 72.0;
                startY *= 72.0;
                break;
            }
            case 6: {
                startX = startX * 72.0 - this.leftMargin;
                startY = startY * 72.0 - this.topMargin;
                break;
            }
            case 3: {
                startX *= 28.34645652770996;
                startY *= 28.34645652770996;
                break;
            }
            case 7: {
                startX = startX * 28.34645652770996 - this.leftMargin;
                startY = startY * 28.34645652770996 - this.topMargin;
                break;
            }
            case 1: {
                cells = true;
                break;
            }
            case 4: {
                break;
            }
            default: {
                System.err.println("setCursor:Type " + type + " not supported!");
            }
        }
        if (shape == 0) {
            SetCursor cmd = new SetCursor(this.gf, startX, startY, cells);
            this.addCommand(cmd);
            stopX[0] = cmd.getPrevX();
            stopY[0] = cmd.getPrevY();
            prevCells = cmd.getPrevCells();
        } else {
            stopX[0] = SetCursor.getLastX();
            stopY[0] = SetCursor.getLastY();
            prevCells = SetCursor.getLastCells();
        }
        if (!(cells | prevCells)) {
            switch (type) {
                case 2: {
                    stopX[0] = stopX[0] / 72.0;
                    stopY[0] = stopY[0] / 72.0;
                    break;
                }
                case 6: {
                    stopX[0] = stopX[0] / 72.0 + this.leftMargin;
                    stopY[0] = stopY[0] / 72.0 + this.topMargin;
                    break;
                }
                case 3: {
                    stopX[0] = stopX[0] / 28.34645652770996 + this.leftMargin;
                    stopY[0] = stopY[0] / 28.34645652770996 + this.topMargin;
                    break;
                }
                case 1: {
                    cells = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("setCursor2:Type " + type + " not supported!");
                }
            }
        }
    }

    public void setGraphPenPt(int style, double width, Color color) {
        this.addCommand(new SetGraphPen(this.gf, style, width, color));
    }

    public void setGraphPen(int style, double width, Color color) {
        int[] res = this.getMaxResolution();
        width = width * 72.0 / Math.sqrt(res[0] * res[1]);
        this.setGraphPenPt(style, width, color);
    }

    public void setGraphBrush(int style, Color color) {
        this.addCommand(new SetGraphBrush(this.gf, style, color));
    }

    public void setBoxShade(Color color) {
        this.addCommand(new SetBoxShade((GuiFactory)this.gf, color));
    }

    public void setDataColumns(int[] cols) {
        SetDataColumns cmd = new SetDataColumns(this.gf, this.allCommands.classDataCols, cols);
        this.addCommand(cmd);
        this.allCommands.classDataCols = cmd.getCols();
    }

    public void setPageColumn(boolean pComma, double start, double indent, double separation, int fontId, int unit, char align, boolean transparency) {
        this.setPageColumn(pComma, start, indent, separation, this.getFont(fontId), unit, align, transparency);
    }

    protected void setPageColumn(boolean pComma, double start, double indent, double separation, Font font, int unit, char align, boolean transparency) {
        SetPageColumns cmd = new SetPageColumns(this.gf, this.allCommands.locHandles, this.allCommands.classPageCols, pComma, start, indent, separation, font, unit, align, transparency);
        this.addCommand(cmd);
        this.allCommands.classPageCols = cmd.getCols();
    }

    public void clearPageColumn() {
        this.addCommand(new SetPageColumns(this.gf));
        this.allCommands.classPageCols = null;
    }

    public Point getPageLayout(Map attrs) {
        Font font = attrs != null ? this.getFont(attrs) : this.currFont;
        PrinterJob pj = PrinterJob.getPrinterJob();
        Point result = new Point();
        PageFormat pf = this.buildPageFormat();
        Printable prn = (g, pf0, pageIndex) -> {
            Graphics2D g2d = (Graphics2D)g;
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout layout = new TextLayout("0", font == null ? g2d.getFont() : font, frc);
            float height = layout.getAscent() + layout.getDescent() + layout.getLeading();
            float width = layout.getAdvance();
            result.y = (int)(pf.getImageableHeight() / (double)height);
            result.x = (int)(pf.getImageableWidth() / (double)width);
            pj.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(pj, prn);
        if (this.numLines >= 0) {
            result.y = this.numLines;
        }
        return result;
    }

    public void setMargins(double top, double bottom, double left, double right, int type) {
        Size2DSyntax size = this.getMediaSize();
        if (size == null) {
            System.err.println("MediaSize missing!");
            return;
        }
        MediaPrintableArea mpa = null;
        if (type == 0) {
            type = this.setting.currUnits;
        }
        switch (type) {
            case 4: {
                int[] res = this.getMaxResolution();
                if (top > 0.0) {
                    top /= (double)res[1];
                }
                if (bottom > 0.0) {
                    bottom /= (double)res[1];
                }
                if (left > 0.0) {
                    left /= (double)res[0];
                }
                if (right > 0.0) {
                    right /= (double)res[0];
                }
            }
            case 2: {
                if (top == 0.0) {
                    top = 0.0;
                } else if (top < 0.0) {
                    top = this.topMargin / 72.0;
                }
                if (bottom == 0.0) {
                    bottom = 0.0;
                } else if (bottom < 0.0) {
                    bottom = this.bottomMargin / 72.0;
                }
                if (left == 0.0) {
                    left = 0.0;
                } else if (left < 0.0) {
                    left = this.leftMargin / 72.0;
                }
                if (right == 0.0) {
                    right = 0.0;
                } else if (right < 0.0) {
                    right = this.rightMargin / 72.0;
                }
                mpa = this.isReportPreview() ? new MediaPrintableArea(0.0f, 0.0f, size.getX(25400), size.getY(25400), 25400) : new MediaPrintableArea((float)left, (float)top, (float)((double)size.getX(25400) - left - right), (float)((double)size.getY(25400) - top - bottom), 25400);
                this.leftMargin = left * 72.0;
                this.topMargin = top * 72.0;
                this.rightMargin = right * 72.0;
                this.bottomMargin = bottom * 72.0;
                break;
            }
            case 3: {
                if (top == 0.0) {
                    top = 0.0;
                } else if (top < 0.0) {
                    top = this.topMargin / 28.34645652770996;
                }
                if (bottom == 0.0) {
                    bottom = 0.0;
                } else if (bottom < 0.0) {
                    bottom = this.bottomMargin / 28.34645652770996;
                }
                if (left == 0.0) {
                    left = 0.0;
                } else if (left < 0.0) {
                    left = this.leftMargin / 28.34645652770996;
                }
                if (right == 0.0) {
                    right = 0.0;
                } else if (right < 0.0) {
                    right = this.rightMargin / 28.34645652770996;
                }
                mpa = this.isReportPreview() ? new MediaPrintableArea(0.0f, 0.0f, size.getX(1000), size.getY(1000), 1000) : new MediaPrintableArea((float)(left * 10.0), (float)(top * 10.0), (float)((double)size.getX(1000) - (left + right) * 10.0), (float)((double)size.getY(1000) - (top + bottom) * 10.0), 1000);
                this.leftMargin = left * 28.34645652770996;
                this.topMargin = top * 28.34645652770996;
                this.rightMargin = right * 28.34645652770996;
                this.bottomMargin = bottom * 28.34645652770996;
                break;
            }
            case 0: {
                this.setMargins(0.0, 0.0, 0.0, 0.0, 3);
                break;
            }
            default: {
                System.err.println("setMargins:Type " + type + " not supported!");
            }
        }
        if (mpa != null) {
            this.aset.add(mpa);
        }
    }

    public boolean isReportPreview() {
        return this.events != null;
    }

    public double[] getMargins(int type) {
        double[] Return2 = new double[4];
        switch (type) {
            case 2: {
                Return2[0] = this.topMargin / 72.0;
                Return2[1] = this.bottomMargin / 72.0;
                Return2[2] = this.leftMargin / 72.0;
                Return2[3] = this.rightMargin / 72.0;
                break;
            }
            case 3: {
                Return2[0] = this.topMargin / 28.34645652770996;
                Return2[1] = this.bottomMargin / 28.34645652770996;
                Return2[2] = this.leftMargin / 28.34645652770996;
                Return2[3] = this.rightMargin / 28.34645652770996;
                break;
            }
            case 4: {
                Return2[0] = this.topMargin;
                Return2[1] = this.bottomMargin;
                Return2[2] = this.leftMargin;
                Return2[3] = this.rightMargin;
                break;
            }
            default: {
                System.err.println("getMargins:Type " + type + " not supported!");
            }
        }
        return Return2;
    }

    public void setDefaultUnits(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setting.currUnits = type;
            }
        }
    }

    public void setJobName(String s, String out) {
        String jn;
        if (s != null && (jn = s.trim()).length() > 0) {
            this.aset.add(new JobName(jn, null));
            if (out != null && out.length() > 0) {
                char c = Character.toUpperCase(out.charAt(0));
                if (c == 'P') {
                    this.pdf = true;
                    this.preview = false;
                    this.setFileName(jn);
                } else if (c == 'V') {
                    this.preview = true;
                    this.pdf = false;
                    this.setFileName(jn);
                } else if (c == 'S') {
                    this.preview = false;
                    this.pdf = false;
                    this.setFileName("PRINTER?");
                }
            }
        } else {
            this.aset.add(new JobName(jobName, null));
        }
    }

    public String getJobName() {
        JobName jn = (JobName)this.aset.get(JobName.class);
        if (jn != null) {
            return jn.getValue();
        }
        return jobName;
    }

    public boolean setMediaSize(int n) {
        if (n <= 0 || n >= mediaSizes.length || mediaSizes[n] == null) {
            return false;
        }
        this.setting.currMediaSizeName = SpoolPrinter.mediaSizes[n];
        this.customPdfMediaSize = null;
        this.aset.add(this.setting.currMediaSizeName);
        this.setMargins(this.topMargin / 72.0, this.bottomMargin / 72.0, this.leftMargin / 72.0, this.rightMargin / 72.0, 2);
        return true;
    }

    public boolean setCustomMediaSize(float x, float y, int unit) {
        Object o;
        int u;
        switch (unit) {
            case 2: {
                u = 25400;
                break;
            }
            case 3: {
                x *= 10.0f;
                y *= 10.0f;
                u = 1000;
                break;
            }
            default: {
                return false;
            }
        }
        MediaSizeName msn = null;
        PrintService currPrinter = this.getCurrPrintService();
        if (currPrinter != null && (o = currPrinter.getSupportedAttributeValues(Media.class, null, null)) instanceof Media[]) {
            for (Media m : (Media[])o) {
                MediaSize size;
                if (!(m instanceof MediaSizeName) || (size = MediaSize.getMediaSizeForName((MediaSizeName)m)).getX(u) != x || size.getY(u) != y) continue;
                msn = (MediaSizeName)m;
                break;
            }
        }
        if (msn != null) {
            this.setMediaSize(msn);
            this.setMargins(this.topMargin / 72.0, this.bottomMargin / 72.0, this.leftMargin / 72.0, this.rightMargin / 72.0, 2);
            return true;
        }
        if (x <= y) {
            this.customPdfMediaSize = new MediaSize(x, y, u);
        }
        return false;
    }

    public void setCurrPrinter(PrintService ps) {
        this.setting.currentPrinter = ps;
    }

    public void setMediaSize(MediaSizeName mediaSize) {
        this.setting.currMediaSizeName = mediaSize;
        this.aset.add(this.setting.currMediaSizeName);
        this.customPdfMediaSize = null;
    }

    public int getCurrMediaSize() {
        if (this.setting.currMediaSizeName != null) {
            for (int i = 0; i < mediaSizes.length; ++i) {
                if (this.setting.currMediaSizeName != mediaSizes[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public Size2DSyntax getCurrMediaSize2D() {
        if (this.setting.currMediaSizeName != null) {
            return MediaSize.getMediaSizeForName(this.setting.currMediaSizeName);
        }
        return null;
    }

    private int getMediaSize(MediaSizeName s) {
        int Return2;
        for (Return2 = mediaSizes.length - 1; Return2 > 0 && s != mediaSizes[Return2]; --Return2) {
        }
        return Return2;
    }

    private MediaTray getMediaTray(int n) {
        if (n > 0) {
            Object[] media;
            if (n < mediaTrays.length && mediaTrays[n] != null) {
                return mediaTrays[n];
            }
            PrintService currPrinter = this.getCurrPrintService();
            if (currPrinter != null && (media = (Object[])currPrinter.getSupportedAttributeValues(Media.class, null, null)) != null) {
                for (int j = 0; j < media.length; ++j) {
                    MediaTray mt;
                    if (!(media[j] instanceof MediaTray) || this.getDeviceMediaTray(mt = (MediaTray)media[j]) != n) continue;
                    return mt;
                }
            }
        }
        return null;
    }

    private int getMediaTray(MediaTray mt) {
        for (int i = 0; i < mediaTrays.length; ++i) {
            if (mt != mediaTrays[i]) continue;
            return i;
        }
        return this.getDeviceMediaTray(mt);
    }

    private int getDeviceMediaTray(MediaTray mt) {
        try {
            if (win32mt != null && win32mt.isAssignableFrom(mt.getClass())) {
                return (Integer)win32mt.getField("winID").get(mt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mt.getValue();
    }

    public int[][] getMedia4Printer(String prnName) {
        Object[] media;
        int prnNum = this.getPrinterNumber(prnName);
        Object Return2 = null;
        if (prnNum >= 0 && (media = (Object[])this.services[prnNum].getSupportedAttributeValues(Media.class, null, null)) != null) {
            int j;
            Vector<Object> size = new Vector<Object>();
            Vector<Object> tray = new Vector<Object>();
            for (j = 0; j < media.length; ++j) {
                if (media[j] instanceof MediaSizeName) {
                    size.add(media[j]);
                    continue;
                }
                if (!(media[j] instanceof MediaTray)) continue;
                tray.add(media[j]);
            }
            Return2 = new int[2][];
            Return2[0] = new int[size.size()];
            Return2[1] = new int[tray.size()];
            for (j = size.size() - 1; j >= 0; --j) {
                Return2[0][j] = this.getMediaSize((MediaSizeName)size.elementAt(j));
            }
            for (j = tray.size() - 1; j >= 0; --j) {
                Return2[1][j] = this.getMediaTray((MediaTray)tray.elementAt(j));
            }
        }
        return Return2;
    }

    public boolean setMediaTray(int n) {
        this.setting.currMediaTray = this.getMediaTray(n);
        if (this.setting.currMediaTray != null) {
            this.aset.add(this.setting.currMediaTray);
            return true;
        }
        return false;
    }

    public int getMediaTray() {
        MediaTray mt = (MediaTray)this.aset.get(MediaTray.class);
        if (mt == null) {
            for (Attribute o : this.aset.toArray()) {
                if (!(o instanceof MediaTray)) continue;
                mt = (MediaTray)o;
                break;
            }
        }
        if (mt == null) {
            for (Attribute o : this.aset.toArray()) {
                if (!(o instanceof PrintRequestAttribute)) continue;
                try {
                    mt = (MediaTray)o.getClass().getMethod("getMedia", new Class[0]).invoke((Object)o, new Object[0]);
                    if (mt == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.getMediaTray(mt);
    }

    public void setAttribute(String key, String value) {
        this.genericAttrs.put(key, value);
    }

    public boolean hasPrinted() {
        return this.printed;
    }

    public void cancelJob() {
        this.jobCancelled = true;
    }

    public void buildPages(Graphics2D g2d, PageFormat pf) {
        this.buildPages(g2d, pf, false);
    }

    public void buildPages(Graphics2D g2d, PageFormat pf, boolean find) {
        PrintContext pc = new PrintContext(new Point2D.Float(0.0f, 0.0f), g2d.getFont(), g2d.getFontRenderContext(), new Color(0, 0, 0), pf, this.initialOrientation);
        Page page = new Page(pc, this.allCommands);
        this.pages = new Vector();
        boolean isPageEmpty = true;
        long cur = 0L;
        PrintCommand cmd = this.allCommands.getFirst();
        while (cmd != null) {
            boolean b = find ? cmd.print(pc, g2d, pc.pf) : cmd.testPrint(pc, g2d, pc.pf);
            page.currPf = pc.pf;
            if (b) {
                page.addItem(cur);
                isPageEmpty = isPageEmpty && (cmd instanceof SetNewPage || cmd instanceof SetPageColumns);
            } else {
                this.pages.addElement(page);
                pc.pen = new Point2D.Float(0.0f, 0.0f);
                page = new Page(pc, this.allCommands);
                isPageEmpty = true;
                if (cmd.addMeToPage()) {
                    if (find) {
                        cmd.print(pc, g2d, pc.pf);
                    } else {
                        cmd.testPrint(pc, g2d, pc.pf);
                    }
                    page.addItem(cur);
                    isPageEmpty = cmd instanceof SetNewPage || cmd instanceof SetPageColumns;
                }
            }
            cur = this.allCommands.getNextIdx();
            cmd = this.allCommands.getNext();
        }
        if (!isPageEmpty) {
            this.pages.addElement(page);
        }
        if (this.header != null || this.footer != null) {
            this.aHeadFoot = new AutoHeaderFooter(this.header, this.footer, this.getPageCount(), this.reportName, this.headerFooterFont);
        }
    }

    private Paper setReportMargins(PageFormat pf) {
        if (this.isReportPreview()) {
            Paper paperSave = pf.getPaper();
            Size2DSyntax ms = this.getMediaSize();
            float width = ms.getX(25400) * 72.0f;
            float height = ms.getY(25400) * 72.0f;
            Paper paper = new Paper();
            if (this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE) {
                paper.setSize(width, height);
                paper.setImageableArea(this.topMargin, this.rightMargin, (double)width - this.topMargin - this.bottomMargin, (double)height - this.leftMargin - this.rightMargin);
            } else {
                paper.setSize(width, height);
                paper.setImageableArea(this.leftMargin, this.topMargin, (double)width - this.leftMargin - this.rightMargin, (double)height - this.topMargin - this.bottomMargin);
            }
            pf.setPaper(paper);
            return paperSave;
        }
        return null;
    }

    private PageFormat getReportPreviewPageFormat(PageFormat pf) {
        Size2DSyntax ms = this.getMediaSize();
        float width = ms.getX(25400) * 72.0f;
        float height = ms.getY(25400) * 72.0f;
        Paper paper = new Paper();
        paper.setSize(width, height);
        paper.setImageableArea(0.0, 0.0, width, height);
        pf.setPaper(paper);
        return pf;
    }

    private void adjustHFMargins() {
        if (this.isReportPreview() && this.aHeadFoot != null) {
            Size2DSyntax ms = this.getMediaSize();
            float width = ms.getX(25400) * 72.0f;
            float height = ms.getY(25400) * 72.0f;
            Paper paper = new Paper();
            paper.setSize(width, height);
            paper.setImageableArea(0.0, 0.0, width, height);
            PageFormat pf2 = new PageFormat();
            pf2.setPaper(paper);
            PrinterJob pj = PrinterJob.getPrinterJob();
            PrintService currPrinter = this.getCurrPrintService();
            if (currPrinter != null) {
                SpoolPrinter.setPrintService(pj, currPrinter);
            }
            pf2 = pj.validatePage(pf2);
            this.aHeadFoot.imgArea = this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE ? new Rectangle2D.Double(this.leftMargin - pf2.getImageableX(), this.topMargin - pf2.getImageableY(), pf2.getImageableHeight(), pf2.getImageableWidth()) : new Rectangle2D.Double(this.leftMargin - pf2.getImageableX(), this.topMargin - pf2.getImageableY(), pf2.getImageableWidth(), pf2.getImageableHeight());
        }
    }

    public MediaPrintableArea getMediaPrintableArea(boolean lnd) {
        Size2DSyntax size = this.getMediaSize();
        float t = (float)(this.topMargin / 72.0);
        float b = (float)(this.bottomMargin / 72.0);
        float r = (float)(this.rightMargin / 72.0);
        float l = (float)(this.leftMargin / 72.0);
        if (lnd) {
            return new MediaPrintableArea(t, r, size.getX(25400) - t - b, size.getY(25400) - l - r, 25400);
        }
        return new MediaPrintableArea(l, t, size.getX(25400) - l - r, size.getY(25400) - t - b, 25400);
    }

    private Size2DSyntax getMediaSize() {
        Object o;
        PrintService currPrinter;
        MediaSize size = this.setting.currMediaSizeName == null ? ((currPrinter = this.getCurrPrintService()) != null && (o = currPrinter.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)o) : new MediaSize(210, 297, 1000)) : MediaSize.getMediaSizeForName(this.setting.currMediaSizeName);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        try {
            Graphics2D g2d = (Graphics2D)g;
            Paper ppr = this.setReportMargins(pf);
            try {
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                if (this.pages == null) {
                    this.buildPages(g2d, pf);
                }
                Page pg = null;
                try {
                    pg = this.pages.elementAt(pageIndex);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (pg == null) {
                    int n = 1;
                    return n;
                }
                this.adjustHFMargins();
                pg.print(g2d, pf, this.aHeadFoot, pageIndex + 1);
                int n = 0;
                return n;
            }
            finally {
                if (ppr != null) {
                    pf.setPaper(ppr);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public int getPageCount() {
        return this.pages != null ? this.pages.size() : 0;
    }

    public void clearPages() {
        this.pages = null;
    }

    private PageFormat buildPageFormat() {
        return this.buildPageFormat(-1);
    }

    private PageFormat buildPageFormat(int orientation) {
        MediaSize ms;
        Attribute o;
        if (orientation < 0) {
            OrientationRequested or = (OrientationRequested)this.aset.get(OrientationRequested.class);
            orientation = or == null || or == OrientationRequested.PORTRAIT ? 1 : 0;
        }
        if ((o = this.aset.get(Media.class)) instanceof MediaSizeName && (ms = MediaSize.getMediaSizeForName((MediaSizeName)o)) != null) {
            Paper p = new Paper();
            p.setSize((double)ms.getX(25400) * 72.0, (double)ms.getY(25400) * 72.0);
            MediaPrintableArea mpa = (MediaPrintableArea)this.aset.get(MediaPrintableArea.class);
            p.setImageableArea((double)mpa.getX(25400) * 72.0, (double)mpa.getY(25400) * 72.0, (double)mpa.getWidth(25400) * 72.0, (double)mpa.getHeight(25400) * 72.0);
            PageFormat pf = new PageFormat();
            pf.setOrientation(orientation);
            pf.setPaper(p);
            return pf;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat[] pf = new PageFormat[1];
        this.fakePrint(pj, (g, pf0, pageIndex) -> {
            pf[0] = pf0;
            pj.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        }, null);
        return pf[0];
    }

    public PageFormat getPageFormat(int orientation) {
        PageFormat pf = this.buildPageFormat(orientation);
        if (this.isReportPreview()) {
            return this.getReportPreviewPageFormat(pf);
        }
        return pf;
    }

    public void setPreview(boolean prvw) {
        this.preview = prvw;
    }

    public void setPDF(boolean p) {
        this.pdf = p;
    }

    private static String[] breakHeaderFooter(String line) {
        String[] Return2;
        if (line != null && line.length() > 0) {
            int idx;
            ArrayList<String> retArray = new ArrayList<String>();
            block3: while ((idx = line.indexOf(38)) >= 0) {
                if (idx > 0) {
                    retArray.add(line.substring(0, idx));
                    line = line.substring(idx);
                }
                switch (line.length()) {
                    case 1: 
                    case 2: {
                        retArray.add(line);
                        line = "";
                        continue block3;
                    }
                }
                retArray.add(line.substring(0, 2));
                line = line.substring(2);
            }
            if (line.length() > 0) {
                retArray.add(line);
            }
            Return2 = new String[retArray.size()];
            for (int i = 0; i < Return2.length; ++i) {
                Return2[i] = retArray.get(i).toString();
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public void setHeaderFooter(String head, String foot, int fontId) {
        this.setHeaderFooter(head, foot, this.getFont(fontId));
    }

    protected void setHeaderFooter(String head, String foot, Font font) {
        if (head != null) {
            this.header = SpoolPrinter.breakHeaderFooter(head);
        }
        if (foot != null) {
            this.footer = SpoolPrinter.breakHeaderFooter(foot);
        }
        this.headerFooterFont = font;
    }

    public void setReportName(String n) {
        this.reportName = n;
    }

    public String getReportName() {
        return this.reportName;
    }

    private Preview printPreview() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.getPageFormat(this.initialOrientation);
        Printable prn = (g, pf0, pageIndex) -> {
            if (this.pages == null) {
                this.buildPages((Graphics2D)g, pageFormat);
            }
            pj.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        MyPageable pg = new MyPageable(prn, pageFormat);
        this.fakePrint(pj, null, pg);
        if (this.pages != null) {
            KeyboardBuffer.setBufferOff();
            PreviewDialog pd = Preview.previewDialog(this, pg, this.pages.size(), this.fileName, prDialogSettings, this.events);
            prDialogSettings.setAntialiasing(pd.getAntialiasing());
            prDialogSettings.setScale(pd.getScale());
            prDialogSettings.setMaximized(pd.isMaximized());
            prDialogSettings.setBounds(pd.getRestoreBounds());
            KeyboardBuffer.setBufferOn();
            return pd.getPreview();
        }
        return null;
    }

    private boolean printPDF() throws PrinterException, IOException {
        String fn = this.fileName;
        if (this.openFileChooser) {
            String defFile = null;
            String defDir = File.getcwd();
            if (fn != null && fn.length() > 0) {
                java.io.File f = new java.io.File(fn);
                if (f.isDirectory()) {
                    if (f.exists()) {
                        defDir = fn;
                    }
                } else {
                    java.io.File p = f.getParentFile();
                    if (p != null && p.exists()) {
                        defDir = f.getParent();
                    }
                    defFile = f.getName();
                }
            }
            KeyboardBuffer.setBufferOff();
            fn = Preview.openSaveDialog(null, "pdf", "Portable Document Format (*.pdf)", defDir, defFile);
            KeyboardBuffer.setBufferOn();
            if (fn == null) {
                return false;
            }
        }
        return this.printPDF(fn);
    }

    public boolean printPDF(String fn) throws PrinterException, IOException {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = this.buildPageFormat(this.initialOrientation);
        Printable prn = (g, pf0, pageIndex) -> {
            if (this.pages == null) {
                this.buildPages((Graphics2D)g, pf);
            }
            pj.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        MyPageable pg = new MyPageable(prn, pf);
        this.fakePrint(pj, prn, pg);
        if (this.pages != null) {
            pj.setPrintable(this);
            PDF p = new PDF(this, pg, pj, fn, this.pages.size());
            return p.doPrint(this.aset, this.genericAttrs, this.customPdfMediaSize);
        }
        return false;
    }

    private void checkTmpFile() {
        if (this.binary) {
            if (this.binOut == null) {
                try {
                    this.tmpFile = java.io.File.createTempFile("prt", ".prt");
                    this.tmpFile.deleteOnExit();
                    this.binOut = new FileOutputStream(this.tmpFile);
                }
                catch (FileNotFoundException _ex) {
                    throw new IscobolRuntimeException(8, _ex.toString());
                }
                catch (IOException _ex) {
                    throw new IscobolRuntimeException(8, _ex.toString());
                }
            }
        } else if (this.out == null) {
            try {
                this.tmpFile = java.io.File.createTempFile("prt", ".prt");
                this.tmpFile.deleteOnExit();
                this.out = new FileWriter(this.tmpFile);
            }
            catch (FileNotFoundException _ex) {
                throw new IscobolRuntimeException(8, _ex.toString());
            }
            catch (IOException _ex) {
                throw new IscobolRuntimeException(8, _ex.toString());
            }
        }
    }

    private void closeDirect() {
        if (this.out != null || this.binOut != null) {
            try {
                if (this.out != null) {
                    this.out.close();
                } else {
                    this.binOut.close();
                }
                PrintService currPrinter = this.getCurrPrintService();
                if (currPrinter != null) {
                    DocPrintJob job = currPrinter.createPrintJob();
                    FileInputStream inp = new FileInputStream(this.tmpFile);
                    DocFlavor.INPUT_STREAM format = DocFlavor.INPUT_STREAM.AUTOSENSE;
                    SimpleDoc doc = new SimpleDoc(inp, format, null);
                    job.print(doc, new HashPrintRequestAttributeSet());
                    if (this.tmpFile != null) {
                        this.tmpFile.delete();
                        this.tmpFile = null;
                    }
                    this.out = null;
                    this.binOut = null;
                }
            }
            catch (IOException _ex) {
                throw new IscobolRuntimeException(8, _ex.toString());
            }
            catch (PrintException _ex) {
                _ex.printStackTrace();
            }
        }
    }

    public void flushDirect() {
        this.checkTmpFile();
        try {
            if (this.binary) {
                this.binOut.flush();
            } else {
                this.out.flush();
            }
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(char[] b) {
        this.checkTmpFile();
        try {
            this.out.write(b);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(char[] b, int off, int len) {
        this.checkTmpFile();
        try {
            this.out.write(b, off, len);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(int c) {
        this.checkTmpFile();
        try {
            this.out.write(c);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(byte[] b) {
        this.checkTmpFile();
        try {
            this.binOut.write(b);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(byte[] b, int off, int len) {
        this.checkTmpFile();
        try {
            this.binOut.write(b, off, len);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public void writeDirect(byte c) {
        this.checkTmpFile();
        try {
            this.binOut.write(c);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(8, _ex.toString());
        }
    }

    public static String getDialogTitle() {
        return prDialogSettings.getTitle();
    }

    public static void setDialogTitle(String dialogTitle) {
        if (dialogTitle == null) {
            dialogTitle = "Print Preview";
        }
        prDialogSettings.setTitle(dialogTitle);
    }

    public static boolean isPreviewAliasing() {
        return SpoolPrinter.isPreviewAntialiasing();
    }

    public static void setPreviewAliasing(boolean pAliasing) {
        SpoolPrinter.setPreviewAntialiasing(pAliasing);
    }

    public static boolean isPreviewAntialiasing() {
        return prDialogSettings.isAntialiasing();
    }

    public static void setPreviewAntialiasing(boolean pAntialiasing) {
        prDialogSettings.setAntialiasing(pAntialiasing);
    }

    public static boolean isPreviewMaximized() {
        return prDialogSettings.isMaximized();
    }

    public static void setPreviewMaximized(boolean pMaximized) {
        prDialogSettings.setMaximized(pMaximized);
    }

    public static double getPreviewScale() {
        return prDialogSettings.getScale();
    }

    public static void setPreviewScale(double pScale) {
        prDialogSettings.setScale(pScale);
    }

    public static void setPreviewSize(int width, int height) {
        Rectangle bounds = prDialogSettings.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        bounds.setSize(width, height);
        prDialogSettings.setBounds(bounds);
    }

    public static Dimension getPreviewSize() {
        Rectangle bounds = prDialogSettings.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        return bounds.getSize();
    }

    public static void setPreviewLocation(int x, int y) {
        Rectangle bounds = prDialogSettings.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        bounds.setLocation(x, y);
        prDialogSettings.setBounds(bounds);
    }

    public static Point getPreviewLocation() {
        Rectangle bounds = prDialogSettings.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        return bounds.getLocation();
    }

    public static boolean isShowPrintButton() {
        return prDialogSettings.getShowPrintButton();
    }

    public static void setShowPrintButton(boolean showPrintButton) {
        prDialogSettings.setShowPrintButton(showPrintButton);
    }

    public static boolean isShowPrintSetupButton() {
        return prDialogSettings.getShowPrintSetupButton();
    }

    public static void setShowPrintSetupButton(boolean showPrintSetupButton) {
        prDialogSettings.setShowPrintSetupButton(showPrintSetupButton);
    }

    public static boolean isShowSaveButton() {
        return prDialogSettings.getShowSaveButton();
    }

    public static void setShowSaveButton(boolean showSaveButton) {
        prDialogSettings.setShowSaveButton(showSaveButton);
    }

    public static boolean isShowThumbnailsButton() {
        return prDialogSettings.getShowThumbnailsButton();
    }

    public static void setShowThumbnailsButton(boolean showThumbnailsButton) {
        prDialogSettings.setShowThumbnailsButton(showThumbnailsButton);
    }

    public static boolean isShowThumbnails() {
        return prDialogSettings.getShowThumbnails();
    }

    public static void setShowThumbnails(boolean showThumbnails) {
        prDialogSettings.setShowThumbnails(showThumbnails);
    }

    public static boolean isShowExportMenu() {
        return prDialogSettings.isShowExportMenu();
    }

    public static void setShowExportMenu(boolean showExportMenu) {
        prDialogSettings.setShowExportMenu(showExportMenu);
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.aset;
    }

    public void setSavedPrintRequestAttributeSet(PrintRequestAttributeSet aset) {
        if (this.asetSave == null) {
            this.asetSave = aset;
        }
    }

    public void restorePrintRequestAttributeSet() {
        if (this.asetSave != null) {
            this.aset = this.asetSave;
            this.asetSave = null;
        }
    }

    public static ImageIcon getImageIcon() {
        return prDialogSettings.getIconImage() != null ? new ImageIcon(prDialogSettings.getIconImage()) : null;
    }

    public static void setImageIcon(ImageIcon iconImage) {
        prDialogSettings.setIconImage(iconImage != null ? iconImage.getImage() : null);
    }

    public static boolean isShowPrintDialog() {
        return prDialogSettings.getShowPrintDialog();
    }

    public static boolean isCloseWindowAfterPrint() {
        return prDialogSettings.isCloseWindowAfterPrint();
    }

    public static void setCloseWindowAfterPrint(boolean b) {
        prDialogSettings.setCloseWindowAfterPrint(b);
    }

    public static boolean isCloseWindowAfterPrintPdf() {
        return prDialogSettings.isCloseWindowAfterPrintPdf();
    }

    public static void setCloseWindowAfterPrintPdf(boolean b) {
        prDialogSettings.setCloseWindowAfterPrintPdf(b);
    }

    public static String getSaveDefaultDirectory() {
        return prDialogSettings.getSaveDefaultDirectory();
    }

    public static void setSaveDefaultDirectory(String saveDefaultDirectory) {
        prDialogSettings.setSaveDefaultDirectory(saveDefaultDirectory);
    }

    public static String getSaveDefaultFilename() {
        return prDialogSettings.getSaveDefaultFilename();
    }

    public static void setSaveDefaultFilename(String saveDefaultFilename) {
        prDialogSettings.setSaveDefaultFilename(saveDefaultFilename);
    }

    public static Color getPrintableAreaBoxColor() {
        return prDialogSettings.getPrintableAreaBoxColor();
    }

    public static void setPrintableAreaBoxColor(Color printableAreaBoxColor) {
        prDialogSettings.setPrintableAreaBoxColor(printableAreaBoxColor);
    }

    public static void setShowPrintDialog(boolean showPrintDialog) {
        prDialogSettings.setShowPrintDialog(showPrintDialog);
    }

    public static void addMenu(String path, String title, ImageIcon icon, int code) {
        prDialogSettings.addMenu(path, title, icon, code);
    }

    public static void removeMenu(String path) {
        prDialogSettings.removeMenu(path);
    }

    static MediaSizeName getDefaultLocaleMediaSizeName() {
        String country = System.getProperty("iscobol.resource.country", System.getProperty("user.country"));
        if (Locale.US.getCountry().equals(country) || Locale.CANADA.getCountry().equals(country)) {
            return MediaSizeName.NA_LETTER;
        }
        return MediaSizeName.ISO_A4;
    }

    public boolean isSearchKeyEvent(int code, boolean alt, boolean shift, boolean control) {
        boolean Return2 = false;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            Return2 = this.gf.getRemoteVirtualKeyboard().isSearchKey(code, alt, shift, control, searchpreviewname);
        }
        return Return2;
    }

    public int[] getSearchChars() {
        int[] Return2 = null;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            Return2 = this.gf.getRemoteVirtualKeyboard().getSearchChars(searchpreviewname);
        }
        return Return2;
    }

    public int[] getSearchMasks() {
        int[] Return2 = null;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            Return2 = this.gf.getRemoteVirtualKeyboard().getSearchMasks(searchpreviewname);
        }
        return Return2;
    }

    static {
        int v;
        Class<?> c;
        try {
            c = Class.forName("sun.print.Win32MediaTray");
            RtsUtil.openModule(c, SpoolPrinter.class, "sun.print");
        }
        catch (Throwable t) {
            c = null;
        }
        win32mt = c;
        try {
            v = Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
        }
        catch (Exception e) {
            v = 0;
        }
        javaMajorVersion = v;
        mediaTrays = new MediaTray[]{null, MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, SpoolPrinter.getWinMediaTray("ENVELOPE_MANUAL"), SpoolPrinter.getWinMediaTray("AUTO"), SpoolPrinter.getWinMediaTray("TRACTOR"), SpoolPrinter.getWinMediaTray("SMALL_FORMAT"), SpoolPrinter.getWinMediaTray("LARGE_FORMAT"), MediaTray.LARGE_CAPACITY, MediaTray.SIDE, MediaTray.MAIN, null, SpoolPrinter.getWinMediaTray("FORMSOURCE")};
        mediaSizes = new MediaSizeName[]{null, MediaSizeName.NA_LETTER, new CustomMediaSizeName("Letter Small", 8.5f, 11.0f, 25400), MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, new CustomMediaSizeName("Statement 5 1/2 x 8 1/2 in", 5.5f, 8.5f, 25400), MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, new CustomMediaSizeName("A4 Small", 210, 297, 1000), MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, new CustomMediaSizeName("11x17 in", 11, 17, 25400), new CustomMediaSizeName("Note 8 1/2 x 11 in", 8.5f, 11.0f, 25400), MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, new CustomMediaSizeName("Envelope DL 110 x 220mm", 110, 220, 1000), MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, new CustomMediaSizeName("Envelope C65 114 x 229 mm", 114, 229, 1000), MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, new CustomMediaSizeName("US Std Fanfold 14 7/8 x 11 in", 7.8f, 11.0f, 25400), new CustomMediaSizeName("German Std Fanfold 8 1/2 x 12 in", 8.5f, 12.0f, 25400), new CustomMediaSizeName("German Legal Fanfold 8 1/2 x 13 in", 8.5f, 13.0f, 25400), new CustomMediaSizeName("B4 (ISO)", 250, 353, 1000), MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE, new CustomMediaSizeName("10 x 11 in", 10.0f, 11.0f, 25400), new CustomMediaSizeName("15 x 11 in", 11, 15, 25400), new CustomMediaSizeName("Envelope Invite 220 x 220 mm", 220, 220, 1000), null, null, new CustomMediaSizeName("US Letter Extra 9 1/2 x 12 in", 9.5f, 12.0f, 25400), new CustomMediaSizeName("US Legal Extra 9 1/2 x 15 in", 9.5f, 15.0f, 25400), new CustomMediaSizeName("US Tabloid Extra 11.69 x 18 in", 11.69f, 18.0f, 25400), new CustomMediaSizeName("A4 Extra 9.27 x 12.69 in ", 9.27f, 12.69f, 25400), new CustomMediaSizeName("Letter Transverse 8 1/2 x 11 in", 8.5f, 11.0f, 25400), new CustomMediaSizeName("A4 Transverse 210 x 297 mm", 210, 297, 1000), new CustomMediaSizeName("Letter Extra Transverse 9 1/2 x 12 in", 9.5f, 12.0f, 25400), new CustomMediaSizeName("SuperA/SuperA/A4 227 x 356 mm", 227, 356, 1000), new CustomMediaSizeName("SuperB/SuperB/A3 305 x 487 mm", 305, 487, 1000), new CustomMediaSizeName("US Letter Plus 8.5 x 12.69 in", 8.5f, 12.69f, 25400), new CustomMediaSizeName("A4 Plus 210 x 330 mm", 210, 330, 1000), new CustomMediaSizeName("A5 Transverse 148 x 210 mm", 148, 210, 1000), new CustomMediaSizeName("B5 (JIS) Transverse 182 x 257 mm", 182, 257, 1000), new CustomMediaSizeName("A3 Extra 322 x 445 mm", 322, 445, 1000), new CustomMediaSizeName("A5 Extra 174 x 235 mm", 174, 235, 1000), new CustomMediaSizeName("B5 (ISO) Extra 201 x 276 mm", 201, 276, 1000), MediaSizeName.ISO_A2, new CustomMediaSizeName("A3 Transverse 297 x 420 mm", 297, 420, 1000), new CustomMediaSizeName("A3 Extra Transverse 322 x 445 mm", 322, 445, 1000), MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.ISO_A6, null};
        prDialogSettings = new PreviewDialogSettings();
    }

    class MyPageable
    implements Pageable {
        final Printable prn;
        final PageFormat pf;

        MyPageable(Printable p, PageFormat pf) {
            this.prn = p;
            this.pf = pf;
        }

        @Override
        public int getNumberOfPages() {
            return -1;
        }

        @Override
        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            if (SpoolPrinter.this.pages != null && pageIndex < SpoolPrinter.this.pages.size()) {
                return ((Page)((SpoolPrinter)SpoolPrinter.this).pages.elementAt((int)pageIndex)).currPf;
            }
            return this.pf;
        }

        @Override
        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return this.prn;
        }
    }

    protected static class Setting {
        protected PrintService currentPrinter;
        private OrientationRequested currOrientation = OrientationRequested.PORTRAIT;
        private PrintQuality currQuality = null;
        private MediaSizeName currMediaSizeName = SpoolPrinter.getDefaultLocaleMediaSizeName();
        private MediaTray currMediaTray;
        private int currUnits = 2;

        protected Setting() {
        }

        Setting copy() {
            Setting s = new Setting();
            s.currentPrinter = this.currentPrinter;
            s.currOrientation = this.currOrientation;
            s.currQuality = this.currQuality;
            s.currMediaSizeName = this.currMediaSizeName;
            s.currMediaTray = this.currMediaTray;
            s.currUnits = this.currUnits;
            return s;
        }
    }
}

