/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetPageColumns
extends PrintCommand {
    private PageColumn[] myCols;

    public SetPageColumns(GuiFactory gf, HandlesManager hndls, PageColumn[] classCols, boolean pComma, double start, double indent, double separation, Font font, int unit, char align, boolean transparency) {
        super(gf, 9);
        int fnd;
        int end = classCols == null ? 0 : classCols.length;
        for (fnd = 0; fnd < end && ((double)classCols[fnd].getStart() != start || classCols[fnd].getUnit() != unit); ++fnd) {
        }
        if (fnd == end) {
            this.myCols = new PageColumn[end + 1];
            for (int i = 0; i < end; ++i) {
                this.myCols[i] = classCols[i];
            }
            this.myCols[end] = new PageColumn(gf, hndls, pComma, (float)start, (float)indent, (float)separation, font, unit, align, transparency);
        } else {
            this.myCols = new PageColumn[end];
            for (int i = 0; i < end; ++i) {
                this.myCols[i] = classCols[i];
            }
            this.myCols[fnd] = new PageColumn(gf, hndls, pComma, (float)start, (float)indent, (float)separation, font, unit, align, transparency);
        }
    }

    public SetPageColumns(GuiFactory gf) {
        super(gf, 9);
        this.myCols = null;
    }

    public SetPageColumns(GuiFactory gf, HandlesManager hndls, RandomAccessFile inOut) throws IOException {
        super(gf, 9);
        int dim = inOut.readInt();
        if (dim >= 0) {
            this.myCols = new PageColumn[dim];
            for (int i = 0; i < this.myCols.length; ++i) {
                this.myCols[i] = new PageColumn(gf, hndls, inOut);
            }
        }
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        if (this.myCols != null) {
            inOut.writeInt(this.myCols.length);
            for (int i = 0; i < this.myCols.length; ++i) {
                this.myCols[i].toFile(inOut);
            }
        } else {
            inOut.writeInt(-1);
        }
    }

    public PageColumn get(int idx) {
        if (idx >= 0 && idx < this.myCols.length) {
            return this.myCols[idx];
        }
        return null;
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        pc.pgCols = this.getCols();
        return true;
    }

    PageColumn[] getCols() {
        PageColumn[] pgCols;
        if (this.myCols != null) {
            pgCols = new PageColumn[this.myCols.length];
            System.arraycopy(this.myCols, 0, pgCols, 0, this.myCols.length);
        } else {
            pgCols = null;
        }
        return pgCols;
    }
}

